/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.export.ExportToR;
import nl.mpi.kinnate.svg.DiagramTranscoder;
import nl.mpi.kinnate.ui.DiagramTranscoderPanel;
import nl.mpi.kinnate.ui.ImportSamplesFileMenu;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.menu.RecentFileMenu;
import nl.mpi.kinnate.ui.menu.SamplesFileMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMenu
extends JMenu {
    private JMenuItem importGedcomUrl;
    private JMenuItem importGedcomFile;
    private JMenuItem closeTabMenuItem;
    private JMenuItem entityUploadMenuItem;
    private JMenuItem exitApplication;
    private JMenuItem exportToR;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JMenuItem newDiagramMenuItem;
    private JMenuItem openDiagram;
    private RecentFileMenu recentFileMenu;
    private JMenuItem saveAsDefaultMenuItem;
    private JMenuItem saveDiagram;
    private JMenuItem saveDiagramAs;
    private JMenuItem savePdfMenuItem;
    private AbstractDiagramManager diagramWindowManager;
    private SessionStorage sessionStorage;
    private MessageDialogHandler dialogHandler;

    public FileMenu(AbstractDiagramManager diagramWindowManager, SessionStorage sessionStorage, MessageDialogHandler dialogHandler) {
        this.diagramWindowManager = diagramWindowManager;
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.diagramWindowManager = diagramWindowManager;
        this.importGedcomUrl = new JMenuItem();
        this.importGedcomFile = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.newDiagramMenuItem = new JMenuItem();
        this.jMenu3 = new DocumentNewMenu(diagramWindowManager);
        this.openDiagram = new JMenuItem();
        this.recentFileMenu = new RecentFileMenu(diagramWindowManager, sessionStorage);
        this.jMenu1 = new SamplesFileMenu(diagramWindowManager, dialogHandler);
        this.jMenu2 = new ImportSamplesFileMenu(diagramWindowManager);
        this.jSeparator2 = new JPopupMenu.Separator();
        this.entityUploadMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.saveDiagram = new JMenuItem();
        this.saveDiagramAs = new JMenuItem();
        this.savePdfMenuItem = new JMenuItem();
        this.exportToR = new JMenuItem();
        this.closeTabMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.saveAsDefaultMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.exitApplication = new JMenuItem();
        this.setText("File");
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                FileMenu.this.fileMenuMenuSelected(evt);
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.fileMenuActionPerformed(evt);
            }
        });
        this.newDiagramMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newDiagramMenuItem.setText("New (default diagram)");
        this.newDiagramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.newDiagramMenuItemActionPerformed(evt);
            }
        });
        this.add(this.newDiagramMenuItem);
        this.jMenu3.setText("New Diagram of Type");
        this.add(this.jMenu3);
        this.openDiagram.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openDiagram.setText("Open Diagram");
        this.openDiagram.setActionCommand("open");
        this.openDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.openDiagramActionPerformed(evt);
            }
        });
        this.add(this.openDiagram);
        this.add(this.recentFileMenu);
        this.jMenu1.setText("Open Sample Diagram");
        this.add(this.jMenu1);
        this.add(this.jSeparator1);
        this.importGedcomFile.setText("Import Gedcom / CSV File");
        this.importGedcomFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.importGedcomFileActionPerformed(evt);
            }
        });
        this.add(this.importGedcomFile);
        this.jMenu2.setText("Import Sample Data");
        this.add(this.jMenu2);
        this.importGedcomUrl.setText("Import Gedcom Samples (from internet)");
        this.importGedcomUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.importGedcomUrlActionPerformed(evt);
            }
        });
        this.importGedcomUrl.setEnabled(false);
        this.add(this.importGedcomUrl);
        this.add(this.jSeparator2);
        this.entityUploadMenuItem.setText("Entity Upload");
        this.entityUploadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.entityUploadMenuItemActionPerformed(evt);
            }
        });
        this.add(this.entityUploadMenuItem);
        this.add(this.jSeparator4);
        this.saveDiagram.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveDiagram.setText("Save");
        this.saveDiagram.setActionCommand("save");
        this.saveDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveDiagramActionPerformed(evt);
            }
        });
        this.add(this.saveDiagram);
        this.saveDiagramAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveDiagramAs.setText("Save As");
        this.saveDiagramAs.setActionCommand("saveas");
        this.saveDiagramAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveDiagramAsActionPerformed(evt);
            }
        });
        this.add(this.saveDiagramAs);
        this.savePdfMenuItem.setText("Export as PDF/JPEG/PNG/TIFF");
        this.savePdfMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.savePdfMenuItemActionPerformed(evt);
            }
        });
        this.add(this.savePdfMenuItem);
        this.exportToR.setText("Export for R / SPSS");
        this.exportToR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.exportToRActionPerformed(evt);
            }
        });
        this.add(this.exportToR);
        this.closeTabMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeTabMenuItem.setText("Close");
        this.closeTabMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.closeTabMenuItemActionPerformed(evt);
            }
        });
        this.add(this.closeTabMenuItem);
        this.add(this.jSeparator3);
        this.saveAsDefaultMenuItem.setText("Save as Default Diagram");
        this.saveAsDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveAsDefaultMenuItemActionPerformed(evt);
            }
        });
        this.add(this.saveAsDefaultMenuItem);
        this.add(this.jSeparator5);
        this.exitApplication.setText("Exit");
        this.exitApplication.setActionCommand("exit");
        this.exitApplication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.exitApplicationActionPerformed(evt);
            }
        });
        this.add(this.exitApplication);
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private HashMap<String, FileFilter> getSvgFileFilter() {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        for (final String[] currentType : new String[][]{{"Kinship Diagram (SVG format)", ".svg"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    String extensionLowerCase = currentType[1].toLowerCase();
                    return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        return fileFilterMap;
    }

    private void openDiagramActionPerformed(ActionEvent evt) {
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Open Diagram", false, true, this.getSvgFileFilter(), MessageDialogHandler.DialogueType.open, null);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                this.diagramWindowManager.openDiagram(selectedFile.getName(), selectedFile.toURI(), true);
            }
        }
    }

    private void saveDiagramActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        savePanel.saveToFile();
    }

    private void saveDiagramAsActionPerformed(ActionEvent evt) {
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Save Diagram As", false, false, this.getSvgFileFilter(), MessageDialogHandler.DialogueType.save, null);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                if (!selectedFile.getName().toLowerCase().endsWith(".svg")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".svg");
                }
                int tabIndex = Integer.valueOf(evt.getActionCommand());
                SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
                savePanel.saveToFile(selectedFile);
                RecentFileMenu.addRecentFile(this.sessionStorage, selectedFile);
                this.diagramWindowManager.setDiagramTitle(tabIndex, selectedFile.getName());
            }
        }
    }

    private void exitApplicationActionPerformed(ActionEvent evt) {
        if (this.diagramWindowManager.offerUserToSaveAll()) {
            System.exit(0);
        }
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        int selectedIndex = this.diagramWindowManager.getSavePanelIndex();
        SavePanel savePanel = null;
        if (selectedIndex > -1) {
            String currentTabText = this.diagramWindowManager.getSavePanelTitle(selectedIndex);
            savePanel = this.diagramWindowManager.getSavePanel(selectedIndex);
            this.saveDiagramAs.setText("Save As (" + currentTabText + ")");
            this.saveDiagramAs.setActionCommand(Integer.toString(selectedIndex));
            this.saveDiagram.setText("Save (" + currentTabText + ")");
            this.saveDiagram.setActionCommand(Integer.toString(selectedIndex));
            this.closeTabMenuItem.setText("Close (" + currentTabText + ")");
            this.closeTabMenuItem.setActionCommand(Integer.toString(selectedIndex));
            this.saveAsDefaultMenuItem.setText("Set Default Diagram as (" + currentTabText + ")");
            this.saveAsDefaultMenuItem.setActionCommand(Integer.toString(selectedIndex));
        }
        if (savePanel != null) {
            this.saveDiagram.setEnabled(savePanel.hasSaveFileName() && savePanel.requiresSave());
            this.saveDiagramAs.setEnabled(true);
            this.exportToR.setEnabled(true);
            this.closeTabMenuItem.setEnabled(true);
            this.saveAsDefaultMenuItem.setEnabled(true);
            this.savePdfMenuItem.setEnabled(true);
        } else {
            this.saveDiagramAs.setEnabled(false);
            this.saveDiagram.setEnabled(false);
            this.exportToR.setEnabled(false);
            this.closeTabMenuItem.setEnabled(false);
            this.saveAsDefaultMenuItem.setEnabled(false);
            this.savePdfMenuItem.setEnabled(false);
        }
    }

    private void closeTabMenuItemActionPerformed(ActionEvent evt) {
        String diagramTitle;
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        boolean userCanceled = this.diagramWindowManager.offerUserToSave(savePanel, diagramTitle = this.diagramWindowManager.getSavePanelTitle(tabIndex));
        if (!userCanceled) {
            this.diagramWindowManager.closeSavePanel(tabIndex);
        }
    }

    private void newDiagramMenuItemActionPerformed(ActionEvent evt) {
        this.diagramWindowManager.newDiagram();
    }

    private void importGedcomFileActionPerformed(ActionEvent evt) {
        HashMap<String, 16> fileFilterMap = new HashMap<String, 16>(2);
        fileFilterMap.put("importfiles", new FileFilter(){

            public boolean accept(File selectedFile) {
                if (selectedFile.isDirectory()) {
                    return true;
                }
                String currentFileName = selectedFile.getName().toLowerCase();
                if (currentFileName.endsWith(".gedcom")) {
                    return true;
                }
                if (currentFileName.endsWith(".txt")) {
                    return true;
                }
                return currentFileName.endsWith(".csv");
            }

            public String getDescription() {
                return "GEDCOM or CSV Kinship Data";
            }
        });
        File[] importFiles = this.dialogHandler.showFileSelectBox("Import Kinship Data", false, true, fileFilterMap, MessageDialogHandler.DialogueType.open, null);
        if (importFiles != null) {
            if (importFiles.length == 0) {
                this.dialogHandler.addMessageDialogToQueue("No files selected for import", "Import Kinship Data");
            } else {
                for (File importFile : importFiles) {
                    this.diagramWindowManager.openImportPanel(importFile);
                }
            }
        }
    }

    private void importCsvFileActionPerformed(ActionEvent evt) {
        this.importGedcomFileActionPerformed(evt);
    }

    private void importGedcomUrlActionPerformed(ActionEvent evt) {
        String[] importList;
        for (String importUrlString : importList = new String[]{"http://gedcomlibrary.com/gedcoms.html", "http://GedcomLibrary.com/gedcoms/gl120365.ged", "http://GedcomLibrary.com/gedcoms/gl120366.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120369.ged", "http://GedcomLibrary.com/gedcoms/gl120370.ged", "http://GedcomLibrary.com/gedcoms/gl120371.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/myline.ged", "http://gedcomlibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged"}) {
            this.diagramWindowManager.openImportPanel(importUrlString);
        }
    }

    private void savePdfMenuItemActionPerformed(ActionEvent evt) {
        DiagramTranscoder diagramTranscoder = new DiagramTranscoder(this.diagramWindowManager.getCurrentSavePanel());
        DiagramTranscoderPanel diagramTranscoderPanel = new DiagramTranscoderPanel(diagramTranscoder);
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Export as PDF/JPEG/PNG", false, false, null, MessageDialogHandler.DialogueType.save, (JComponent)diagramTranscoderPanel);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                diagramTranscoder.exportDiagram(selectedFile);
            }
        }
    }

    private void exportToRActionPerformed(ActionEvent evt) {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel();
        HashMap<String, 17> fileFilterMap = new HashMap<String, 17>(2);
        for (final String[] currentType : new String[][]{{"Data Frame Tab-separated Values", ".tab"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    String extensionLowerCase = currentType[1].toLowerCase();
                    return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Export Tab-separated Values", false, false, fileFilterMap, MessageDialogHandler.DialogueType.save, null);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                if (!selectedFile.getName().toLowerCase().endsWith(".tab")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".tab");
                }
                new ExportToR(this.sessionStorage, this.dialogHandler).doExport(this, currentSavePanel, selectedFile);
            }
        }
    }

    private void entityUploadMenuItemActionPerformed(ActionEvent evt) {
        this.diagramWindowManager.openEntityUploadPanel();
    }

    private void saveAsDefaultMenuItemActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        savePanel.saveToFile(KinDiagramPanel.getDefaultDiagramFile(this.sessionStorage));
    }
}

