/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;

public final class Repo {
    public final Context context;
    private final TokenObjMap<TokenSet> nsDict = new TokenObjMap();
    private final TokenMap pkgDict = new TokenMap();
    private boolean init;
    private IOFile path;

    public Repo(Context ctx) {
        this.context = ctx;
        this.path = new IOFile(ctx.mprop.get(MainProp.REPOPATH));
    }

    public TokenObjMap<TokenSet> nsDict() {
        this.init(null);
        return this.nsDict;
    }

    public TokenMap pkgDict() {
        this.init(null);
        return this.pkgDict;
    }

    public void init(String repo) {
        if (this.init) {
            return;
        }
        this.init = true;
        if (repo != null) {
            this.context.mprop.set(MainProp.REPOPATH, repo);
            this.path = new IOFile(repo);
        }
        IOFile[] iOFileArray = this.path.children();
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile dir = iOFileArray[n2];
            if (dir.isDir()) {
                this.readPkg(dir);
            }
            ++n2;
        }
    }

    public IOFile path(String pkg) {
        return new IOFile(this.path, pkg);
    }

    public synchronized void remove(Package pkg) {
        byte[] name = pkg.uniqueName();
        for (Package.Component comp : pkg.comps) {
            byte[] uri = comp.uri;
            TokenSet pkgs = this.nsDict.get(uri);
            if (pkgs.size() > 1) {
                pkgs.delete(name);
                continue;
            }
            this.nsDict.delete(uri);
        }
        this.pkgDict.delete(name);
    }

    public synchronized void add(Package pkg, String dir) {
        byte[] name = pkg.uniqueName();
        for (Package.Component comp : pkg.comps) {
            if (this.nsDict.id(comp.uri) == 0) {
                this.nsDict.add(comp.uri, new TokenSet(new byte[][]{name}));
                continue;
            }
            this.nsDict.get(comp.uri).add(name);
        }
        this.pkgDict.add(name, Token.token(dir));
    }

    private void readPkg(IOFile dir) {
        IOFile desc = new IOFile(dir, "expath-pkg.xml");
        if (desc.exists()) {
            try {
                Package pkg = new PkgParser(this.context.repo, null).parse(desc);
                byte[] name = pkg.uniqueName();
                for (Package.Component comp : pkg.comps) {
                    if (comp.uri == null) continue;
                    if (this.nsDict.id(comp.uri) != 0) {
                        this.nsDict.get(comp.uri).add(name);
                        continue;
                    }
                    this.nsDict.add(comp.uri, new TokenSet(new byte[][]{name}));
                }
                this.pkgDict.add(name, Token.token(dir.name()));
            }
            catch (QueryException ex) {
                Util.errln(ex.getMessage(), new Object[0]);
            }
        } else {
            Util.errln("Missing package descriptor for package '%'", dir);
        }
    }
}

