/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.plugins.KinOathPlugin;
import nl.mpi.kinnate.userstorage.KinSessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PluginLoader {
    private static final Class[] parameters = new Class[]{URL.class};
    private List<KinOathPlugin> pluginCollection = new ArrayList<KinOathPlugin>();
    private SessionStorage sessionStorage;

    public PluginLoader(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public void scanPluginsDirectory() throws IOException {
        File[] jarFiles;
        File pluginsDirectory = new File(this.sessionStorage.getStorageDirectory(), "Plugins");
        for (File pluginJar : jarFiles = pluginsDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            this.loadPluginFromJar(pluginJar);
        }
    }

    public void loadPluginFromJar(File pluginJar) throws IOException {
        List<String> classNames = this.getClassNames(pluginJar.getAbsolutePath());
        for (String className : classNames) {
            try {
                Class<?>[] interfaces;
                String name = className.substring(0, className.length() - 6);
                Class pluginClass = this.getPluginClass(pluginJar, name);
                for (Class<?> c : interfaces = pluginClass.getInterfaces()) {
                    if (!c.getName().equals("base.KinOathPlugin")) continue;
                    this.pluginCollection.add((KinOathPlugin)pluginClass.newInstance());
                }
            }
            catch (ClassNotFoundException exception) {
                exception.printStackTrace();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            catch (IllegalAccessException exception) {
                exception.printStackTrace();
            }
            catch (InstantiationException exception) {
                exception.printStackTrace();
            }
        }
    }

    protected List<String> getClassNames(String jarName) throws IOException {
        JarEntry jarEntry;
        ArrayList<String> classes = new ArrayList<String>();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            if (!jarEntry.getName().endsWith(".class")) continue;
            classes.add(jarEntry.getName().replaceAll("/", "\\."));
        }
        return classes;
    }

    public Class getPluginClass(File file, String name) throws ClassNotFoundException, IOException {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, file.toURI());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Failed to add the jar to the classloader");
        }
        String filePath = file.getAbsolutePath();
        filePath = "jar:file://" + filePath + "!/";
        URL url = new File(filePath).toURL();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
        Class<?> pluginClass = classLoader.loadClass(name);
        return pluginClass;
    }

    public List<KinOathPlugin> getPluginCollection() {
        return this.pluginCollection;
    }

    public void setPluginCollection(List<KinOathPlugin> pluginCollection) {
        this.pluginCollection = pluginCollection;
    }

    public static void main(String[] args) {
        try {
            new PluginLoader((SessionStorage)new KinSessionStorage(new ApplicationVersionManager((ApplicationVersion)new KinOathVersion()))).loadPluginFromJar(new File("/Users/petwit/Downloads/kinoath-testing 4.app/Contents/MacOS/kinoath-testing-0-7-28196.jar"));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

