/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LastItemExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Rounding;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterExpression
extends Expression
implements ContextSwitchingExpression {
    private Expression start;
    private Expression filter;
    private boolean filterIsPositional;
    private boolean filterIsSingletonBoolean;
    private boolean filterIsIndependentNumeric;
    public static final int FILTERED = 10000;

    public FilterExpression(Expression start, Expression filter) {
        this.start = start;
        this.filter = filter;
        this.adoptChildExpression(start);
        this.adoptChildExpression(filter);
        start.setFiltered(true);
    }

    @Override
    public String getExpressionName() {
        return "filter";
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.filter instanceof InstanceOfExpression && ((InstanceOfExpression)this.filter).getBaseExpression() instanceof ContextItemExpression) {
            return ((InstanceOfExpression)this.filter).getRequiredItemType();
        }
        return this.start.getItemType(th);
    }

    @Override
    public Expression getControllingExpression() {
        return this.start;
    }

    public boolean isFilterIsPositional() {
        return this.filterIsPositional;
    }

    @Override
    public Expression getControlledExpression() {
        return this.filter;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isPositional(TypeHierarchy th) {
        return FilterExpression.isPositionalFilter(this.filter, th);
    }

    public boolean isSimpleBooleanFilter() {
        return this.filterIsSingletonBoolean;
    }

    public boolean isIndependentNumericFilter() {
        return this.filterIsIndependentNumeric;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.start = visitor.simplify(this.start);
        this.filter = visitor.simplify(this.filter);
        if (Literal.isEmptySequence(this.start)) {
            return this.start;
        }
        if (this.filter instanceof Literal && !(((Literal)this.filter).getValue() instanceof NumericValue)) {
            try {
                if (this.filter.effectiveBooleanValue(visitor.getStaticContext().makeEarlyEvaluationContext())) {
                    return this.start;
                }
                return new Literal(EmptySequence.getInstance());
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
        }
        if (this.filter instanceof Last) {
            this.filter = new IsLastExpression(true);
            this.adoptChildExpression(this.filter);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression start2 = visitor.typeCheck(this.start, contextItemType);
        if (start2 != this.start) {
            this.start = start2;
            this.adoptChildExpression(start2);
        }
        this.start.setFiltered(true);
        Expression filter2 = visitor.typeCheck(this.filter, new ExpressionVisitor.ContextItemType(this.start.getItemType(th), false));
        if (filter2 != this.filter) {
            this.filter = filter2;
            this.adoptChildExpression(filter2);
        }
        if ((filter2 = ExpressionTool.unsortedIfHomogeneous(visitor.getConfiguration().obtainOptimizer(), this.filter)) != this.filter) {
            this.filter = filter2;
            this.adoptChildExpression(filter2);
        }
        if (Literal.isConstantOne(this.filter)) {
            Expression fie = FirstItemExpression.makeFirstItemExpression(this.start);
            ExpressionTool.copyLocationInfo(this, fie);
            return fie;
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, th);
        this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(th).equals(BuiltInAtomicType.BOOLEAN);
        this.filterIsIndependentNumeric = th.isSubType(this.filter.getItemType(th), BuiltInAtomicType.NUMERIC) && (this.filter.getDependencies() & 6) == 0 && !Cardinality.allowsMany(this.filter.getCardinality());
        visitor.resetStaticProperties();
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Value value;
        Expression result;
        Expression subsequence;
        ItemType filterType;
        Expression originalFilter;
        StaticContext env = visitor.getStaticContext();
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        boolean debug = visitor.getConfiguration().isOptimizerTracing();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression start2 = visitor.optimize(this.start, contextItemType);
        if (start2 != this.start) {
            this.start = start2;
            this.adoptChildExpression(start2);
        }
        this.start.setFiltered(true);
        try {
            originalFilter = this.filter.copy();
        }
        catch (UnsupportedOperationException err) {
            originalFilter = null;
        }
        ExpressionVisitor.ContextItemType baseItemType = new ExpressionVisitor.ContextItemType(this.start.getItemType(th), false);
        Expression filter2 = this.filter.optimize(visitor, baseItemType);
        if (filter2 != this.filter) {
            this.filter = filter2;
            this.adoptChildExpression(filter2);
        }
        if ((filter2 = ExpressionTool.unsortedIfHomogeneous(opt, this.filter)) != this.filter) {
            this.filter = filter2;
            this.adoptChildExpression(filter2);
        }
        if (!th.isSubType(filterType = this.filter.getItemType(th), BuiltInAtomicType.BOOLEAN) && th.relationship(filterType, BuiltInAtomicType.NUMERIC) == 4) {
            BooleanFn f = (BooleanFn)SystemFunction.makeSystemFunction("boolean", new Expression[]{this.filter});
            this.filter = visitor.optimize(f, baseItemType);
        }
        if (this.filter instanceof Literal && ((Literal)this.filter).getValue() instanceof BooleanValue) {
            if (((BooleanValue)((Literal)this.filter).getValue()).getBooleanValue()) {
                if (debug) {
                    opt.trace("Redundant filter removed", this.start);
                }
                return this.start;
            }
            if (debug) {
                opt.trace("Filter expression eliminated because predicate is always false", new Literal(EmptySequence.getInstance()));
            }
            return new Literal(EmptySequence.getInstance());
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, th);
        boolean bl = this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(th).equals(BuiltInAtomicType.BOOLEAN);
        if (!this.filterIsPositional) {
            Expression f;
            int origIndexable;
            int isIndexable = opt.isIndexableFilter(this.filter);
            if (isIndexable == 0 && this.filter != originalFilter && originalFilter != null && (origIndexable = opt.isIndexableFilter(originalFilter)) != 0) {
                isIndexable = origIndexable;
                this.filter = originalFilter;
                this.adoptChildExpression(originalFilter);
            }
            if (isIndexable != 0 && (f = opt.tryIndexedFilter(this, visitor, isIndexable > 0)) != this) {
                return f.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        if (this.filterIsPositional && this.filter instanceof BooleanExpression && ((BooleanExpression)this.filter).operator == 10) {
            BooleanExpression bf = (BooleanExpression)this.filter;
            if (FilterExpression.isExplicitlyPositional(bf.operand0) && !FilterExpression.isExplicitlyPositional(bf.operand1)) {
                Expression p0 = FilterExpression.forceToBoolean(bf.operand0, env.getConfiguration());
                Expression p1 = FilterExpression.forceToBoolean(bf.operand1, env.getConfiguration());
                FilterExpression f1 = new FilterExpression(this.start, p0);
                ExpressionTool.copyLocationInfo(this, f1);
                FilterExpression f2 = new FilterExpression(f1, p1);
                ExpressionTool.copyLocationInfo(this, f2);
                if (debug) {
                    opt.trace("Composite filter replaced by nested filter expressions", f2);
                }
                return visitor.optimize(f2, contextItemType);
            }
            if (FilterExpression.isExplicitlyPositional(bf.operand1) && !FilterExpression.isExplicitlyPositional(bf.operand0)) {
                Expression p0 = FilterExpression.forceToBoolean(bf.operand0, env.getConfiguration());
                Expression p1 = FilterExpression.forceToBoolean(bf.operand1, env.getConfiguration());
                FilterExpression f1 = new FilterExpression(this.start, p1);
                ExpressionTool.copyLocationInfo(this, f1);
                FilterExpression f2 = new FilterExpression(f1, p0);
                ExpressionTool.copyLocationInfo(this, f2);
                if (debug) {
                    opt.trace("Composite filter replaced by nested filter expressions", f2);
                }
                return visitor.optimize(f2, contextItemType);
            }
        }
        if (this.filter instanceof IsLastExpression && ((IsLastExpression)this.filter).getCondition()) {
            if (this.start instanceof Literal) {
                this.filter = Literal.makeLiteral(new Int64Value(((Literal)this.start).getValue().getLength()));
            } else {
                return new LastItemExpression(this.start);
            }
        }
        if ((subsequence = this.tryToRewritePositionalFilter(visitor)) != null) {
            if (debug) {
                opt.trace("Rewrote Filter Expression as:", subsequence);
            }
            ExpressionTool.copyLocationInfo(this, subsequence);
            return subsequence.simplify(visitor).typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        filter2 = this.doPromotion(this.filter, offer);
        if (filter2 != this.filter) {
            this.filter = filter2;
            this.adoptChildExpression(filter2);
        }
        if (offer.containingExpression instanceof LetExpression) {
            if (debug) {
                opt.trace("Subexpression extracted from filter because independent of context", offer.containingExpression);
            }
            offer.containingExpression = visitor.optimize(offer.containingExpression, contextItemType);
        }
        if ((result = offer.containingExpression) instanceof FilterExpression && (value = ((FilterExpression)result).tryEarlyEvaluation(visitor)) != null) {
            return new Literal(value);
        }
        return result;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.start.getIntegerBounds();
    }

    private Value tryEarlyEvaluation(ExpressionVisitor visitor) throws XPathException {
        try {
            if (this.start instanceof Literal && (this.filter.getDependencies() & 0xFFFFFFE1) == 0) {
                XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
                return (Value)SequenceExtent.makeSequenceExtent(this.iterate(context));
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.start.addToPathMap(pathMap, pathMapNodeSet);
        this.filter.addToPathMap(pathMap, target);
        return target;
    }

    private static Expression forceToBoolean(Expression in, Configuration config) {
        TypeHierarchy th = config.getTypeHierarchy();
        if (in.getItemType(th).getPrimitiveType() == 514) {
            return in;
        }
        return SystemFunction.makeSystemFunction("boolean", new Expression[]{in});
    }

    private Expression tryToRewritePositionalFilter(ExpressionVisitor visitor) throws XPathException {
        if (visitor.isOptimizeForStreaming()) {
            return null;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.filter instanceof Literal) {
            Value val = ((Literal)this.filter).getValue();
            if (val instanceof NumericValue) {
                if (((NumericValue)val).isWholeNumber()) {
                    long lvalue = ((NumericValue)val).longValue();
                    if (lvalue <= 0L) {
                        return Literal.makeEmptySequence();
                    }
                    if (lvalue == 1L) {
                        return FirstItemExpression.makeFirstItemExpression(this.start);
                    }
                    return visitor.getConfiguration().getVendorFunctionLibrary().makeSaxonFunction("item-at", new Expression[]{this.start, this.filter}, visitor.getStaticContext(), this.getContainer());
                }
                return Literal.makeEmptySequence();
            }
            return val.effectiveBooleanValue() ? this.start : Literal.makeEmptySequence();
        }
        if (th.isSubType(this.filter.getItemType(th), BuiltInAtomicType.NUMERIC) && this.filter.getCardinality() == 16384 && (this.filter.getDependencies() & 0x1E) == 0) {
            return visitor.getConfiguration().getVendorFunctionLibrary().makeSaxonFunction("item-at", new Expression[]{this.start, this.filter}, visitor.getStaticContext(), this.getContainer());
        }
        if (this.filter instanceof ComparisonExpression) {
            Expression comparand;
            VendorFunctionLibrary lib = visitor.getConfiguration().getVendorFunctionLibrary();
            StaticContext env = visitor.getStaticContext();
            Expression[] operands = ((ComparisonExpression)((Object)this.filter)).getOperands();
            int operator = ((ComparisonExpression)((Object)this.filter)).getSingletonOperator();
            if (operands[0] instanceof Position && th.isSubType(operands[1].getItemType(th), BuiltInAtomicType.NUMERIC)) {
                comparand = operands[1];
            } else if (operands[1] instanceof Position && th.isSubType(operands[0].getItemType(th), BuiltInAtomicType.NUMERIC)) {
                comparand = operands[0];
                operator = Token.inverse(operator);
            } else {
                return null;
            }
            if (ExpressionTool.dependsOnFocus(comparand)) {
                return null;
            }
            int card = comparand.getCardinality();
            if (Cardinality.allowsMany(card)) {
                return null;
            }
            if (Cardinality.allowsZero(card)) {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(th), card));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                comparand = new LocalVariableReference(let);
                LocalVariableReference existsArg = new LocalVariableReference(let);
                Exists exists = (Exists)SystemFunction.makeSystemFunction("exists", new Expression[]{existsArg});
                Expression rewrite = FilterExpression.tryToRewritePositionalFilterSupport(this.start, comparand, operator, th, lib, env);
                if (rewrite == null) {
                    return this;
                }
                Expression choice = Choose.makeConditional(exists, rewrite);
                let.setAction(choice);
                return let;
            }
            return FilterExpression.tryToRewritePositionalFilterSupport(this.start, comparand, operator, th, lib, env);
        }
        if (this.filter instanceof IntegerRangeTest) {
            Expression val = ((IntegerRangeTest)this.filter).getValueExpression();
            if (!(val instanceof Position)) {
                return null;
            }
            Expression min = ((IntegerRangeTest)this.filter).getMinValueExpression();
            Expression max = ((IntegerRangeTest)this.filter).getMaxValueExpression();
            if (ExpressionTool.dependsOnFocus(min)) {
                return null;
            }
            if (ExpressionTool.dependsOnFocus(max)) {
                if (max instanceof Last) {
                    return SystemFunction.makeSystemFunction("subsequence", new Expression[]{this.start, min});
                }
                return null;
            }
            LetExpression let = new LetExpression();
            let.setRequiredType(SequenceType.SINGLE_INTEGER);
            let.setVariableQName(new StructuredQName("nn", "http://saxon.sf.net/", "nn" + let.hashCode()));
            let.setSequence(min);
            min = new LocalVariableReference(let);
            LocalVariableReference min2 = new LocalVariableReference(let);
            ArithmeticExpression minMinusOne = new ArithmeticExpression(min2, 16, new Literal(Int64Value.makeIntegerValue(1L)));
            ArithmeticExpression length = new ArithmeticExpression(max, 16, minMinusOne);
            Subsequence subs = (Subsequence)SystemFunction.makeSystemFunction("subsequence", new Expression[]{this.start, min, length});
            let.setAction(subs);
            return let;
        }
        return null;
    }

    private static Expression tryToRewritePositionalFilterSupport(Expression start, Expression comparand, int operator, TypeHierarchy th, VendorFunctionLibrary lib, StaticContext env) throws XPathException {
        if (th.isSubType(comparand.getItemType(th), BuiltInAtomicType.INTEGER)) {
            switch (operator) {
                case 50: {
                    if (Literal.isConstantOne(comparand)) {
                        return FirstItemExpression.makeFirstItemExpression(start);
                    }
                    return lib.makeSaxonFunction("item-at", new Expression[]{start, comparand}, env, start.getContainer());
                }
                case 53: {
                    Expression[] args = new Expression[3];
                    args[0] = start;
                    args[1] = new Literal(Int64Value.makeIntegerValue(1L));
                    if (Literal.isAtomic(comparand)) {
                        long n = ((NumericValue)((Literal)comparand).getValue()).longValue();
                        args[2] = new Literal(Int64Value.makeIntegerValue(n - 1L));
                    } else {
                        args[2] = new ArithmeticExpression(comparand, 16, new Literal(Int64Value.makeIntegerValue(1L)));
                    }
                    return SystemFunction.makeSystemFunction("subsequence", args);
                }
                case 55: {
                    Expression[] args = new Expression[]{start, new Literal(Int64Value.makeIntegerValue(1L)), comparand};
                    return SystemFunction.makeSystemFunction("subsequence", args);
                }
                case 51: {
                    return SystemFunction.makeSystemFunction("remove", new Expression[]{start, comparand});
                }
                case 52: {
                    Expression[] args = new Expression[2];
                    args[0] = start;
                    if (Literal.isAtomic(comparand)) {
                        long n = ((NumericValue)((Literal)comparand).getValue()).longValue();
                        args[1] = new Literal(Int64Value.makeIntegerValue(n + 1L));
                    } else {
                        args[1] = new ArithmeticExpression(comparand, 15, new Literal(Int64Value.makeIntegerValue(1L)));
                    }
                    return SystemFunction.makeSystemFunction("subsequence", args);
                }
                case 54: {
                    return SystemFunction.makeSystemFunction("subsequence", new Expression[]{start, comparand});
                }
            }
            throw new IllegalArgumentException("operator");
        }
        switch (operator) {
            case 50: {
                return lib.makeSaxonFunction("item-at", new Expression[]{start, comparand}, env, start.getContainer());
            }
            case 53: {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(th), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference arithArg = new LocalVariableReference(let);
                LocalVariableReference floorArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env, start.getContainer());
                ArithmeticExpression minusOne = new ArithmeticExpression(arithArg, 16, new Literal(Int64Value.makeIntegerValue(1L)));
                Rounding floor = (Rounding)SystemFunction.makeSystemFunction("floor", new Expression[]{floorArg});
                Expression choice = Choose.makeConditional(isWhole, minusOne, floor);
                Subsequence subs = (Subsequence)SystemFunction.makeSystemFunction("subsequence", new Expression[]{start, new Literal(Int64Value.makeIntegerValue(1L)), choice});
                let.setAction(subs);
                return let;
            }
            case 55: {
                Rounding floor = (Rounding)SystemFunction.makeSystemFunction("floor", new Expression[]{comparand});
                return SystemFunction.makeSystemFunction("subsequence", new Expression[]{start, new Literal(Int64Value.makeIntegerValue(1L)), floor});
            }
            case 51: {
                LetExpression let = new LetExpression();
                ExpressionTool.copyLocationInfo(start, let);
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(th), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference castArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env, start.getContainer());
                ExpressionTool.copyLocationInfo(start, isWhole);
                CastExpression cast = new CastExpression(castArg, BuiltInAtomicType.INTEGER, false);
                ExpressionTool.copyLocationInfo(start, cast);
                Expression choice = Choose.makeConditional(isWhole, cast, new Literal(Int64Value.makeIntegerValue(0L)));
                Remove rem = (Remove)SystemFunction.makeSystemFunction("remove", new Expression[]{start, choice});
                let.setAction(rem);
                return let;
            }
            case 52: {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(th), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference arithArg = new LocalVariableReference(let);
                LocalVariableReference ceilingArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env, start.getContainer());
                ArithmeticExpression plusOne = new ArithmeticExpression(arithArg, 15, new Literal(Int64Value.makeIntegerValue(1L)));
                Rounding ceiling = (Rounding)SystemFunction.makeSystemFunction("ceiling", new Expression[]{ceilingArg});
                Expression choice = Choose.makeConditional(isWhole, plusOne, ceiling);
                Subsequence subs = (Subsequence)SystemFunction.makeSystemFunction("subsequence", new Expression[]{start, choice});
                let.setAction(subs);
                return let;
            }
            case 54: {
                Rounding ceiling = (Rounding)SystemFunction.makeSystemFunction("ceiling", new Expression[]{comparand});
                return SystemFunction.makeSystemFunction("subsequence", new Expression[]{start, ceiling});
            }
        }
        throw new IllegalArgumentException("operator");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action == 11 && this.start instanceof FilterExpression) {
            TypeHierarchy th = offer.getOptimizer().getConfiguration().getTypeHierarchy();
            FilterExpression newfe = this.promoteIndependentPredicates(offer.bindingList, offer.getOptimizer(), th);
            if (newfe != this) {
                return newfe.promote(offer, parent);
            }
        }
        if (offer.action != 13 || !this.filterIsPositional) {
            this.start = this.doPromotion(this.start, offer);
        }
        if (offer.action == 14) {
            this.filter = this.doPromotion(this.filter, offer);
        } else if (offer.action == 12) {
            this.filter = this.doPromotion(this.filter, offer);
        }
        return this;
    }

    private FilterExpression promoteIndependentPredicates(Binding[] bindings, Optimizer opt, TypeHierarchy th) {
        if (!ExpressionTool.dependsOnVariable(this.start, bindings)) {
            return this;
        }
        if (this.isPositional(th)) {
            return this;
        }
        if (this.start instanceof FilterExpression) {
            FilterExpression fe = (FilterExpression)this.start;
            if (fe.isPositional(th)) {
                return this;
            }
            if (!ExpressionTool.dependsOnVariable(fe.filter, bindings)) {
                return this;
            }
            if (!ExpressionTool.dependsOnVariable(this.filter, bindings)) {
                FilterExpression result = new FilterExpression(new FilterExpression(fe.start, this.filter).promoteIndependentPredicates(bindings, opt, th), fe.filter);
                opt.trace("Reordered filter predicates:", result);
                return result;
            }
        }
        return this;
    }

    private static boolean isPositionalFilter(Expression exp, TypeHierarchy th) {
        ItemType type = exp.getItemType(th);
        if (type.equals(BuiltInAtomicType.BOOLEAN)) {
            return FilterExpression.isExplicitlyPositional(exp);
        }
        return type.equals(BuiltInAtomicType.ANY_ATOMIC) || type instanceof AnyItemType || type.equals(BuiltInAtomicType.INTEGER) || type.equals(BuiltInAtomicType.NUMERIC) || th.isSubType(type, BuiltInAtomicType.NUMERIC) || FilterExpression.isExplicitlyPositional(exp);
    }

    private static boolean isExplicitlyPositional(Expression exp) {
        return (exp.getDependencies() & 0xC) != 0;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.start, this.filter);
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        return new MonoIterator<Expression>(this.start);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.filter;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.start = replacement;
            found = true;
        }
        if (this.filter == original) {
            this.filter = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int computeCardinality() {
        if (this.filter instanceof Literal && ((Literal)this.filter).getValue() instanceof NumericValue) {
            if (((NumericValue)((Literal)this.filter).getValue()).compareTo(1L) == 0 && !Cardinality.allowsZero(this.start.getCardinality())) {
                return 16384;
            }
            return 24576;
        }
        if (this.filterIsIndependentNumeric) {
            return 24576;
        }
        if (this.filter instanceof IsLastExpression && ((IsLastExpression)this.filter).getCondition()) {
            return this.start.getCardinality() & 0xFFFF7FFF;
        }
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        return this.start.getSpecialProperties();
    }

    public boolean equals(Object other) {
        if (other instanceof FilterExpression) {
            FilterExpression f = (FilterExpression)other;
            return this.start.equals(f.start) && this.filter.equals(f.filter);
        }
        return false;
    }

    public int hashCode() {
        return "FilterExpression".hashCode() + this.start.hashCode() + this.filter.hashCode();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> base;
        Expression startExp = this.start;
        Value<? extends Item> startValue = null;
        if (startExp instanceof Literal) {
            startValue = ((Literal)startExp).getValue();
        } else if (startExp instanceof VariableReference) {
            startValue = Value.asValue(((VariableReference)startExp).evaluateVariable(context));
            startExp = new Literal(startValue);
        }
        if (startValue instanceof EmptySequence) {
            return EmptyIterator.getInstance();
        }
        ValueRepresentation<Object> filterValue = null;
        if (this.filter instanceof Literal) {
            filterValue = ((Literal)this.filter).getValue();
        } else if (this.filter instanceof VariableReference) {
            filterValue = ((VariableReference)this.filter).evaluateVariable(context);
        }
        if (filterValue != null) {
            if (filterValue instanceof Value) {
                boolean b;
                if ((filterValue = ((Value)filterValue).reduce()) instanceof NumericValue) {
                    if (((NumericValue)filterValue).isWholeNumber()) {
                        int pos = (int)((NumericValue)filterValue).longValue();
                        if (startValue != null) {
                            return SingletonIterator.makeIterator(startValue.itemAt(pos - 1));
                        }
                        if (pos > 0) {
                            SequenceIterator<? extends Item> base2 = startExp.iterate(context);
                            return SubsequenceIterator.make(base2, pos, pos);
                        }
                        return EmptyIterator.getInstance();
                    }
                    return EmptyIterator.getInstance();
                }
                try {
                    b = ((Value)filterValue).effectiveBooleanValue();
                }
                catch (XPathException err) {
                    err.maybeSetLocation(this);
                    throw err;
                }
                if (b) {
                    return this.start.iterate(context);
                }
                return EmptyIterator.getInstance();
            }
            if (filterValue instanceof NodeInfo) {
                return this.start.iterate(context);
            }
        }
        if ((base = startExp.iterate(context)) instanceof EmptyIterator) {
            return base;
        }
        if (this.filterIsPositional && !this.filterIsSingletonBoolean) {
            return new FilterIterator(base, this.filter, context);
        }
        return new FilterIterator.NonNumeric(base, this.filter, context);
    }

    @Override
    public int computeDependencies() {
        return this.start.getDependencies() | this.filter.getDependencies() & 0x3E1;
    }

    @Override
    public Expression copy() {
        FilterExpression fe = new FilterExpression(this.start.copy(), this.filter.copy());
        fe.filterIsIndependentNumeric = this.filterIsIndependentNumeric;
        fe.filterIsPositional = this.filterIsPositional;
        fe.filterIsSingletonBoolean = this.filterIsSingletonBoolean;
        return fe;
    }

    @Override
    public String toString() {
        return "(" + this.start.toString() + "[" + this.filter.toString() + "])";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("filterExpression");
        this.start.explain(out);
        this.filter.explain(out);
        out.endElement();
    }
}

