/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.index.ValuesToken;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class IndexAccess
extends Single {
    final IndexContext ictx;
    final IndexToken.IndexType itype;

    public IndexAccess(InputInfo ii, Expr e, IndexToken.IndexType t, IndexContext ic) {
        super(ii, e);
        this.itype = t;
        this.ictx = ic;
        this.type = SeqType.NOD_ZM;
    }

    @Override
    public NodeIter iter(QueryContext ctx) throws QueryException {
        Item it;
        Iter[] iter = new NodeIter[]{};
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            int s = iter.length;
            NodeIter[] tmp = new NodeIter[s + 1];
            System.arraycopy(iter, 0, tmp, 0, s);
            iter = tmp;
            iter[s] = this.index(it.atom(this.input));
        }
        return iter.length == 0 ? new NodeCache() : (iter.length == 1 ? iter[0] : new Union(this.input, this.expr).eval(iter));
    }

    private AxisIter index(byte[] term) {
        final Data data = this.ictx.data;
        final IndexIterator ii = term.length <= 96 && (this.itype == IndexToken.IndexType.TEXT ? data.meta.textindex : data.meta.attrindex) ? data.ids(new ValuesToken(this.itype, term)) : this.scan(term);
        return new AxisIter(){
            final byte kind;
            final boolean mem;
            {
                this.kind = (byte)(IndexAccess.this.itype == IndexToken.IndexType.TEXT ? 2 : 3);
                this.mem = data2 instanceof MemData;
            }

            @Override
            public ANode next() {
                while (ii.more()) {
                    int p = ii.next();
                    if (this.mem && data.kind(p) != this.kind) continue;
                    return new DBNode(data, p, this.kind);
                }
                return null;
            }
        };
    }

    private IndexIterator scan(final byte[] val) {
        return new IndexIterator(){
            final byte kind;
            final boolean text;
            final Data data;
            int pre;
            {
                this.kind = (byte)(IndexAccess.this.itype == IndexToken.IndexType.TEXT ? 2 : 3);
                this.text = IndexAccess.this.itype == IndexToken.IndexType.TEXT;
                this.data = IndexAccess.this.ictx.data;
                this.pre = -1;
            }

            @Override
            public double score() {
                return -1.0;
            }

            @Override
            public int next() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.data.meta.size) {
                    if (this.data.kind(this.pre) != this.kind || !Token.eq(this.data.text(this.pre, this.text), val)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public boolean iterable() {
        return this.ictx.iterable;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.DATA, Token.token(this.ictx.data.meta.name), QueryText.TYP, Token.token(this.itype.toString())});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        return (this.itype == IndexToken.IndexType.TEXT ? Function.DBTEXT : Function.DBATTR).get(this.input, Str.get(this.ictx.data.meta.name), this.expr).toString();
    }
}

