/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Stack;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNSimple
extends FuncCall {
    public FNSimple(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case ONEORMORE: {
                final Iter ir = this.expr[0].iter(ctx);
                long len = ir.size();
                if (len == 0L) {
                    throw Err.EXPECTOM.thrw(this.input, new Object[0]);
                }
                if (len > 0L) {
                    return ir;
                }
                return new Iter(){
                    private boolean first = true;

                    @Override
                    public Item next() throws QueryException {
                        Item it = ir.next();
                        if (this.first) {
                            if (it == null) {
                                throw Err.EXPECTOM.thrw(FNSimple.this.input, new Object[0]);
                            }
                            this.first = false;
                        }
                        return it;
                    }
                };
            }
            case UNORDER: {
                return ctx.iter(this.expr[0]);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case ONEORMORE: {
                Value val = ctx.value(this.expr[0]);
                if (val.empty()) {
                    throw Err.EXPECTOM.thrw(this.input, new Object[0]);
                }
                return val;
            }
            case UNORDER: {
                return ctx.value(this.expr[0]);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr.length == 1 ? this.expr[0] : null;
        switch (this.def) {
            case FALSE: {
                return Bln.FALSE;
            }
            case TRUE: {
                return Bln.TRUE;
            }
            case EMPTY: {
                return Bln.get(e.iter(ctx).next() == null);
            }
            case EXISTS: {
                return Bln.get(e.iter(ctx).next() != null);
            }
            case BOOLEAN: {
                return Bln.get(e.ebv(ctx, this.input).bool(this.input));
            }
            case NOT: {
                return Bln.get(!e.ebv(ctx, this.input).bool(this.input));
            }
            case DEEPEQUAL: {
                return Bln.get(this.deep(ctx));
            }
            case ZEROORONE: {
                Iter ir = e.iter(ctx);
                Item it = ir.next();
                if (it != null && ir.next() != null) {
                    Err.EXPECTZ0.thrw(this.input, new Object[0]);
                }
                return it;
            }
            case EXACTLYONE: {
                Iter ir = e.iter(ctx);
                Item it = ir.next();
                if (it == null || ir.next() != null) {
                    Err.EXPECTO.thrw(this.input, new Object[0]);
                }
                return it;
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Expr cmp(QueryContext ctx) {
        Expr e = this.expr[0];
        switch (this.def) {
            case EMPTY: 
            case EXISTS: {
                return e.size() == -1L || e.uses(Expr.Use.CTX) ? this : Bln.get(this.def == Function.EMPTY ^ e.size() != 0L);
            }
            case BOOLEAN: {
                return e.type().eq(SeqType.BLN) ? e : this;
            }
            case NOT: {
                if (e.isFun(Function.EMPTY)) {
                    ctx.compInfo("rewriting %", this);
                    this.expr = ((FuncCall)e).expr;
                    this.def = Function.EXISTS;
                } else if (e.isFun(Function.EXISTS)) {
                    ctx.compInfo("rewriting %", this);
                    this.expr = ((FuncCall)e).expr;
                    this.def = Function.EMPTY;
                } else {
                    if (e instanceof CmpV || e instanceof CmpG) {
                        Cmp c = ((Cmp)e).invert();
                        return c == e ? this : c;
                    }
                    if (e.isFun(Function.NOT)) {
                        return this.compBln(((FuncCall)e).expr[0]);
                    }
                    this.expr[0] = e.compEbv(ctx);
                }
                return this;
            }
            case ZEROORONE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.ZO);
                return e.type().zeroOrOne() ? e : this;
            }
            case EXACTLYONE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.O);
                return e.type().one() ? e : this;
            }
            case ONEORMORE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.OM);
                return !e.type().mayBeZero() ? e : this;
            }
            case UNORDER: {
                return e;
            }
        }
        return this;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        Expr e = this.expr[0];
        Expr ex = this;
        if (this.def == Function.BOOLEAN) {
            if (!e.type().mayBeNum()) {
                ex = e;
            }
        } else if (this.def == Function.EXISTS && (e.type().type.node() || e.size() > 0L)) {
            ex = e;
        }
        if (ex != this) {
            ctx.compInfo("rewriting %", this);
        }
        return ex;
    }

    private boolean deep(QueryContext ctx) throws QueryException {
        if (this.expr.length == 3) {
            this.checkColl(this.expr[2], ctx);
        }
        return FNSimple.deep(this.input, ctx.iter(this.expr[0]), ctx.iter(this.expr[1]));
    }

    public static boolean deep(InputInfo ii, Iter iter1, Iter iter2) throws QueryException {
        while (true) {
            Item it1 = iter1.next();
            Item it2 = iter2.next();
            if (it1 == null) {
                if (it2 == null) {
                    return true;
                }
                if (it2.func()) {
                    Err.FNCMP.thrw(ii, it2);
                }
                return false;
            }
            if (it2 == null) {
                if (it1.func()) {
                    Err.FNCMP.thrw(ii, it1);
                }
                return false;
            }
            if (it1.func() || it2.func()) {
                if (it1.map() && it2.map()) {
                    Map map1 = (Map)it1;
                    Map map2 = (Map)it2;
                    if (map1.deep(ii, map2)) continue;
                    return false;
                }
                Err.FNCMP.thrw(ii, it1.func() ? it1 : it2);
            }
            if (!it1.node() && !it2.node()) {
                if (it1.equiv(ii, it2)) continue;
                return false;
            }
            if (it1.type != it2.type) {
                return false;
            }
            ANode s1 = (ANode)it1;
            ANode s2 = (ANode)it2;
            Stack<AxisIter[]> chld = new Stack<AxisIter[]>();
            AxisIter[] ch = new AxisIter[]{s1.children(), s2.children()};
            chld.push(ch);
            boolean desc = false;
            do {
                Type t2;
                Type t1 = s1 != null ? s1.type : null;
                Type type = t2 = s2 != null ? s2.type : null;
                if (desc) {
                    if (t1 == NodeType.PI || t1 == NodeType.COM) {
                        s1 = ch[0].next();
                        continue;
                    }
                    if (t2 == NodeType.PI || t2 == NodeType.COM) {
                        s2 = ch[1].next();
                        continue;
                    }
                }
                if (s1 == null || s2 == null) {
                    if (s1 != s2) {
                        return false;
                    }
                    ch = (AxisIter[])chld.pop();
                } else {
                    QNm n1 = s1.qname();
                    QNm n2 = s2.qname();
                    if (n1 != null && n2 != null && !n1.eq(n2)) {
                        return false;
                    }
                    if (!(t1 != NodeType.TXT && t1 != NodeType.ATT && t1 != NodeType.COM && t1 != NodeType.PI || Token.eq(s1.atom(), s2.atom()))) {
                        return false;
                    }
                    if (t1 == NodeType.ELM) {
                        ANode a1;
                        if (s1.attributes().finish().size() != s2.attributes().finish().size()) {
                            return false;
                        }
                        AxisIter att1 = s1.attributes();
                        while ((a1 = att1.next()) != null) {
                            ANode a2;
                            AxisIter att2 = s2.attributes();
                            boolean f = false;
                            while ((a2 = att2.next()) != null) {
                                if (!a1.qname().eq(a2.qname())) continue;
                                f = Token.eq(a1.atom(), a2.atom());
                                break;
                            }
                            if (f) continue;
                            return false;
                        }
                        chld.push(ch);
                        ch = new AxisIter[]{s1.children(), s2.children()};
                    }
                }
                s1 = ch[0].next();
                s2 = ch[1].next();
                desc = true;
            } while (!chld.isEmpty());
        }
    }
}

