/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.CmdiHeaderInfo;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilEntityResolver;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.FieldUpdateRequest;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilComponentBuilder {
    public static final String CMD_NAMESPACE = "http://www.clarin.eu/cmd/";
    public static final String RESOURCE_ID_PREFIX = "res_";
    private static MessageDialogHandler messageDialogHandler;
    private static SessionStorage sessionStorage;
    private static DataNodeLoader dataNodeLoader;
    private HashMap<ArbilDataNode, SchemaType> nodeSchemaTypeMap = new HashMap();
    private static final Pattern attributePathPattern;
    private static final Pattern namespacePartPattern;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static Document getDocument(URI inputUri) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (inputUri == null) {
            document = documentBuilder.newDocument();
        } else {
            String decodeUrlString = URLDecoder.decode(inputUri.toString(), "UTF-8");
            document = documentBuilder.parse(decodeUrlString);
        }
        return document;
    }

    public static void savePrettyFormatting(Document document, File outputFile) {
        try {
            if (outputFile.getPath().endsWith(".imdi")) {
                ArbilComponentBuilder.removeImdiDomIds(document);
            }
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            StreamResult xmlOutput = new StreamResult(fileOutputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(dOMSource, xmlOutput);
            xmlOutput.getOutputStream().close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BugCatcherManager.getBugCatcher().logError(illegalArgumentException);
        }
        catch (TransformerException transformerException) {
            BugCatcherManager.getBugCatcher().logError(transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.out.println(transformerFactoryConfigurationError.getMessage());
        }
        catch (FileNotFoundException notFoundException) {
            BugCatcherManager.getBugCatcher().logError(notFoundException);
        }
        catch (IOException iOException) {
            BugCatcherManager.getBugCatcher().logError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertResourceProxy(ArbilDataNode arbilDataNode, ArbilDataNode resourceNode) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            boolean newResourceProxy;
            String targetXmlPath = this.getTargetXmlPath(arbilDataNode);
            System.out.println("insertResourceProxy: " + targetXmlPath);
            String resourceProxyId = null;
            CmdiComponentLinkReader linkReader = arbilDataNode.getParentDomNode().cmdiComponentLinkReader;
            if (linkReader != null) {
                resourceProxyId = linkReader.getProxyId(resourceNode.getUrlString());
            }
            boolean bl = newResourceProxy = resourceProxyId == null;
            if (newResourceProxy) {
                resourceProxyId = RESOURCE_ID_PREFIX + UUID.randomUUID().toString();
            }
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    try {
                        this.insertResourceProxyReference(targetDocument, targetXmlPath, resourceProxyId);
                    }
                    catch (TransformerException exception) {
                        BugCatcherManager.getBugCatcher().logError(exception);
                        return null;
                    }
                    if (newResourceProxy) {
                        SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().getTemplateFile());
                        this.addNewResourceProxy(targetDocument, schemaType, resourceProxyId, resourceNode);
                    } else {
                        linkReader.getResourceLink(resourceProxyId).addReferencingNode();
                    }
                }
                catch (Exception exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                    return null;
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, arbilDataNode.getFile());
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            return arbilDataNode.getURI();
        }
    }

    public void setHeaderInfo(Document document, CmdiHeaderInfo headerInfo) throws TransformerException {
        String headerPath = "/:CMD/:Header";
        Node headerNode = XPathAPI.selectSingleNode((Node)document.getFirstChild(), (String)"/:CMD/:Header");
        if (headerNode != null) {
            this.setHeaderInfoItem(document, headerNode, "MdCreator", headerInfo.getMdCreator());
            this.setHeaderInfoItem(document, headerNode, "MdCreationDate", headerInfo.getMdCreationDate());
            this.setHeaderInfoItem(document, headerNode, "MdSelfLink", headerInfo.getMdSelfLink());
            this.setHeaderInfoItem(document, headerNode, "MdProfile", headerInfo.getMdProfile());
            this.setHeaderInfoItem(document, headerNode, "MdCollectionDisplayName", headerInfo.getMdCollectionDisplayName());
        }
    }

    private void setHeaderInfoItem(Document document, Node headerNode, String nodeName, String value) throws DOMException, TransformerException {
        Node childNode = XPathAPI.selectSingleNode((Node)headerNode, (String)("/:" + nodeName));
        if (value != null) {
            if (childNode == null) {
                childNode = document.createElementNS(CMD_NAMESPACE, nodeName);
            }
            childNode.setTextContent(value);
            headerNode.appendChild(childNode);
        } else if (childNode != null) {
            headerNode.removeChild(childNode);
        }
    }

    private String getTargetXmlPath(ArbilDataNode arbilDataNode) {
        String targetXmlPath = arbilDataNode.getURI().getFragment();
        if (targetXmlPath == null) {
            targetXmlPath = ".CMD.Components.*[1]";
        }
        return targetXmlPath;
    }

    private void insertResourceProxyReference(Document targetDocument, String targetXmlPath, String resourceProxyId) throws TransformerException, DOMException {
        Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
        Node previousRefNode = documentNode.getAttributes().getNamedItem("ref");
        if (previousRefNode != null) {
            String previousRefValue = documentNode.getAttributes().getNamedItem("ref").getNodeValue();
            ((Element)documentNode).setAttribute("ref", previousRefValue + " " + resourceProxyId);
        } else {
            ((Element)documentNode).setAttribute("ref", resourceProxyId);
        }
    }

    private void addNewResourceProxy(Document targetDocument, SchemaType firstChildSchemaType, String resourceProxyId, ArbilDataNode resourceNode) throws ArbilMetadataException, DOMException {
        Node addedResourceNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), firstChildSchemaType, ".CMD.Resources.ResourceProxyList", ".CMD.Resources.ResourceProxyList.ResourceProxy");
        addedResourceNode.getAttributes().getNamedItem("id").setNodeValue(resourceProxyId);
        for (Node childNode = addedResourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            String localName = childNode.getNodeName();
            if ("ResourceType".equals(localName)) {
                if (resourceNode.isCmdiMetaDataNode()) {
                    childNode.setTextContent("Metadata");
                } else {
                    ((Element)childNode).setAttribute("mimetype", resourceNode.mpiMimeType);
                    childNode.setTextContent("Resource");
                }
            }
            if (!"ResourceRef".equals(localName)) continue;
            childNode.setTextContent(resourceNode.getUrlString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceProxyReferences(ArbilDataNode parent, Collection<String> resourceProxyReferences) {
        Object object = parent.getParentDomLockObject();
        synchronized (object) {
            CmdiComponentLinkReader linkReader = parent.getCmdiComponentLinkReader();
            if (linkReader == null) {
                return false;
            }
            HashSet<String> resourceProxyIds = new HashSet<String>(resourceProxyReferences.size());
            for (String reference : resourceProxyReferences) {
                resourceProxyIds.add(linkReader.getProxyId(reference));
            }
            String targetXmlPath = this.getTargetXmlPath(parent);
            System.out.println("removeResourceProxyReferences: " + targetXmlPath);
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(parent.getURI());
                try {
                    Node previousRefNode;
                    Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
                    if (documentNode != null && (previousRefNode = documentNode.getAttributes().getNamedItem("ref")) != null) {
                        String previousRefsValue = documentNode.getAttributes().getNamedItem("ref").getNodeValue();
                        StringBuilder newRefsValueSB = new StringBuilder();
                        for (String ref : previousRefsValue.split(" ")) {
                            if ((ref = ref.trim()).length() <= 0 || resourceProxyIds.contains(ref)) continue;
                            newRefsValueSB.append(ref).append(" ");
                        }
                        String newRefsValue = newRefsValueSB.toString().trim();
                        if (newRefsValue.length() == 0) {
                            ((Element)documentNode).removeAttribute("ref");
                        } else {
                            ((Element)documentNode).setAttribute("ref", newRefsValue);
                        }
                    }
                }
                catch (TransformerException exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                    return false;
                }
                for (String id : resourceProxyIds) {
                    CmdiComponentLinkReader.CmdiResourceLink link = linkReader.getResourceLink(id);
                    if (link == null) {
                        BugCatcherManager.getBugCatcher().logError(new NullPointerException("Resource link not found for id " + id));
                        return false;
                    }
                    link.removeReferencingNode();
                    if (link.getReferencingNodesCount() != 0 || this.removeResourceProxy(targetDocument, id)) continue;
                    messageDialogHandler.addMessageDialogToQueue("Failed to remove resource proxy with id " + id, "Warning");
                }
                parent.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, parent.getFile());
                return true;
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
        return false;
    }

    private boolean removeResourceProxy(Document document, String resourceProxyId) {
        Node proxyNode = this.getResourceProxyNode(document, resourceProxyId);
        if (proxyNode != null) {
            proxyNode.getParentNode().removeChild(proxyNode);
            return true;
        }
        return false;
    }

    public boolean updateResourceProxyReference(Document document, String resourceProxyId, URI referenceURI) {
        return this.updateResourceProxyReference(document, resourceProxyId, referenceURI.toString());
    }

    public boolean updateResourceProxyReference(Document document, String resourceProxyId, String reference) {
        try {
            Node resourceRefNode = this.selectSingleNode(document, this.getPathForResourceProxynode(resourceProxyId) + ".ResourceRef");
            if (resourceRefNode != null) {
                resourceRefNode.setTextContent(reference);
                return true;
            }
        }
        catch (TransformerException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChildNodes(ArbilDataNode arbilDataNode, String[] nodePaths) {
        if (arbilDataNode.getNeedsSaveToDisk(false)) {
            arbilDataNode.saveChangesToCache(true);
        }
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("remove from parent nodes: " + arbilDataNode);
            File cmdiNodeFile = arbilDataNode.getFile();
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                ArrayList<Node> selectedNodes = new ArrayList<Node>();
                for (String currentNodePath : nodePaths) {
                    System.out.println("removeChildNodes: " + currentNodePath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentNodePath);
                    if (documentNode == null) continue;
                    System.out.println("documentNodeName: " + documentNode != null ? documentNode.getNodeName() : "<null>");
                    selectedNodes.add(documentNode);
                }
                System.out.println(selectedNodes.size());
                for (Node currentNode : selectedNodes) {
                    if (currentNode instanceof Attr) {
                        Element parent = ((Attr)currentNode).getOwnerElement();
                        if (parent == null) continue;
                        parent.removeAttributeNode((Attr)currentNode);
                        continue;
                    }
                    Node parentNode = currentNode.getParentNode();
                    if (parentNode == null) continue;
                    parentNode.removeChild(currentNode);
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (String currentNodePath : nodePaths) {
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (TransformerException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFieldValues(ArbilDataNode arbilDataNode, FieldUpdateRequest[] fieldUpdates) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("setFieldValues: " + arbilDataNode);
            File cmdiNodeFile = arbilDataNode.getFile();
            try {
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    Node keyNameNode;
                    Node languageNode;
                    NamedNodeMap attributesMap;
                    System.out.println("currentFieldUpdate: " + currentFieldUpdate.fieldPath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentFieldUpdate.fieldPath);
                    if (!currentFieldUpdate.fieldOldValue.equals(documentNode.getTextContent())) {
                        BugCatcherManager.getBugCatcher().logError(new Exception("expecting '" + currentFieldUpdate.fieldOldValue + "' not '" + documentNode.getTextContent() + "' in " + currentFieldUpdate.fieldPath));
                        return false;
                    }
                    documentNode.setTextContent(currentFieldUpdate.fieldNewValue);
                    if (documentNode instanceof Attr || (attributesMap = documentNode.getAttributes()) == null) continue;
                    if (currentFieldUpdate.attributeValuesMap != null && documentNode instanceof Element) {
                        Element element = (Element)documentNode;
                        for (Map.Entry<String, Object> attributeEntry : currentFieldUpdate.attributeValuesMap.entrySet()) {
                            String attrPath = attributeEntry.getKey();
                            Object attrValue = attributeEntry.getValue();
                            Attr attrNode = ArbilComponentBuilder.getAttributeNodeFromPath(element, attrPath);
                            if (attrValue == null || "".equals(attrValue)) {
                                if (attrNode == null) continue;
                                element.removeAttributeNode(attrNode);
                                continue;
                            }
                            if (attrNode != null) {
                                attrNode.setValue(attrValue.toString());
                                continue;
                            }
                            ArbilComponentBuilder.addAttributeNodeFromPath(element, attrPath, attrValue.toString());
                        }
                    }
                    if (!arbilDataNode.isCmdiMetaDataNode()) {
                        languageNode = attributesMap.getNamedItem("LanguageId");
                        if (languageNode == null) {
                            languageNode = attributesMap.getNamedItem("xml:lang");
                        }
                        if (languageNode != null) {
                            languageNode.setNodeValue(currentFieldUpdate.fieldLanguageId);
                        }
                    } else {
                        languageNode = attributesMap.getNamedItem("xml:lang");
                        if (languageNode == null) {
                            if (currentFieldUpdate.fieldLanguageId != null) {
                                ((Element)documentNode).setAttribute("xml:lang", currentFieldUpdate.fieldLanguageId);
                            }
                        } else if (currentFieldUpdate.fieldLanguageId == null) {
                            ((Element)documentNode).removeAttribute("xml:lang");
                        } else {
                            languageNode.setNodeValue(currentFieldUpdate.fieldLanguageId);
                        }
                    }
                    if (arbilDataNode.isCmdiMetaDataNode() || currentFieldUpdate.keyNameValue == null || (keyNameNode = attributesMap.getNamedItem("Name")) == null) continue;
                    keyNameNode.setNodeValue(currentFieldUpdate.keyNameValue);
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath, currentFieldUpdate.fieldOldValue, currentFieldUpdate.fieldNewValue, "save");
                    if (currentFieldUpdate.fieldLanguageId != null) {
                        ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath + ":LanguageId", currentFieldUpdate.fieldLanguageId, "", "save");
                    }
                    if (currentFieldUpdate.keyNameValue == null) continue;
                    ArbilJournal.getSingleInstance().saveJournalEntry(arbilDataNode.getUrlString(), currentFieldUpdate.fieldPath + ":Name", currentFieldUpdate.keyNameValue, "", "save");
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (TransformerException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            return false;
        }
    }

    public void testInsertFavouriteComponent() {
        try {
            ArbilDataNode favouriteArbilDataNode1 = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor"));
            ArbilDataNode favouriteArbilDataNode2 = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor(2)"));
            ArbilDataNode destinationArbilDataNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI("file:/Users/petwit/.arbil/imdicache/20100527141926/20100527141926.imdi"));
            this.insertFavouriteComponent(destinationArbilDataNode, favouriteArbilDataNode1);
            this.insertFavouriteComponent(destinationArbilDataNode, favouriteArbilDataNode2);
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (ArbilMetadataException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertFavouriteComponent(ArbilDataNode destinationArbilDataNode, ArbilDataNode favouriteArbilDataNode) throws ArbilMetadataException {
        URI returnUri = null;
        String elementName = favouriteArbilDataNode.getURI().getFragment();
        String insertBefore = destinationArbilDataNode.getNodeTemplate().getInsertBeforeOfTemplate(elementName);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = destinationArbilDataNode.getNodeTemplate().getMaxOccursForTemplate(elementName);
        System.out.println("maxOccurs: " + maxOccurs);
        if (destinationArbilDataNode.getNeedsSaveToDisk(false)) {
            destinationArbilDataNode.saveChangesToCache(true);
        }
        try {
            Document favouriteDocument;
            Object object = favouriteArbilDataNode.getParentDomLockObject();
            synchronized (object) {
                favouriteDocument = ArbilComponentBuilder.getDocument(favouriteArbilDataNode.getURI());
            }
            object = destinationArbilDataNode.getParentDomLockObject();
            synchronized (object) {
                Node[] favouriteNodes;
                Document destinationDocument = ArbilComponentBuilder.getDocument(destinationArbilDataNode.getURI());
                String favouriteXpath = favouriteArbilDataNode.getURI().getFragment();
                String favouriteXpathTrimmed = favouriteXpath.replaceFirst("\\.[^(^.]+$", "");
                boolean onlySubNodes = !favouriteXpathTrimmed.equals(favouriteXpath);
                System.out.println("favouriteXpath: " + favouriteXpathTrimmed);
                String destinationXpath = onlySubNodes ? favouriteXpathTrimmed : favouriteXpathTrimmed.replaceFirst("\\.[^.]+$", "");
                System.out.println("destinationXpath: " + destinationXpath);
                destinationXpath = this.alignDestinationPathWithTarget(destinationXpath, destinationArbilDataNode);
                Node destinationNode = this.selectSingleNode(destinationDocument, destinationXpath);
                Node selectedNode = this.selectSingleNode(favouriteDocument, favouriteXpathTrimmed);
                Node importedNode = destinationDocument.importNode(selectedNode, true);
                if (onlySubNodes) {
                    NodeList selectedNodeList = importedNode.getChildNodes();
                    favouriteNodes = new Node[selectedNodeList.getLength()];
                    for (int nodeCounter = 0; nodeCounter < selectedNodeList.getLength(); ++nodeCounter) {
                        favouriteNodes[nodeCounter] = selectedNodeList.item(nodeCounter);
                    }
                } else {
                    favouriteNodes = new Node[]{importedNode};
                }
                for (Node singleFavouriteNode : favouriteNodes) {
                    if (singleFavouriteNode.getNodeType() == 3) continue;
                    ArbilComponentBuilder.insertNodeInOrder(destinationNode, singleFavouriteNode, insertBefore, maxOccurs);
                    System.out.println("inserting favouriteNode: " + singleFavouriteNode.getLocalName());
                }
                ArbilComponentBuilder.savePrettyFormatting(destinationDocument, destinationArbilDataNode.getFile());
                try {
                    String nodeFragment = favouriteNodes.length != 1 ? destinationXpath : ArbilComponentBuilder.convertNodeToNodePath(destinationDocument, favouriteNodes[0], destinationXpath);
                    System.out.println("nodeFragment: " + nodeFragment);
                    returnUri = new URI(destinationArbilDataNode.getURI().toString().split("#")[0] + "#" + nodeFragment);
                }
                catch (URISyntaxException exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                }
            }
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (ParserConfigurationException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (SAXException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (TransformerException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        return returnUri;
    }

    private String alignDestinationPathWithTarget(String destinationXpath, ArbilDataNode destinationArbilDataNode) {
        String targetFragment = destinationArbilDataNode.getURI().getFragment();
        if (targetFragment != null) {
            String targetFragmentGeneric;
            String destinationXpathGeneric;
            if (destinationArbilDataNode.isContainerNode()) {
                targetFragment = targetFragment.substring(0, targetFragment.lastIndexOf("."));
            }
            if ((destinationXpathGeneric = destinationXpath.replaceAll("\\(\\d+\\)", "(x)")).startsWith(targetFragmentGeneric = targetFragment.replaceAll("\\(\\d+\\)", "(x)"))) {
                String commonPartRegEx = targetFragmentGeneric.replaceAll("\\(x\\)", "\\\\(\\\\d+\\\\)");
                String[] destinationXpathParts = destinationXpath.split(commonPartRegEx);
                if (destinationXpathParts.length == 0) {
                    destinationXpath = targetFragment;
                } else if (destinationXpathParts.length == 2) {
                    destinationXpath = targetFragment + destinationXpathParts[1];
                } else {
                    messageDialogHandler.addMessageDialogToQueue("Unexpected relation between source and target paths. See error log for details.", "Insert node");
                    BugCatcherManager.getBugCatcher().logError("destinationXpath: " + destinationXpath + "\ntargetFragment: " + targetFragment, null);
                }
            }
        }
        return destinationXpath;
    }

    public static boolean canInsertNode(Node destinationNode, Node addableNode, int maxOccurs) {
        if (maxOccurs > 0) {
            String addableName = addableNode.getLocalName();
            if (addableName == null) {
                addableName = addableNode.getNodeName();
            }
            NodeList childNodes = destinationNode.getChildNodes();
            int duplicateNodeCounter = 0;
            for (int childCounter = 0; childCounter < childNodes.getLength(); ++childCounter) {
                String childsName = childNodes.item(childCounter).getLocalName();
                if (!addableName.equals(childsName) || ++duplicateNodeCounter < maxOccurs) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean pathIsAttribute(String pathString) {
        return attributePathPattern.matcher(pathString).matches();
    }

    public static boolean pathIsAttribute(String[] pathTokens) {
        return pathTokens.length > 0 && pathTokens[pathTokens.length - 1].startsWith("@");
    }

    public static Attr getAttributeNodeFromPath(Element parent, String path) {
        try {
            if (ArbilComponentBuilder.pathIsAttribute(path)) {
                String attributePart = path.replaceAll("^.*@", "");
                Matcher matcher = namespacePartPattern.matcher(attributePart);
                if (matcher.find()) {
                    String nsPart = URLDecoder.decode(matcher.group(1), "UTF-8");
                    String localName = attributePart.replaceAll("\\{.*\\}", "");
                    return parent.getAttributeNodeNS(nsPart, localName);
                }
                return parent.getAttributeNode(attributePart);
            }
        }
        catch (UnsupportedEncodingException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return null;
    }

    public static boolean addAttributeNodeFromPath(Element parent, String path, String value) {
        try {
            if (ArbilComponentBuilder.pathIsAttribute(path)) {
                String attributePart = path.replaceAll("^.*@", "");
                Matcher matcher = namespacePartPattern.matcher(attributePart);
                if (matcher.find()) {
                    String nsPart = URLDecoder.decode(matcher.group(1), "UTF-8");
                    String localName = attributePart.replaceAll("\\{.*\\}", "");
                    parent.setAttributeNS(nsPart, localName, value);
                } else {
                    parent.setAttribute(attributePart, value);
                }
                return true;
            }
        }
        catch (UnsupportedEncodingException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return false;
    }

    public static String encodeNsUriForAttributePath(String nsURI) {
        try {
            return URLEncoder.encode(nsURI, "UTF-8").replace(".", "%2E");
        }
        catch (UnsupportedEncodingException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node insertNodeInOrder(Node destinationNode, Node addableNode, String insertBefore, int maxOccurs) throws TransformerException, ArbilMetadataException {
        if (!ArbilComponentBuilder.canInsertNode(destinationNode, addableNode, maxOccurs)) {
            throw new ArbilMetadataException("The maximum nodes of this type have already been added.\n");
        }
        Node insertBeforeNode = null;
        if (insertBefore != null && insertBefore.length() > 0) {
            String[] insertBeforeArray = insertBefore.split(",");
            NodeList childNodes = destinationNode.getChildNodes();
            block0: for (int childCounter = 0; childCounter < childNodes.getLength(); ++childCounter) {
                String childsName = childNodes.item(childCounter).getLocalName();
                for (String currentInsertBefore : insertBeforeArray) {
                    if (!currentInsertBefore.equals(childsName)) continue;
                    System.out.println("insertbefore: " + childsName);
                    insertBeforeNode = childNodes.item(childCounter);
                    break block0;
                }
            }
        }
        if (insertBeforeNode != null) {
            System.out.println("inserting before: " + insertBeforeNode.getNodeName());
            return destinationNode.insertBefore(addableNode, insertBeforeNode);
        }
        System.out.println("inserting");
        if (!(addableNode instanceof Attr)) return destinationNode.appendChild(addableNode);
        if (!(destinationNode instanceof Element)) throw new ArbilMetadataException("Cannot insert attribute in node of this type: " + destinationNode.getNodeName());
        return ((Element)destinationNode).setAttributeNode((Attr)addableNode);
    }

    private String checkTargetXmlPath(String targetXmlPath, String cmdiComponentId) {
        if (targetXmlPath == null) {
            targetXmlPath = cmdiComponentId.replaceAll("\\.[^.]+$", "");
        } else if (targetXmlPath.replaceAll("\\(\\d+\\)", "").length() == cmdiComponentId.length()) {
            targetXmlPath = targetXmlPath.replaceAll("\\.[^.]+$", "");
        }
        String[] cmdiComponentArray = cmdiComponentId.split("\\.");
        String[] targetXmlPathArray = targetXmlPath.replaceAll("\\(\\d+\\)", "").split("\\.");
        StringBuilder arrayPathParts = new StringBuilder();
        for (int pathPartCounter = targetXmlPathArray.length; pathPartCounter < cmdiComponentArray.length - 1; ++pathPartCounter) {
            System.out.println("adding missing path component: " + cmdiComponentArray[pathPartCounter]);
            arrayPathParts.append('.');
            arrayPathParts.append(cmdiComponentArray[pathPartCounter]);
        }
        return targetXmlPath + arrayPathParts.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertChildComponent(ArbilDataNode arbilDataNode, String targetXmlPath, String cmdiComponentId) {
        if (arbilDataNode.getNeedsSaveToDisk(false)) {
            arbilDataNode.saveChangesToCache(true);
        }
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            System.out.println("insertChildComponent: " + cmdiComponentId);
            System.out.println("targetXmlPath: " + targetXmlPath);
            targetXmlPath = this.checkTargetXmlPath(targetXmlPath, cmdiComponentId);
            System.out.println("trimmed targetXmlPath: " + targetXmlPath);
            String nodeFragment = "";
            try {
                SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().getTemplateFile());
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    Node AddedNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                    nodeFragment = ArbilComponentBuilder.convertNodeToNodePath(targetDocument, AddedNode, targetXmlPath);
                }
                catch (ArbilMetadataException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                    return null;
                }
                arbilDataNode.bumpHistory();
                ArbilComponentBuilder.savePrettyFormatting(targetDocument, arbilDataNode.getFile());
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            try {
                System.out.println("nodeFragment: " + nodeFragment);
                return new URI(arbilDataNode.getURI().toString().split("#")[0] + "#" + nodeFragment);
            }
            catch (URISyntaxException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canInsertChildComponent(ArbilDataNode arbilDataNode, String targetXmlPath, String cmdiComponentId) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            targetXmlPath = this.checkTargetXmlPath(targetXmlPath, cmdiComponentId);
            try {
                SchemaType schemaType = this.getFirstSchemaType(arbilDataNode);
                Document targetDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                try {
                    return this.canInsertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                }
                catch (ArbilMetadataException exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                    return false;
                }
            }
            catch (IOException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return false;
            }
            catch (ParserConfigurationException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return false;
            }
            catch (SAXException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return false;
            }
            catch (DOMException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return false;
            }
        }
    }

    public void testRemoveArchiveHandles() {
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(new URI("http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/MPI.imdi"));
            this.removeArchiveHandles(workingDocument);
            this.printoutDocument(workingDocument);
        }
        catch (Exception exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArchiveHandles(ArbilDataNode arbilDataNode) {
        Object object = arbilDataNode.getParentDomLockObject();
        synchronized (object) {
            try {
                Document workingDocument = ArbilComponentBuilder.getDocument(arbilDataNode.getURI());
                this.removeArchiveHandles(workingDocument);
                ArbilComponentBuilder.savePrettyFormatting(workingDocument, arbilDataNode.getFile());
            }
            catch (Exception exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
    }

    private static void removeImdiDomIds(Document targetDocument) {
        String handleXpath = "/:METATRANSCRIPT[@id]|/:METATRANSCRIPT//*[@id]";
        try {
            NodeList domIdNodeList = XPathAPI.selectNodeList((Node)targetDocument, (String)handleXpath);
            for (int nodeCounter = 0; nodeCounter < domIdNodeList.getLength(); ++nodeCounter) {
                Node domIdNode = domIdNodeList.item(nodeCounter);
                if (domIdNode == null) continue;
                domIdNode.getAttributes().removeNamedItem("id");
            }
        }
        catch (TransformerException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
    }

    private void removeArchiveHandles(Document targetDocument) {
        String handleXpath = "/:METATRANSCRIPT[@ArchiveHandle]|/:METATRANSCRIPT//*[@ArchiveHandle]";
        try {
            NodeList archiveHandleNodeList = XPathAPI.selectNodeList((Node)targetDocument, (String)handleXpath);
            for (int nodeCounter = 0; nodeCounter < archiveHandleNodeList.getLength(); ++nodeCounter) {
                Node archiveHandleNode = archiveHandleNodeList.item(nodeCounter);
                if (archiveHandleNode == null) continue;
                archiveHandleNode.getAttributes().removeNamedItem("ArchiveHandle");
            }
        }
        catch (TransformerException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
    }

    private Node getResourceProxyNode(Document document, String resourceProxyId) {
        try {
            return this.selectSingleNode(document, this.getPathForResourceProxynode(resourceProxyId));
        }
        catch (TransformerException ex) {
            BugCatcherManager.getBugCatcher().logError("Exception while finding for removal resource proxy with id " + resourceProxyId, ex);
            return null;
        }
    }

    private String getPathForResourceProxynode(String resourceProxyId) {
        return ".CMD.Resources.ResourceProxyList.ResourceProxy[@id='" + resourceProxyId + "']";
    }

    private Node selectSingleNode(Document targetDocument, String targetXpath) throws TransformerException {
        String[] tempXpathArray = this.convertImdiPathToXPathOptions(targetXpath);
        if (tempXpathArray != null) {
            for (String tempXpath : tempXpathArray) {
                tempXpath = tempXpath.replaceAll("\\(", "[");
                tempXpath = tempXpath.replaceAll("\\)", "]");
                System.out.println("tempXpath: " + tempXpath);
                Node returnNode = XPathAPI.selectSingleNode((Node)targetDocument, (String)tempXpath);
                if (returnNode == null) continue;
                return returnNode;
            }
        }
        BugCatcherManager.getBugCatcher().logError(new Exception("Xpath issue, no node found for: " + targetXpath));
        return null;
    }

    private String[] convertImdiPathToXPathOptions(String targetXpath) {
        if (targetXpath == null) {
            return null;
        }
        return new String[]{targetXpath.replaceAll("\\.", "/"), targetXpath.replaceAll("\\.@([^.]*)$", "/@$1").replaceAll("\\.", "/:")};
    }

    private Node insertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws ArbilMetadataException {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String insertBefore = "";
        String strippedXpath = null;
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
            strippedXpath = targetXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("strippedXpath: " + strippedXpath);
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.isAttribute() ? CmdiTemplate.getAttributePathSection(schemaProperty.getName()) : schemaProperty.getName().getLocalPart();
                if (foundProperty == null) {
                    if (!(schemaProperty.isAttribute() ? currentPathComponent.equals("@" + currentName) : currentPathComponent.equals(currentName))) continue;
                    foundProperty = schemaProperty;
                    insertBefore = "";
                    continue;
                }
                if (schemaProperty.isAttribute()) continue;
                insertBefore = insertBefore.length() < 1 ? currentName : insertBefore + "," + currentName;
            }
            if (foundProperty == null) {
                throw new ArbilMetadataException("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        Node addedNode = this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode, false);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = foundProperty.getMaxOccurs() != null ? foundProperty.getMaxOccurs().intValue() : -1;
        System.out.println("maxOccurs: " + maxOccurs);
        if (insertBefore.length() > 0 || maxOccurs != -1) {
            if (addedNode instanceof Attr) {
                ((Element)documentNode).removeAttributeNode((Attr)addedNode);
            } else {
                documentNode.removeChild(addedNode);
            }
            try {
                ArbilComponentBuilder.insertNodeInOrder(documentNode, addedNode, insertBefore, maxOccurs);
            }
            catch (TransformerException exception) {
                throw new ArbilMetadataException(exception.getMessage());
            }
        }
        return addedNode;
    }

    private boolean canInsertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws ArbilMetadataException {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String insertBefore = "";
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return false;
            }
        }
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.isAttribute() ? CmdiTemplate.getAttributePathSection(schemaProperty.getName()) : schemaProperty.getName().getLocalPart();
                if (foundProperty == null) {
                    if (!(schemaProperty.isAttribute() ? currentPathComponent.equals("@" + currentName) : currentPathComponent.equals(currentName))) continue;
                    foundProperty = schemaProperty;
                    insertBefore = "";
                    continue;
                }
                if (schemaProperty.isAttribute()) continue;
                insertBefore = insertBefore.length() < 1 ? currentName : insertBefore + "," + currentName;
            }
            if (foundProperty == null) {
                throw new ArbilMetadataException("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        if (ArbilComponentBuilder.pathIsAttribute(xsdPath)) {
            return this.canInsertAttribute((Element)documentNode, foundProperty);
        }
        Node addedNode = this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode, false);
        System.out.println("insertBefore: " + insertBefore);
        int maxOccurs = foundProperty.getMaxOccurs() != null ? foundProperty.getMaxOccurs().intValue() : -1;
        System.out.println("maxOccurs: " + maxOccurs);
        if (insertBefore.length() > 0 || maxOccurs != -1) {
            if (addedNode instanceof Attr) {
                ((Element)documentNode).removeAttributeNode((Attr)addedNode);
            } else {
                documentNode.removeChild(addedNode);
            }
            return ArbilComponentBuilder.canInsertNode(documentNode, addedNode, maxOccurs);
        }
        return true;
    }

    private boolean canInsertAttribute(Element documentNode, SchemaProperty attributeSchemaProperty) {
        QName attrName = attributeSchemaProperty.getName();
        return !(attrName.getNamespaceURI() != null && attrName.getNamespaceURI().length() > 0 ? documentNode.hasAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart()) : documentNode.hasAttribute(attrName.getLocalPart()));
    }

    public static String convertNodeToNodePath(Document targetDocument, Node documentNode, String targetXmlPath) {
        System.out.println("Calculating the added fragment");
        int siblingCouter = 1;
        for (Node siblingNode = documentNode.getPreviousSibling(); siblingNode != null; siblingNode = siblingNode.getPreviousSibling()) {
            if (!documentNode.getNodeName().equals(siblingNode.getNodeName())) continue;
            ++siblingCouter;
        }
        String nodeFragment = documentNode.getNodeName();
        if (documentNode instanceof Attr) {
            nodeFragment = "@" + nodeFragment;
        }
        String nodePathString = targetXmlPath + "." + nodeFragment + "(" + siblingCouter + ")";
        System.out.println("nodeFragment: " + nodePathString);
        System.out.println("targetXmlPath: " + targetXmlPath);
        return nodePathString;
    }

    public URI createComponentFile(URI cmdiNodeFile, URI xsdFile, boolean addDummyData) {
        System.out.println("createComponentFile: " + cmdiNodeFile + " : " + xsdFile);
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(null);
            this.readSchema(workingDocument, xsdFile, addDummyData);
            ArbilComponentBuilder.savePrettyFormatting(workingDocument, new File(cmdiNodeFile));
            this.setDefaultCmdiHeaderInfo(cmdiNodeFile, xsdFile);
        }
        catch (IOException e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        catch (ParserConfigurationException e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        catch (SAXException e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
        return cmdiNodeFile;
    }

    private void setDefaultCmdiHeaderInfo(URI cmdiNodeFile, URI xsdFile) throws ParserConfigurationException, IOException, SAXException {
        Document document = ArbilComponentBuilder.getDocument(cmdiNodeFile);
        CmdiHeaderInfo headerInfo = CmdiHeaderInfo.createDefault(xsdFile);
        try {
            this.setHeaderInfo(document, headerInfo);
            ArbilComponentBuilder.savePrettyFormatting(document, new File(cmdiNodeFile));
        }
        catch (TransformerException ex) {
            BugCatcherManager.getBugCatcher().logError("Could not set header info for new CMDI " + cmdiNodeFile, ex);
        }
    }

    private SchemaType getFirstSchemaType(ArbilDataNode arbilDataNode) {
        if (this.nodeSchemaTypeMap.containsKey(arbilDataNode)) {
            return this.nodeSchemaTypeMap.get(arbilDataNode);
        }
        SchemaType schemaType = this.getFirstSchemaType(arbilDataNode.getNodeTemplate().getTemplateFile());
        this.nodeSchemaTypeMap.put(arbilDataNode, schemaType);
        return schemaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaType getFirstSchemaType(File schemaFile) {
        block9: {
            SchemaType schemaType;
            FileInputStream inputStream = new FileInputStream(schemaFile);
            try {
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.setCharacterEncoding("UTF-8");
                xmlOptions.setEntityResolver((EntityResolver)new ArbilEntityResolver(sessionStorage.getOriginatingUri(schemaFile.toURI())));
                SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)xmlOptions);
                schemaType = sts.documentTypes()[0];
            }
            catch (IOException e) {
                try {
                    try {
                        BugCatcherManager.getBugCatcher().logError(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e2) {
                    BugCatcherManager.getBugCatcher().logError(e2);
                    break block9;
                }
                catch (XmlException e3) {
                    messageDialogHandler.addMessageDialogToQueue("Could not read the XML Schema", "Error inserting node");
                    BugCatcherManager.getBugCatcher().logError((Exception)((Object)e3));
                }
            }
            ((InputStream)inputStream).close();
            return schemaType;
        }
        return null;
    }

    private void readSchema(Document workingDocument, URI xsdFile, boolean addDummyData) {
        File schemaFile = xsdFile.getScheme() == null || xsdFile.getScheme().length() == 0 || xsdFile.getScheme().toLowerCase().equals("file") ? new File(xsdFile) : sessionStorage.updateCache(xsdFile.toString(), 5, false);
        SchemaType schemaType = this.getFirstSchemaType(schemaFile);
        this.constructXml(schemaType.getElementProperties()[0], "documentTypes", workingDocument, xsdFile.toString(), null, addDummyData);
    }

    private Node appendNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty, boolean addDummyData) {
        if (schemaProperty.isAttribute()) {
            return this.appendAttributeNode(workingDocument, nameSpaceUri, (Element)parentElement, schemaProperty, addDummyData);
        }
        return this.appendElementNode(workingDocument, nameSpaceUri, parentElement, schemaProperty, addDummyData);
    }

    private Attr appendAttributeNode(Document workingDocument, String nameSpaceUri, Element parentElement, SchemaProperty schemaProperty, boolean addDummyData) {
        Attr currentAttribute = workingDocument.createAttributeNS(schemaProperty.getName().getNamespaceURI(), schemaProperty.getName().getLocalPart());
        if (schemaProperty.getDefaultText() != null) {
            currentAttribute.setNodeValue(schemaProperty.getDefaultText());
        }
        parentElement.setAttributeNode(currentAttribute);
        return currentAttribute;
    }

    private Element appendElementNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty, boolean addDummyData) {
        Element currentElement = workingDocument.createElementNS(CMD_NAMESPACE, schemaProperty.getName().getLocalPart());
        SchemaType currentSchemaType = schemaProperty.getType();
        for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
            if (attributesProperty.getMinOccurs() == null || attributesProperty.getMinOccurs().equals(BigInteger.ZERO)) continue;
            currentElement.setAttribute(attributesProperty.getName().getLocalPart(), attributesProperty.getDefaultText());
        }
        if (parentElement == null) {
            currentElement.setAttribute("CMDVersion", "1.1");
            currentElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            currentElement.setAttribute("xsi:schemaLocation", "http://www.clarin.eu/cmd/ " + nameSpaceUri);
            workingDocument.appendChild(currentElement);
        } else {
            parentElement.appendChild(currentElement);
        }
        return currentElement;
    }

    private Node constructXml(SchemaProperty currentSchemaProperty, String pathString, Document workingDocument, String nameSpaceUri, Node parentElement, boolean addDummyData) {
        Node currentElement;
        Node returnNode = null;
        String currentPathString = pathString + "." + currentSchemaProperty.getName().getLocalPart();
        SchemaType currentSchemaType = currentSchemaProperty.getType();
        returnNode = currentElement = this.appendNode(workingDocument, nameSpaceUri, parentElement, currentSchemaProperty, addDummyData);
        for (SchemaProperty schemaProperty : currentSchemaType.getElementProperties()) {
            BigInteger maxNumberToAdd;
            if (addDummyData) {
                maxNumberToAdd = schemaProperty.getMaxOccurs();
                BigInteger dummyNumberToAdd = BigInteger.ONE.add(BigInteger.ONE).add(BigInteger.ONE);
                if (maxNumberToAdd == null) {
                    maxNumberToAdd = dummyNumberToAdd;
                } else if (dummyNumberToAdd.compareTo(maxNumberToAdd) == -1) {
                    maxNumberToAdd = dummyNumberToAdd;
                }
            } else {
                maxNumberToAdd = schemaProperty.getMinOccurs();
                if (maxNumberToAdd == null) {
                    maxNumberToAdd = BigInteger.ZERO;
                }
            }
            BigInteger addNodeCounter = BigInteger.ZERO;
            while (addNodeCounter.compareTo(maxNumberToAdd) < 0) {
                this.constructXml(schemaProperty, currentPathString, workingDocument, nameSpaceUri, currentElement, addDummyData);
                addNodeCounter = addNodeCounter.add(BigInteger.ONE);
            }
        }
        return returnNode;
    }

    private void printoutDocument(Document workingDocument) {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer transformer = tranFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(workingDocument);
            StreamResult dest = new StreamResult(System.out);
            transformer.transform(src, dest);
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
    }

    public void testWalk() {
        try {
            Document workingDocument = ArbilComponentBuilder.getDocument(null);
            this.readSchema(workingDocument, new URI("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1264769926773/xsd"), true);
            this.printoutDocument(workingDocument);
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError(e);
        }
    }

    static {
        attributePathPattern = Pattern.compile("^.*\\.@[^.]+$");
        namespacePartPattern = Pattern.compile("\\{(.*)\\}");
    }
}

