/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImporter
implements GenericImporter {
    protected JProgressBar progressBar = null;
    protected URI inputFileUri = null;
    protected JTextArea importTextArea;
    private int inputLineCount;
    private int currntLineCounter;
    protected String inputFileMd5Sum;
    protected boolean overwriteExisting;
    protected HashMap<String, HashSet<UniqueIdentifier>> createdNodeIds;
    HashMap<String, EntityDocument> createdDocuments = new HashMap();
    private SessionStorage sessionStorage;

    public EntityImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        this.overwriteExisting = overwriteExistingLocal;
        this.importTextArea = importTextAreaLocal;
        this.progressBar = progressBarLocal;
        this.createdNodeIds = new HashMap();
        this.sessionStorage = sessionStorage;
    }

    @Override
    public HashMap<String, HashSet<UniqueIdentifier>> getCreatedNodeIds() {
        return this.createdNodeIds;
    }

    public void appendToTaskOutput(String lineOfText) {
        this.importTextArea.append(lineOfText + "\n");
        this.importTextArea.setCaretPosition(this.importTextArea.getText().length());
    }

    public void calculateFileNameAndFileLength(BufferedReader bufferedReader) {
        this.currntLineCounter = 0;
        try {
            String strLine;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder hexString = new StringBuilder();
            this.inputLineCount = 0;
            while ((strLine = bufferedReader.readLine()) != null) {
                digest.update(strLine.getBytes());
                ++this.inputLineCount;
            }
            byte[] md5sum = digest.digest();
            for (int byteCounter = 0; byteCounter < md5sum.length; ++byteCounter) {
                hexString.append(Integer.toHexString(256 + (md5sum[byteCounter] & 0xFF)).substring(1));
            }
            this.inputFileMd5Sum = hexString.toString();
        }
        catch (NoSuchAlgorithmException algorithmException) {
            BugCatcherManager.getBugCatcher().logError((Exception)algorithmException);
        }
        catch (IOException iOException) {
            BugCatcherManager.getBugCatcher().logError((Exception)iOException);
        }
    }

    protected void incrementLineProgress() {
        ++this.currntLineCounter;
        int currentProgressPercent = (int)((double)this.currntLineCounter / (double)this.inputLineCount * 100.0);
        if (this.progressBar != null) {
            this.progressBar.setValue(currentProgressPercent);
        }
    }

    protected void incrementSaveProgress(int documentCount, int savedCount) {
        int currentProgressPercent = (int)((double)savedCount / (double)documentCount * 100.0);
        if (this.progressBar != null) {
            this.progressBar.setValue(currentProgressPercent);
        }
    }

    protected File getDestinationDirectory() {
        File destinationDirectory = new File(this.sessionStorage.getCacheDirectory(), this.inputFileMd5Sum);
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdir();
        }
        return destinationDirectory;
    }

    protected EntityDocument getEntityDocument(ArrayList<URI> createdNodes, String typeString, String idString, ImportTranslator importTranslator) throws ImportException {
        EntityDocument currentEntity = this.createdDocuments.get(idString = this.cleanFileName(idString));
        if (currentEntity == null) {
            UniqueIdentifier uniqueIdentifier = new UniqueIdentifier(this.inputFileMd5Sum + ":" + idString, UniqueIdentifier.IdentifierType.iid);
            currentEntity = new EntityDocument(this.getDestinationDirectory(), uniqueIdentifier, typeString, importTranslator, this.sessionStorage);
            createdNodes.add(currentEntity.getFile().toURI());
            this.createdDocuments.put(idString, currentEntity);
        }
        if (typeString != null) {
            if (this.createdNodeIds.get(typeString) == null) {
                HashSet<UniqueIdentifier> idSet = new HashSet<UniqueIdentifier>();
                idSet.add(currentEntity.getUniqueIdentifier());
                this.createdNodeIds.put(typeString, idSet);
            } else {
                this.createdNodeIds.get(typeString).add(currentEntity.getUniqueIdentifier());
            }
        }
        return currentEntity;
    }

    protected void saveAllDocuments() {
        this.appendToTaskOutput(this.createdDocuments.size() + " entities imported");
        this.appendToTaskOutput("Saving imported documents (step 2/4)");
        this.progressBar.setValue(0);
        int documentCount = this.createdDocuments.size();
        int savedCount = 0;
        for (EntityDocument currentDocument : this.createdDocuments.values()) {
            try {
                currentDocument.saveDocument();
                this.incrementSaveProgress(documentCount, ++savedCount);
            }
            catch (ImportException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                this.appendToTaskOutput("Error saving file: " + exception.getMessage());
            }
        }
    }

    public String cleanFileName(String fileName) {
        return fileName.replaceAll("[^A-z0-9]", "_");
    }

    @Override
    public URI[] importFile(File testFile, String profileId) throws IOException, ImportException {
        this.inputFileUri = testFile.toURI();
        this.calculateFileNameAndFileLength(new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(testFile)))));
        return this.importFile(new InputStreamReader(new DataInputStream(new FileInputStream(testFile))), profileId);
    }

    @Override
    public URI[] importFile(String testFileString, String profileId) throws IOException, ImportException {
        try {
            this.inputFileUri = this.getClass().getResource(testFileString).toURI();
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error getting the import directory attached resources might not be correctly resolved");
        }
        this.calculateFileNameAndFileLength(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(testFileString))));
        return this.importFile(new InputStreamReader(this.getClass().getResourceAsStream(testFileString)), profileId);
    }

    public URI[] importFile(InputStreamReader inputStreamReader, String profileId) throws IOException, ImportException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean canImport(String inputFileString) {
        throw new UnsupportedOperationException("Not supported");
    }
}

