/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DocumentNewMenu
extends JMenu
implements ActionListener {
    AbstractDiagramManager diagramWindowManager;

    public DocumentNewMenu(AbstractDiagramManager diagramWindowManager) {
        this.diagramWindowManager = diagramWindowManager;
        for (DocumentType documentType : DocumentType.values()) {
            JMenuItem menuItem = new JMenuItem(documentType.getDisplayName());
            menuItem.setActionCommand(documentType.name());
            menuItem.addActionListener(this);
            this.add(menuItem);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DocumentType documentType = DocumentType.valueOf(e.getActionCommand());
        this.diagramWindowManager.newDiagram(documentType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocumentType {
        Simple("Standard Diagram (database driven)"),
        Freeform("Freeform Diagram (transient)"),
        KinTerms("Kin Terms Diagram"),
        Query("Query Diagram"),
        ArchiveLinker("Archive Data Linker"),
        CustomQuery("Custom Data Formats");

        private String displayName;

        private DocumentType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

