/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.fonts.AFPFontReader;
import org.apache.fop.render.afp.fonts.CharacterSetOrientation;
import org.apache.fop.render.afp.tools.StringUtils;

public class CharacterSet {
    protected static final Log log = LogFactory.getLog((String)(class$org$apache$fop$render$afp$fonts$CharacterSet == null ? (class$org$apache$fop$render$afp$fonts$CharacterSet = CharacterSet.class$("org.apache.fop.render.afp.fonts.CharacterSet")) : class$org$apache$fop$render$afp$fonts$CharacterSet).getName());
    protected String _codePage;
    protected String _encoding;
    protected String _name;
    private byte[] _nameBytes;
    protected String _path;
    private boolean _isMetricsLoaded = false;
    private String _currentOrientation = "0";
    private HashMap _characterSetOrientations;
    static /* synthetic */ Class class$org$apache$fop$render$afp$fonts$CharacterSet;

    public CharacterSet(String codePage, String encoding, String name, String path) {
        if (name.length() > 8) {
            String msg = "Character set name must be a maximum of 8 characters " + name;
            log.error((Object)("Constructor:: " + msg));
            throw new IllegalArgumentException(msg);
        }
        this._name = name.length() < 8 ? StringUtils.rpad(name, ' ', 8) : name;
        try {
            this._nameBytes = name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this._nameBytes = name.getBytes();
            log.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + name));
        }
        this._codePage = codePage;
        this._encoding = encoding;
        this._path = path;
        this._characterSetOrientations = new HashMap(4);
    }

    public void addCharacterSetOrientation(CharacterSetOrientation cso) {
        this._characterSetOrientations.put(String.valueOf(cso.getOrientation()), cso);
    }

    public int getAscender() {
        this.load();
        return this.getCharacterSetOrientation().getAscender();
    }

    public int getCapHeight() {
        this.load();
        return this.getCharacterSetOrientation().getCapHeight();
    }

    public int getDescender() {
        this.load();
        return this.getCharacterSetOrientation().getDescender();
    }

    public int getFirstChar() {
        this.load();
        return this.getCharacterSetOrientation().getFirstChar();
    }

    public int getLastChar() {
        this.load();
        return this.getCharacterSetOrientation().getLastChar();
    }

    public String getPath() {
        return this._path;
    }

    public int[] getWidths() {
        this.load();
        return this.getCharacterSetOrientation().getWidths();
    }

    public int getXHeight() {
        this.load();
        return this.getCharacterSetOrientation().getXHeight();
    }

    public int width(int character) {
        this.load();
        return this.getCharacterSetOrientation().width(character);
    }

    private void load() {
        if (!this._isMetricsLoaded) {
            AFPFontReader afpFontReader = new AFPFontReader();
            afpFontReader.loadCharacterSetMetric(this);
            this._isMetricsLoaded = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public byte[] getNameBytes() {
        return this._nameBytes;
    }

    public String getCodePage() {
        return this._codePage;
    }

    public String getEncoding() {
        return this._encoding;
    }

    private CharacterSetOrientation getCharacterSetOrientation() {
        CharacterSetOrientation c = (CharacterSetOrientation)this._characterSetOrientations.get(this._currentOrientation);
        return c;
    }

    public char mapChar(char c) {
        return c;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

