/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.ui.EntityUploadPanel;
import nl.mpi.kinnate.ui.GedcomImportPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.menu.MainMenuBar;
import nl.mpi.kinnate.ui.menu.RecentFileMenu;
import nl.mpi.kinnate.ui.window.SavePanelFrame;

public abstract class AbstractDiagramManager {
    private EntityUploadPanel entityUploadPanel;
    private ApplicationVersionManager versionManager;
    private ArbilWindowManager dialogHandler;
    private SessionStorage sessionStorage;
    private ArbilDataNodeLoader dataNodeLoader;
    private ArbilTreeHelper treeHelper;
    private EntityCollection entityCollection;

    public AbstractDiagramManager(ApplicationVersionManager versionManager, ArbilWindowManager dialogHandler, SessionStorage sessionStorage, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, EntityCollection entityCollection) {
        this.versionManager = versionManager;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
        this.entityCollection = entityCollection;
    }

    public abstract void createApplicationWindow();

    public JFrame createDiagramWindow(String diagramTitle, Component diagramComponent) {
        JFrame diagramFame = diagramComponent instanceof SavePanel ? new SavePanelFrame((SavePanel)((Object)diagramComponent)) : new JFrame();
        this.setWindowTitle(diagramFame, diagramTitle);
        diagramFame.setJMenuBar(new MainMenuBar(this, this.sessionStorage, this.dialogHandler, this.versionManager));
        if (diagramComponent != null) {
            diagramFame.setContentPane((Container)diagramComponent);
        }
        this.setWindowIcon(diagramFame);
        diagramFame.setDefaultCloseOperation(0);
        diagramFame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractDiagramManager.this.closeWindowAction((JFrame)e.getWindow());
            }
        });
        diagramFame.pack();
        diagramFame.setVisible(true);
        return diagramFame;
    }

    public void setWindowTitle(JFrame windowFrame, String titleString) {
        windowFrame.setTitle(this.versionManager.getApplicationVersion().applicationTitle + " " + this.versionManager.getApplicationVersion().currentMajor + "." + this.versionManager.getApplicationVersion().currentMinor + "." + this.versionManager.getApplicationVersion().currentRevision + " - " + titleString);
    }

    public void setWindowIcon(JFrame windowFrame) {
        windowFrame.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
    }

    protected void closeWindowAction(JFrame windowFrame) {
        if (this.offerUserToSaveAll()) {
            System.exit(0);
        }
    }

    public abstract Component createDiagramContainer(Component var1);

    public JDialog createDialogueContainer(Component diagramComponent, Component parentComponent) {
        String diagramTitle = diagramComponent.getName();
        JFrame parentFrame = (JFrame)SwingUtilities.getRoot(parentComponent);
        JDialog jDialog = new JDialog(parentFrame, diagramTitle, true);
        jDialog.getContentPane().removeAll();
        jDialog.getContentPane().add(diagramComponent);
        jDialog.pack();
        return jDialog;
    }

    public abstract void createDiagramSubPanel(String var1, Component var2, Component var3);

    public void newDiagram() {
        URI defaultDiagramUri = null;
        if (KinDiagramPanel.getDefaultDiagramFile(this.sessionStorage).exists()) {
            defaultDiagramUri = KinDiagramPanel.getDefaultDiagramFile(this.sessionStorage).toURI();
        }
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(defaultDiagramUri, false, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.entityCollection, this);
        egoSelectionTestPanel.setName("Unsaved Default Diagram");
        this.createDiagramContainer(egoSelectionTestPanel);
        egoSelectionTestPanel.loadAllTrees();
    }

    public void newDiagram(DocumentNewMenu.DocumentType documentType) {
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(documentType, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.entityCollection, this);
        egoSelectionTestPanel.setName("Unsaved " + documentType.getDisplayName());
        this.createDiagramContainer(egoSelectionTestPanel);
        egoSelectionTestPanel.loadAllTrees();
    }

    public void openDiagram(String diagramTitle, URI selectedUri, boolean saveToRecentMenu) {
        if (saveToRecentMenu) {
            RecentFileMenu.addRecentFile(this.sessionStorage, new File(selectedUri));
        }
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(selectedUri, saveToRecentMenu, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.entityCollection, this);
        egoSelectionTestPanel.setName(diagramTitle);
        this.createDiagramContainer(egoSelectionTestPanel);
        egoSelectionTestPanel.loadAllTrees();
    }

    abstract Component getSelectedDiagram();

    public void loadAllTrees() {
        Component selectedComponent = this.getSelectedDiagram();
        if (selectedComponent instanceof KinDiagramPanel) {
            ((KinDiagramPanel)selectedComponent).loadAllTrees();
        }
    }

    public void openImportPanel(File importFile, SavePanel originatingSavePanel) throws ImportException {
        new GedcomImportPanel(this, originatingSavePanel, this.entityCollection, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImport(importFile);
    }

    public void openImportPanel(String importUrlString, SavePanel originatingSavePanel) throws ImportException {
        new GedcomImportPanel(this, originatingSavePanel, this.entityCollection, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImport(importUrlString);
    }

    public void openJarImportPanel(String importUrlString, SavePanel originatingSavePanel) throws ImportException {
        new GedcomImportPanel(this, originatingSavePanel, this.entityCollection, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImportJar(importUrlString);
    }

    public abstract void setSelectedDiagram(Component var1);

    public abstract void setSelectedDiagram(int var1);

    public void openEntityUploadPanel() {
        if (this.entityUploadPanel == null) {
            this.entityUploadPanel = new EntityUploadPanel(this.sessionStorage, this.entityCollection, this.dialogHandler);
            this.entityUploadPanel.setName("Entity Upload");
            this.createDiagramContainer(this.entityUploadPanel);
        }
        this.setSelectedDiagram(this.entityUploadPanel);
    }

    public abstract int getSavePanelIndex();

    public abstract String getSavePanelTitle(int var1);

    public SavePanel getCurrentSavePanel() {
        return this.getSavePanel(this.getSavePanelIndex());
    }

    abstract Component getDiagramAt(int var1);

    public SavePanel getSavePanel(int tabIndex) {
        Component selectedComponent = this.getDiagramAt(tabIndex);
        SavePanel savePanel = null;
        if (selectedComponent instanceof SavePanel) {
            savePanel = (SavePanel)((Object)selectedComponent);
        }
        return savePanel;
    }

    public abstract void closeSavePanel(int var1);

    public KinTermSavePanel getKinTermPanel() {
        SavePanel selectedComponent = this.getCurrentSavePanel();
        KinTermSavePanel kinTermSavePanel = null;
        if (selectedComponent instanceof SavePanelFrame) {
            selectedComponent = (SavePanel)((Object)((SavePanelFrame)selectedComponent).getContentPane());
        }
        if (selectedComponent instanceof KinTermSavePanel) {
            kinTermSavePanel = (KinTermSavePanel)((Object)selectedComponent);
        }
        return kinTermSavePanel;
    }

    public abstract void setDiagramTitle(int var1, String var2);

    public abstract Component[] getAllDiagrams();

    public boolean offerUserToSaveAll() {
        int diagramCount = this.getAllDiagrams().length;
        for (int diagramCounter = 0; diagramCounter < diagramCount; ++diagramCounter) {
            Component selectedComponent = this.getDiagramAt(diagramCounter);
            if (!(selectedComponent instanceof SavePanel)) continue;
            SavePanel savePanel = (SavePanel)((Object)selectedComponent);
            this.setSelectedDiagram(selectedComponent);
            String diagramName = this.getSavePanelTitle(diagramCounter);
            boolean userCanceled = this.offerUserToSave(savePanel, diagramName);
            if (!userCanceled) continue;
            return false;
        }
        return true;
    }

    public boolean offerUserToSave(SavePanel savePanel, String diagramName) {
        if (savePanel.requiresSave()) {
            switch (this.dialogHandler.showDialogBox("There are unsaved changes in: \"" + diagramName + "\"\nDo you want to save before closing?", "Close Diagram", 1, -1)) {
                case 0: {
                    if (savePanel.hasSaveFileName()) {
                        savePanel.saveToFile();
                        break;
                    }
                    this.saveDiagramAs(savePanel);
                }
                case 1: {
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private String saveDiagramAs(SavePanel savePanel) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".svg");
            }

            public String getDescription() {
                return "Scalable Vector Graphics (SVG)";
            }
        });
        int returnVal = fc.showSaveDialog((Component)((Object)savePanel));
        if (returnVal == 0) {
            File svgFile = fc.getSelectedFile();
            if (!svgFile.getName().toLowerCase().endsWith(".svg")) {
                svgFile = new File(svgFile.getParentFile(), svgFile.getName() + ".svg");
            }
            savePanel.saveToFile(svgFile);
            RecentFileMenu.addRecentFile(this.sessionStorage, svgFile);
            return svgFile.getName();
        }
        return null;
    }
}

