/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.item.FItem;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public final class DynFuncCall
extends Arr {
    public DynFuncCall(InputInfo ii, Expr fun, Expr[] arg) {
        super(ii, Array.add(arg, fun));
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        Type t = this.expr[this.expr.length - 1].type().type;
        if (t instanceof FuncType) {
            FuncType ft = (FuncType)t;
            if (ft.ret != null) {
                this.type = ft.ret;
            }
        }
        if (this.values() && this.expr[this.expr.length - 1] instanceof Map) {
            return this.optPre(this.value(ctx), ctx);
        }
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getFun(ctx).invItem(ctx, ii, this.argv(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.getFun(ctx).invValue(ctx, this.input, this.argv(ctx));
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.getFun(ctx).invIter(ctx, this.input, this.argv(ctx));
    }

    private Value[] argv(QueryContext ctx) throws QueryException {
        Value[] argv = new Value[this.expr.length - 1];
        int i = argv.length;
        while (--i >= 0) {
            argv[i] = this.expr[i].value(ctx);
        }
        return argv;
    }

    private FItem getFun(QueryContext ctx) throws QueryException {
        Item it = this.checkItem(this.expr[this.expr.length - 1], ctx);
        if (!it.func() || ((FItem)it).arity() != this.expr.length - 1) {
            Err.type(this, FuncType.arity(this.expr.length - 1), it);
        }
        return (FItem)it;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        this.expr[this.expr.length - 1].plan(ser);
        int i = 0;
        while (i < this.expr.length - 1) {
            this.expr[i].plan(ser);
            ++i;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return String.valueOf(this.expr[this.expr.length - 1].desc()) + "(...)";
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.expr[this.expr.length - 1].toString());
        tb.add(40);
        int i = 0;
        while (i < this.expr.length - 1) {
            tb.add(this.expr[i].toString());
            if (i < this.expr.length - 2) {
                tb.add(", ");
            }
            ++i;
        }
        return tb.add(41).toString();
    }
}

