/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class IntArrayList
extends ElementList
implements Iterable<int[]> {
    int[][] list;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int c) {
        this.list = new int[c][];
    }

    public void add(int[] e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public int[] get(int i) {
        return this.list[i];
    }

    public void set(int i, int[] e) {
        if (i >= this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    @Override
    public Iterator<int[]> iterator() {
        return new Iterator<int[]>(){
            private int c = -1;

            @Override
            public boolean hasNext() {
                return ++this.c < IntArrayList.this.size;
            }

            @Override
            public int[] next() {
                return IntArrayList.this.list[this.c];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }
}

