/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import javax.xml.bind.annotation.XmlAttribute;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinType
implements Comparable<KinType> {
    public static final String separator = ",";
    @XmlAttribute(name="code", namespace="http://mpi.nl/tla/kin")
    protected String codeString = null;
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    private DataTypes.RelationType[] relationTypes = null;
    @XmlAttribute(name="symbol", namespace="http://mpi.nl/tla/kin")
    private EntityData.SymbolType[] symbolTypes = null;
    @XmlAttribute(name="name", namespace="http://mpi.nl/tla/kin")
    protected String displayString = null;
    private static KinType[] referenceKinTypes = new KinType[]{new KinType("Ef", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Ego Female"), new KinType("Em", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Ego Male"), new KinType("Fa", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Father"), new KinType("Mo", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Mother"), new KinType("Br", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Brother"), new KinType("Si", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Sister"), new KinType("So", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Son"), new KinType("Da", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Daughter"), new KinType("Hu", new DataTypes.RelationType[]{DataTypes.RelationType.union}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Husband"), new KinType("Wi", new DataTypes.RelationType[]{DataTypes.RelationType.union}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Wife"), new KinType("Pa", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Parent"), new KinType("Sb", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Sibling"), new KinType("Sp", new DataTypes.RelationType[]{DataTypes.RelationType.union}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Spouse"), new KinType("Ch", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Child"), new KinType("F", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Father"), new KinType("M", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Mother"), new KinType("B", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Brother"), new KinType("Z", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Sister"), new KinType("S", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Son"), new KinType("D", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Daughter"), new KinType("H", new DataTypes.RelationType[]{DataTypes.RelationType.union}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Husband"), new KinType("W", new DataTypes.RelationType[]{DataTypes.RelationType.union}, new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Wife"), new KinType("P", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Parent"), new KinType("G", new DataTypes.RelationType[]{DataTypes.RelationType.sibling}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Sibling"), new KinType("E", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.square}, "Ego"), new KinType("C", new DataTypes.RelationType[]{DataTypes.RelationType.descendant}, new EntityData.SymbolType[]{EntityData.SymbolType.triangle, EntityData.SymbolType.circle}, "Child"), new KinType("m", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.triangle}, "Male"), new KinType("f", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.circle}, "Female"), new KinType("x", new DataTypes.RelationType[0], new EntityData.SymbolType[]{EntityData.SymbolType.square}, "Undefined"), new KinType("*", new DataTypes.RelationType[]{DataTypes.RelationType.ancestor, DataTypes.RelationType.descendant, DataTypes.RelationType.union, DataTypes.RelationType.sibling}, null, "Any Relation")};

    private KinType() {
    }

    public KinType(String codeStringLocal, DataTypes.RelationType[] relationTypes, EntityData.SymbolType[] symbolTypes, String displayStringLocal) {
        this.codeString = codeStringLocal;
        this.relationTypes = relationTypes;
        this.symbolTypes = symbolTypes;
        this.displayString = displayStringLocal;
    }

    public String getCodeString() {
        return this.codeString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public DataTypes.RelationType[] getRelationTypes() {
        return this.relationTypes;
    }

    public boolean hasNoRelationTypes() {
        return this.relationTypes != null && this.relationTypes.length == 0;
    }

    public EntityData.SymbolType[] getSymbolTypes() {
        return this.symbolTypes;
    }

    public boolean isEgoType() {
        return this.codeString.contains("E");
    }

    public boolean matchesRelation(EntityRelation entityRelation, String kinTypeModifier) {
        if (entityRelation.getAlterNode().isEgo != this.isEgoType()) {
            return false;
        }
        boolean relationMatchFound = false;
        if (this.relationTypes == null) {
            relationMatchFound = true;
        } else {
            for (DataTypes.RelationType relationType : this.relationTypes) {
                if (!relationType.equals((Object)entityRelation.getRelationType())) continue;
                relationMatchFound = true;
            }
        }
        boolean symbolMatchFound = false;
        if (this.symbolTypes == null) {
            symbolMatchFound = true;
        } else {
            for (EntityData.SymbolType symbolType : this.symbolTypes) {
                for (String symbolName : entityRelation.getAlterNode().getSymbolNames()) {
                    if (!symbolType.name().equals(symbolName)) continue;
                    symbolMatchFound = true;
                }
            }
        }
        if (!relationMatchFound || !symbolMatchFound) {
            return false;
        }
        if (kinTypeModifier != null && !kinTypeModifier.isEmpty()) {
            int relationOrder = entityRelation.getRelationOrder();
            if (kinTypeModifier.equals("-")) {
                if (relationOrder >= 0) {
                    return false;
                }
            } else if (kinTypeModifier.equals("+")) {
                if (relationOrder <= 0) {
                    return false;
                }
            } else {
                int requiredOrder = Integer.parseInt(kinTypeModifier.replaceFirst("^\\+", ""));
                return relationOrder == requiredOrder;
            }
        }
        return true;
    }

    public boolean matchesEgonessAndSymbol(EntityData entityData, String kinTypeModifier) {
        if (!entityData.isEgo || !this.isEgoType()) {
            return false;
        }
        if (this.symbolTypes == null) {
            return true;
        }
        for (EntityData.SymbolType symbolType : this.symbolTypes) {
            for (String symbolName : entityData.getSymbolNames()) {
                if (!symbolType.name().equals(symbolName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(KinType o) {
        if (o == null) {
            return -1;
        }
        if (this.codeString.length() > o.codeString.length()) {
            return -1;
        }
        return this.codeString.compareToIgnoreCase(o.codeString);
    }

    public static KinType[] getReferenceKinTypes() {
        return referenceKinTypes;
    }
}

