/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.IndexerParam;
import nl.mpi.kinnate.entityindexer.ParameterElement;
import nl.mpi.kinnate.ui.TableCellDragHandler;

public class FieldSelectionList
extends JPanel {
    private SavePanel savePanel;
    private JPanel paddingPanel = new JPanel();
    protected IndexerParam indexerParam;

    public FieldSelectionList(SavePanel savePanelLocal, IndexerParam indexerParamLocal, TableCellDragHandler tableCellDragHandler) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.paddingPanel, "First");
        this.savePanel = savePanelLocal;
        this.indexerParam = indexerParamLocal;
        this.populateSelectionList();
        this.setTransferHandler(tableCellDragHandler);
    }

    private void populateSelectionList() {
        this.paddingPanel.setLayout(new BoxLayout(this.paddingPanel, 3));
        this.paddingPanel.removeAll();
        for (ParameterElement parameterElement : this.indexerParam.getValues()) {
            JLabel fieldPathLabel = new JLabel(parameterElement.getXpathString());
            JPanel fieldPanel = new JPanel();
            fieldPanel.setLayout(new BoxLayout(fieldPanel, 2));
            fieldPanel.add(fieldPathLabel);
            fieldPanel.add(new JPanel());
            if (parameterElement.hasSelectedValue()) {
                String[] availableValues = this.indexerParam.getAvailableValues();
                if (availableValues != null) {
                    JComboBox<String> valueSelect = new JComboBox<String>(availableValues);
                    valueSelect.setSelectedItem(parameterElement.getSelectedValue());
                    valueSelect.setActionCommand(parameterElement.getXpathString());
                    fieldPanel.add(valueSelect);
                    valueSelect.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            FieldSelectionList.this.indexerParam.setValue(evt.getActionCommand(), ((JComboBox)evt.getSource()).getSelectedItem().toString());
                            FieldSelectionList.this.populateSelectionList();
                            FieldSelectionList.this.revalidate();
                            FieldSelectionList.this.savePanel.updateGraph();
                            FieldSelectionList.this.savePanel.requiresSave();
                        }
                    });
                } else {
                    JTextField valueField = new JTextField(parameterElement.getSelectedValue());
                    fieldPanel.add(valueField);
                }
            }
            JButton removeButton = new JButton("x");
            removeButton.setToolTipText("delete item");
            int removeButtonSize = removeButton.getFontMetrics(removeButton.getFont()).getHeight();
            removeButton.setPreferredSize(new Dimension(removeButtonSize, removeButtonSize));
            removeButton.setActionCommand(parameterElement.getXpathString());
            removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FieldSelectionList.this.indexerParam.removeValue(evt.getActionCommand());
                    FieldSelectionList.this.populateSelectionList();
                    FieldSelectionList.this.revalidate();
                    FieldSelectionList.this.savePanel.updateGraph();
                    FieldSelectionList.this.savePanel.requiresSave();
                }
            });
            fieldPanel.add(removeButton);
            this.paddingPanel.add(fieldPanel);
        }
        this.paddingPanel.add(new JPanel());
    }

    protected void updateUiList() {
        this.populateSelectionList();
        this.revalidate();
        this.savePanel.updateGraph();
        this.savePanel.requiresSave();
    }
}

