/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.Vector;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBImpl;
import nl.mpi.corpusstructure.ArchiveObjectsDBWrite;
import nl.mpi.corpusstructure.ArchiveObjectsDBWriteImpl;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBWrite;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.corpusstructure.UpdateInProgressException;

public class CorpusStructureDBWriteImpl
extends ArchiveObjectsDBWriteImpl
implements ArchiveObjectsDB,
ArchiveObjectsDBWrite,
CorpusStructureDB,
CorpusStructureDBWrite {
    private HashSet issuedCorpusNodes = new HashSet();
    private PreparedStatement newNodeInCorpusStructureSTM = null;
    private PreparedStatement newNodeInCorpusNodesSTM = null;
    private PreparedStatement updateNodeInCorpusNodesSTM = null;

    public CorpusStructureDBWriteImpl(String dbname, boolean bootstrapMode, String user, String passwd) {
        super(dbname, bootstrapMode, user, passwd);
        this.initPreparedStatements();
        logger.debug((Object)"## CorpusStructureDBWriteImpl constructor done");
    }

    protected synchronized void initPreparedStatements() {
        super.initPreparedStatements();
        try {
            int i;
            this.newNodeInCorpusNodesSTM = this.db.getConnection().prepareStatement("INSERT INTO " + CORPUSNODES + " (NODEID, NODETYPE, FORMAT, NAME, TITLE) VALUES (?,?,?,?,?)");
            this.updateNodeInCorpusNodesSTM = this.db.getConnection().prepareStatement("UPDATE " + CORPUSNODES + " SET NODETYPE = ?, FORMAT = ?, NAME = ?, TITLE = ?" + " WHERE NODEID = ?");
            String cmd = "INSERT INTO " + CORPUSSTRUCTURE + " (NODEID, VPATH, CANONICAL";
            for (i = 0; i < 3; ++i) {
                cmd = cmd + ", VPATH" + i;
            }
            cmd = cmd + ") VALUES (?,?,?";
            for (i = 0; i < 3; ++i) {
                cmd = cmd + ",?";
            }
            cmd = cmd + ")";
            this.newNodeInCorpusStructureSTM = this.db.getConnection().prepareStatement(cmd);
        }
        catch (SQLException e) {
            logger.error((Object)("initPreparedStatements: SQLException: " + e), (Throwable)e);
        }
    }

    protected synchronized void closePreparedStatements() {
        super.closePreparedStatements();
        try {
            if (this.newNodeInCorpusStructureSTM != null) {
                this.newNodeInCorpusStructureSTM.close();
            }
            if (this.updateNodeInCorpusNodesSTM != null) {
                this.updateNodeInCorpusNodesSTM.close();
            }
            if (this.newNodeInCorpusNodesSTM != null) {
                this.newNodeInCorpusNodesSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"closePreparedStatements: ", (Throwable)sqle);
        }
        this.newNodeInCorpusStructureSTM = null;
        this.updateNodeInCorpusNodesSTM = null;
        this.newNodeInCorpusNodesSTM = null;
    }

    public void shutdown() {
        this.issuedCorpusNodes.clear();
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNode(String nodeId, int nodeType, String format, String name, String title) throws UpdateInProgressException, UnknownNodeException {
        boolean log = false;
        if (!this.statusLog("setNode")) {
            return false;
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("setNode: Not a NodeId: " + nodeId + " nodeType=" + nodeType + " format=" + format + " name=" + name + " title=" + title));
            throw new UnknownNodeException("setNode: Not a NodeId: " + nodeId);
        }
        try {
            boolean n = false;
            if (this.isBootstrapMode() && !this.issuedCorpusNodes.contains(nodeId)) {
                throw new UnknownNodeException("create me, don't modify me");
            }
            if (this.isBootstrapMode()) {
                logger.warn((Object)("setNode: Update! Bootstrap mode should not touch nodes twice: " + nodeId));
            }
            Node node = this.getNode(nodeId);
            if (format == null) {
                format = node.getFormat();
            }
            if (name == null) {
                name = node.getName();
            }
            if (title == null) {
                title = node.getTitle();
            }
            if (log) {
                logger.debug((Object)("# setNode: UPDATE " + nodeId + " " + name + " " + nodeType));
            }
            PreparedStatement preparedStatement = this.updateNodeInCorpusNodesSTM;
            synchronized (preparedStatement) {
                this.updateNodeInCorpusNodesSTM.clearParameters();
                this.updateNodeInCorpusNodesSTM.setInt(1, nodeType);
                this.updateNodeInCorpusNodesSTM.setString(2, format);
                this.updateNodeInCorpusNodesSTM.setString(3, name);
                this.updateNodeInCorpusNodesSTM.setString(4, title);
                this.updateNodeInCorpusNodesSTM.setInt(5, NodeIdUtils.TOINT(nodeId));
                if (this.updateNodeInCorpusNodesSTM.executeUpdate() > 0) {
                    return true;
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setNode: SQL exception in update: " + sqle));
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (log) {
            logger.debug((Object)("# setNode: CREATE " + nodeId + " " + name + " " + nodeType));
        }
        try {
            PreparedStatement une = this.newNodeInCorpusNodesSTM;
            synchronized (une) {
                boolean okay;
                this.newNodeInCorpusNodesSTM.clearParameters();
                this.newNodeInCorpusNodesSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                this.newNodeInCorpusNodesSTM.setInt(2, nodeType);
                this.newNodeInCorpusNodesSTM.setString(3, format);
                this.newNodeInCorpusNodesSTM.setString(4, name);
                this.newNodeInCorpusNodesSTM.setString(5, title);
                boolean bl = okay = this.newNodeInCorpusNodesSTM.executeUpdate() > 0;
                if (okay && this.isBootstrapMode()) {
                    this.issuedCorpusNodes.add(nodeId);
                }
                return okay;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setNode: SQL exception in create: " + sqle));
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean deleteCorpusNode(String nodeId) throws UnknownNodeException, UpdateInProgressException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCorpusStructureEntry(String nodeId, String cvPath, boolean canonical) throws UpdateInProgressException, UnknownNodeException {
        if (!this.statusLog("addCorpusStructureEntry")) {
            return;
        }
        this.checkWriteAccess();
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("addCorpusStructureEntry: invalidNodeId: " + nodeId + ", " + cvPath + ", " + canonical));
            throw new UnknownNodeException("addCorpusStructureEntry: invalid NodeId: " + nodeId + ", " + cvPath + ", " + canonical);
        }
        try {
            this.cacheExpire(nodeId);
            PreparedStatement preparedStatement = this.newNodeInCorpusStructureSTM;
            synchronized (preparedStatement) {
                this.setNewNodeInCorpusStructureSTM(nodeId, cvPath, canonical);
                this.newNodeInCorpusStructureSTM.executeUpdate();
            }
            this.cacheExpire(nodeId);
            return;
        }
        catch (SQLException sqle) {
            logger.error((Object)("addCorpusStructureEntry: SQL exception: " + sqle));
            return;
        }
    }

    public boolean addLinkToTree(String nodeId, String parentNodeId, boolean canonical, boolean childIsIMDI) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("addLinkToTree")) {
            return false;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            logger.error((Object)"addLinkToTree: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        if (!NodeIdUtils.isNodeId(nodeId) || parentNodeId != null && !NodeIdUtils.isNodeId(parentNodeId)) {
            logger.error((Object)("addLinkToTree: must use NodeIds: " + nodeId + ", " + parentNodeId + ", " + canonical));
            throw new UnknownNodeException("addLinkToTree: must use NodeIds: " + nodeId + ", " + parentNodeId + ", " + canonical);
        }
        String[] pathsToReplaceWith = new String[]{""};
        if (parentNodeId != null) {
            pathsToReplaceWith = this.getVPaths(parentNodeId);
        }
        boolean okay = true;
        for (int i = 0; pathsToReplaceWith != null && i < pathsToReplaceWith.length; ++i) {
            String childPath = pathsToReplaceWith[i] + '/' + parentNodeId;
            okay &= this.addLinkToPath(nodeId, parentNodeId, childPath, canonical, childIsIMDI);
        }
        return okay;
    }

    /*
     * Exception decompiling
     */
    private boolean addLinkToPath(String nodeId, String parentNodeId, String childPath, boolean canonical, boolean childIsIMDI) throws UnknownNodeException, UpdateInProgressException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized String[] deleteLinksRecursively(String nodeId) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("deleteLinksRecursively")) {
            return null;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            logger.error((Object)"deleteLinksRecursively: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("deleteLinksRecursively: Not a NodeId: " + nodeId));
            throw new UnknownNodeException("deleteLinksRecursively: Not a NodeId: " + nodeId);
        }
        Vector orphans = new Vector();
        String[] vPaths = this.getVPaths(nodeId);
        if (vPaths == null || vPaths.length == 0) {
            throw new UnknownNodeException("deleteLinksRecursively: Node " + nodeId + " was not part of the tree");
        }
        this.cacheExpire(null);
        for (int i = 0; i < vPaths.length; ++i) {
            String vPath = vPaths[i];
            orphans.addAll(this.removeChildOfPath(vPath, nodeId, false));
        }
        if (vPaths.length > 1) {
            logger.debug((Object)("deleteLinksRecursively: deleted " + vPaths.length + " paths to " + nodeId));
        }
        this.cacheExpire(null);
        return orphans.toArray(new String[0]);
    }

    public synchronized String[] removeLink(String nodeId, String childNodeId) throws UnknownNodeException, UpdateInProgressException {
        if (!this.statusLog("removeLink")) {
            return null;
        }
        this.checkWriteAccess();
        if (this.isBootstrapMode()) {
            logger.error((Object)"removeLink: NOT ALLOWED IN BOOTSTRAP MODE");
            System.exit(0);
        }
        if (!NodeIdUtils.isNodeId(nodeId) || !NodeIdUtils.isNodeId(childNodeId)) {
            logger.error((Object)("removeLink: must use NodeIds: " + nodeId + ", " + childNodeId));
            throw new UnknownNodeException("removeLink: must use NodeIds: " + nodeId + ", " + childNodeId);
        }
        Vector orphans = new Vector();
        String[] vPaths = this.getVPaths(nodeId);
        if (vPaths == null || vPaths.length == 0) {
            throw new UnknownNodeException("removeLink: Parent node " + nodeId + " was not part of the tree");
        }
        this.cacheExpire(null);
        for (int i = 0; i < vPaths.length; ++i) {
            String vPath = vPaths[i] + "/" + nodeId;
            orphans.addAll(this.removeChildOfPath(vPath, childNodeId, true));
        }
        if (vPaths.length > 1) {
            logger.debug((Object)("removeLink: " + vPaths.length + " paths to " + nodeId));
        }
        this.cacheExpire(null);
        return orphans.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Vector removeChildOfPath(String vPath, String childNodeId, boolean removeLink) throws UnknownNodeException, UpdateInProgressException {
        block64: {
            block60: {
                block53: {
                    block52: {
                        rs = null;
                        statement = null;
                        cmd = null;
                        orphans = new Vector<String>();
                        statement = this.db.getConnection().createStatement();
                        statement.execute(this.db.startTransaction);
                        cpath = vPath + '/' + childNodeId;
                        cpathQuery = this.matchVPathColumnsSQL(cpath, false);
                        cmd = "SELECT NODEID,VPATH FROM " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " AS CS1" + " WHERE (" + cpathQuery + ")" + " AND NOT EXISTS ( SELECT NODEID FROM " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " AS CS2 " + " WHERE CS1.NODEID = CS2.NODEID AND NOT (" + cpathQuery.replace("VPATH", "CS2.VPATH") + ") )";
                        rs = statement.executeQuery(cmd);
                        while (rs.next()) {
                            node = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                            CorpusStructureDBWriteImpl.logger.debug((Object)("// removeChildOfPath: Orphan grandchild of " + childNodeId + ": " + node));
                            orphans.add(node);
                        }
                        n = 0;
                        if (!removeLink) break block52;
                        cmd = "DELETE FROM " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " WHERE NODEID = " + NodeIdUtils.TOINT(childNodeId) + " AND VPATH = '" + vPath + "'";
                        n = statement.executeUpdate(cmd);
                        if (n != 0) break block53;
                        CorpusStructureDBWriteImpl.logger.warn((Object)("removeChildOfPath: ignored call: " + vPath + " does not lead to " + childNodeId));
                        var11_14 = orphans;
                        var15_17 = null;
                        try {
                            statement.execute(this.db.endTransaction);
                        }
                        catch (SQLException sqle) {
                            // empty catch block
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sqle) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sqle) {
                                // empty catch block
                            }
                        }
                        rs = null;
                        return var11_14;
                    }
                    var11_15 = orphans;
                    var15_18 = null;
                    try {
                        statement.execute(this.db.endTransaction);
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    return var11_15;
                }
                cmd = "DELETE FROM " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " WHERE " + cpathQuery;
                m = statement.executeUpdate(cmd);
                if (n > 1 || m > 0) {
                    CorpusStructureDBWriteImpl.logger.debug((Object)("removeChildOfPath: removed " + n + " links at " + vPath + " - " + childNodeId + " and " + m + " links to grandchildren"));
                }
                rs = statement.executeQuery("SELECT * FROM " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " WHERE NODEID = " + NodeIdUtils.TOINT(childNodeId));
                newCanonicalPath = null;
                if (!rs.next()) ** GOTO lbl121
                if (!rs.getBoolean("CANONICAL")) break block60;
                var13_32 = orphans;
                var15_19 = null;
                try {
                    statement.execute(this.db.endTransaction);
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                rs = null;
                return var13_32;
            }
            newCanonicalPath = rs.getString("VPATH");
lbl121:
            // 2 sources

            if (newCanonicalPath != null) break block64;
            CorpusStructureDBWriteImpl.logger.debug((Object)("removeLink created orphan child " + childNodeId));
            orphans.add(childNodeId);
            var13_33 = orphans;
            var15_20 = null;
            try {
                statement.execute(this.db.endTransaction);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            rs = null;
            return var13_33;
        }
        cmd = "UPDATE " + CorpusStructureDBWriteImpl.CORPUSSTRUCTURE + " SET CANONICAL = TRUE " + " WHERE NODEID = " + NodeIdUtils.TOINT(childNodeId) + " AND VPATH = '" + newCanonicalPath + "'";
        n = statement.executeUpdate(cmd);
        if (n == 0) {
            CorpusStructureDBWriteImpl.logger.warn((Object)("removeLink: No canonical path left for " + childNodeId));
        }
        if (n > 1) {
            CorpusStructureDBWriteImpl.logger.error((Object)("removeLink: There are now several canonical paths for " + childNodeId));
        }
        var13_34 = orphans;
        var15_21 = null;
        try {
            statement.execute(this.db.endTransaction);
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        rs = null;
        return var13_34;
        catch (SQLException sqle) {
            try {
                try {
                    statement.execute(this.db.rollbackTransaction);
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                CorpusStructureDBWriteImpl.logger.error((Object)("removeChildOfPath: SQL exception in command: " + cmd + " -> " + sqle));
                var15_22 = null;
            }
            catch (Throwable var14_35) {
                var15_23 = null;
                try {
                    statement.execute(this.db.endTransaction);
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
                rs = null;
                throw var14_35;
            }
            try {
                statement.execute(this.db.endTransaction);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
            }
            rs = null;
            {
            }
        }
        throw new UnknownNodeException("removeChildOfPath: error, no result for: " + vPath + " - " + childNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void replaceDescendantAccessRights(String nodeId, String oldReadRights, String newRights) throws UpdateInProgressException, UnknownNodeException {
        block22: {
            Statement statement;
            block21: {
                if (!this.statusLog("replaceDescendantAccessRights")) {
                    return;
                }
                this.checkWriteAccess();
                if (!NodeIdUtils.isNodeId(nodeId)) {
                    logger.error((Object)("replaceDescendantAccessRights: not a nodeId: " + nodeId));
                    throw new UnknownNodeException("replaceDescendantAccessRights: not a nodeId: " + nodeId);
                }
                if (this.isBootstrapMode()) {
                    logger.warn((Object)"replaceDescendantAccessRights: ignored in bootstrap mode");
                    return;
                }
                if (newRights == null || !newRights.matches("^[a-zA-Z0-9_@.,;: -]*$")) {
                    throw new IllegalArgumentException("replaceDescendantAccessRights: new rights contain unsupported characters: " + newRights);
                }
                if (oldReadRights == null || !oldReadRights.matches("^[a-zA-Z0-9_@.,;: -]*$")) {
                    throw new IllegalArgumentException("replaceDescendantAccessRights: old rights contain unsupported characters: " + oldReadRights);
                }
                if (!(oldReadRights.equals("everybody") || oldReadRights.equals("nobody") || oldReadRights.equals("cleared") || oldReadRights.equals("anyAuthenticatedUser") || oldReadRights.equals("ignore"))) {
                    throw new IllegalArgumentException("replaceDescendantAccessRights: old rights must be one of the AccessInfo constants, not: " + oldReadRights);
                }
                if (!(newRights.equals("everybody") || newRights.equals("nobody") || newRights.equals("cleared") || newRights.equals("anyAuthenticatedUser"))) {
                    throw new IllegalArgumentException("replaceDescendantAccessRights: new rights must be one of the AccessInfo constants, not: " + newRights);
                }
                logger.debug((Object)("replaceDescendantAccessRights: nodeId=" + nodeId + " oldReadRights=" + oldReadRights + " newRights=" + newRights));
                boolean iterate = this.getRootNodeId().equals(nodeId);
                statement = null;
                String rightQuery = "";
                String query = null;
                String vPath = this.getCanonicalVPath(nodeId) + "/" + nodeId;
                String vq = this.matchVPathColumnsSQL(vPath, false);
                if (!oldReadRights.equals("ignore")) {
                    rightQuery = "READRIGHTS = '" + oldReadRights + "' AND ";
                }
                query = "SELECT DISTINCT NODEID FROM " + CORPUSSTRUCTURE + " WHERE " + vq + " OR NODEID = " + NodeIdUtils.TOINT(nodeId);
                String uQuery = "UPDATE " + ARCHIVEOBJECTS + " SET READRIGHTS = '" + newRights + "', WRITERIGHTS = '" + newRights + "'";
                if (vq.toUpperCase().indexOf("LIKE") == -1 && vq.toUpperCase().indexOf("BETWEEN") == -1) {
                    iterate = true;
                }
                if (vq.toUpperCase().indexOf("VPATH2") != -1) {
                    iterate = false;
                }
                if (this.db.dbType == 1) {
                    iterate = false;
                }
                uQuery = iterate ? uQuery + " WHERE " + rightQuery + "EXISTS ( " + query.replace("DISTINCT", "") + " AND " + ARCHIVEOBJECTS + ".NODEID = " + CORPUSSTRUCTURE + ".NODEID )" : uQuery + " WHERE " + rightQuery + "NODEID IN ( " + query + " )";
                logger.debug((Object)("### replaceDescendantAccessRights: query = " + uQuery));
                statement = this.db.getConnection().createStatement();
                int n = statement.executeUpdate(uQuery);
                logger.info((Object)("replaceDescendantAccessRights: updated access rights n=" + n));
                Object var13_13 = null;
                if (statement == null) break block21;
                try {
                    statement.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
            statement = null;
            {
                break block22;
                catch (SQLException sqle) {
                    logger.error((Object)"replaceDescendantAccessRights: ", (Throwable)sqle);
                    Object var13_14 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle2) {
                            // empty catch block
                        }
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                statement = null;
                throw throwable;
            }
        }
    }

    protected void setNewNodeInCorpusStructureSTM(String nodeId, String vPath, boolean canonical) throws SQLException {
        this.newNodeInCorpusStructureSTM.clearParameters();
        this.newNodeInCorpusStructureSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
        this.newNodeInCorpusStructureSTM.setString(2, vPath);
        this.newNodeInCorpusStructureSTM.setBoolean(3, canonical);
        String[] id = vPath.split("/");
        for (int i = 0; i < 3; ++i) {
            if (i < id.length - 1) {
                this.newNodeInCorpusStructureSTM.setInt(4 + i, NodeIdUtils.TOINT(id[i + 1]));
                continue;
            }
            this.newNodeInCorpusStructureSTM.setNull(4 + i, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String[] listDescendants(String nodeId) throws UnknownNodeException {
        SQLException sqle222;
        String[] descId;
        ResultSet rs;
        Statement statement;
        block26: {
            if (!this.statusLog("listDescendants")) {
                return null;
            }
            String query = "SELECT nodeid FROM " + CORPUSSTRUCTURE + " WHERE ";
            String[] vPaths = this.getVPaths(nodeId);
            if (vPaths == null || vPaths.length == 0) {
                logger.error((Object)("listDescendants: Node is not linked: " + nodeId));
                return null;
            }
            String[] commonPathElements = vPaths[0].split("/");
            if (vPaths.length > 1 && commonPathElements.length > 1) {
                for (int i = 1; i < vPaths.length; ++i) {
                    String[] id = vPaths[i].split("/");
                    for (int j = 0; j < commonPathElements.length; ++j) {
                        if (j >= id.length) {
                            commonPathElements[j] = null;
                        }
                        if (commonPathElements[j] == null || commonPathElements[j].equals(id[j])) continue;
                        commonPathElements[j] = null;
                    }
                }
                String commonPath = "";
                for (int i = 1; commonPathElements[i] != null && i < commonPathElements.length; ++i) {
                    commonPath = commonPath + "/" + commonPathElements[i];
                }
                if (commonPath.lastIndexOf("/") > 1) {
                    query = query + this.matchVPathColumnsSQL(commonPath, false) + " AND ";
                    logger.debug((Object)("listDescendants: Constraint for: " + nodeId + " Prefix: " + commonPath + "* Paths: " + vPaths.length));
                }
            }
            query = query + "(";
            for (int i = 0; i < vPaths.length; ++i) {
                String vPath = vPaths[i] + "/" + nodeId;
                query = query + this.matchVPathColumnsSQL(vPath, false);
                if (i + 1 >= vPaths.length) continue;
                query = query + " OR ";
            }
            query = query + ")";
            statement = null;
            rs = null;
            TreeSet<String[]> items = new TreeSet<String[]>(new ArchiveObjectsDBImpl.NodeIdComparator());
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(query);
            while (rs.next()) {
                descId = NodeIdUtils.TONODEID(rs.getInt(1));
                items.add(descId);
            }
            descId = items.toArray(new String[0]);
            Object var11_17 = null;
            if (statement == null) break block26;
            try {
                statement.close();
            }
            catch (SQLException sqle222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqle222) {
                // empty catch block
            }
        }
        rs = null;
        return descId;
        catch (SQLException sqle3) {
            SQLException sqle222;
            String[] stringArray;
            block28: {
                try {
                    logger.error((Object)"listDescendants: ", (Throwable)sqle3);
                    stringArray = null;
                    Object var11_18 = null;
                    if (statement == null) break block28;
                }
                catch (Throwable throwable) {
                    SQLException sqle222;
                    Object var11_19 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sqle222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException sqle222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle222) {
                    // empty catch block
                }
            }
            rs = null;
            return stringArray;
        }
    }

    public void close() {
        this.issuedCorpusNodes.clear();
        super.close();
    }
}

