/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.data;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.FilteredNodeContainer;
import nl.mpi.kinnate.data.KinTreeFilteredNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.SymbolGraphic;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTreeNode
extends ArbilNode
implements Comparable {
    private UniqueIdentifier uniqueIdentifier;
    protected EntityData entityData = null;
    protected IndexerParameters indexerParameters;
    protected ArbilNode[] childNodes = null;
    private static SymbolGraphic symbolGraphic = null;
    protected EntityCollection entityCollection;
    protected MessageDialogHandler dialogHandler;
    protected ArbilDataNodeLoader dataNodeLoader;
    private String derivedLabelString = null;

    public KinTreeNode(UniqueIdentifier uniqueIdentifier, EntityData entityData, IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.uniqueIdentifier = uniqueIdentifier;
        this.indexerParameters = indexerParameters;
        this.entityData = entityData;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        if (symbolGraphic == null) {
            symbolGraphic = new SymbolGraphic(dialogHandler);
        }
    }

    public EntityData getEntityData() {
        return this.entityData;
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public String toString() {
        if (this.derivedLabelString == null) {
            if (this.entityData == null) {
                return "(entity not loaded)";
            }
            StringBuilder labelBuilder = new StringBuilder();
            String[] labelArray = this.entityData.getLabel();
            if (labelArray != null && labelArray.length > 0) {
                for (String labelString : labelArray) {
                    labelBuilder.append(labelString);
                    labelBuilder.append(" ");
                }
            } else {
                labelBuilder.append("              ");
            }
            this.derivedLabelString = labelBuilder.toString();
        }
        return this.derivedLabelString;
    }

    public ArbilDataNode[] getAllChildren() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getAllChildren(Vector<ArbilDataNode> allChildren) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ArbilNode[] getChildArray() {
        if (this.childNodes == null) {
            HashMap metaNodeMap = new HashMap();
            for (EntityRelation entityRelation : this.entityData.getAllRelations()) {
                if (!metaNodeMap.containsKey((Object)entityRelation.getRelationType())) {
                    metaNodeMap.put(entityRelation.getRelationType(), new HashSet());
                }
                ((HashSet)metaNodeMap.get((Object)entityRelation.getRelationType())).add(new KinTreeFilteredNode(entityRelation, this.indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader));
            }
            HashSet<ArbilNode> kinTreeMetaNodes = new HashSet<ArbilNode>();
            for (Map.Entry filteredNodeEntry : metaNodeMap.entrySet()) {
                kinTreeMetaNodes.add((ArbilNode)new FilteredNodeContainer(((DataTypes.RelationType)((Object)filteredNodeEntry.getKey())).name(), null, ((HashSet)filteredNodeEntry.getValue()).toArray(new KinTreeFilteredNode[0])));
            }
            this.getLinksMetaNode(kinTreeMetaNodes);
            this.childNodes = kinTreeMetaNodes.toArray(new ArbilNode[0]);
        }
        return this.childNodes;
    }

    protected void getLinksMetaNode(HashSet<ArbilNode> kinTreeMetaNodes) {
        if (this.entityData.archiveLinkArray != null) {
            HashSet<ArbilDataNode> relationList = new HashSet<ArbilDataNode>();
            for (URI archiveLink : this.entityData.archiveLinkArray) {
                ArbilDataNode linkedArbilDataNode = this.dataNodeLoader.getArbilDataNode(null, archiveLink);
                relationList.add(linkedArbilDataNode);
            }
            kinTreeMetaNodes.add((ArbilNode)new ContainerNode("External Links", null, (ArbilNode[])relationList.toArray(new ArbilDataNode[0])));
        }
    }

    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getIcon() {
        if (this.entityData != null) {
            return symbolGraphic.getSymbolGraphic(this.entityData.getSymbolNames(), this.entityData.isEgo);
        }
        return null;
    }

    public boolean hasCatalogue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasHistory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasLocalResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isArchivableFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCatalogue() {
        return false;
    }

    public boolean isChildNode() {
        return false;
    }

    public boolean isCmdiMetaDataNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCorpus() {
        return false;
    }

    public boolean isDataLoaded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isEditable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEmptyMetaNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isFavorite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLoading() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDataPartiallyLoaded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLocal() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isMetaDataNode() {
        return false;
    }

    public boolean isResourceSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSession() {
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof KinTreeNode) {
            int compResult = this.toString().compareTo(o.toString());
            if (compResult == 0) {
                // empty if block
            }
            return compResult;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KinTreeNode other = (KinTreeNode)obj;
        return this.entityData == other.entityData;
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + (this.uniqueIdentifier != null ? this.uniqueIdentifier.hashCode() : 0);
        return hash;
    }
}

