/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import javax.xml.bind.annotation.XmlAttribute;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityRelation;

public class RelationTypeDefinition {
    @XmlAttribute(name="name", namespace="http://mpi.nl/tla/kin")
    private String displayName;
    @XmlAttribute(name="type", namespace="http://mpi.nl/tla/kin")
    private DataTypes.RelationType[] relationType;
    @XmlAttribute(name="dcr", namespace="http://mpi.nl/tla/kin")
    private String dataCategory;
    @XmlAttribute(name="colour", namespace="http://mpi.nl/tla/kin")
    private String lineColour;
    @XmlAttribute(name="width", namespace="http://mpi.nl/tla/kin")
    private int lineWidth;
    @XmlAttribute(name="style", namespace="http://mpi.nl/tla/kin")
    private String lineStye;
    @XmlAttribute(name="orientation", namespace="http://mpi.nl/tla/kin")
    private CurveLineOrientation curveLineOrientation = CurveLineOrientation.horizontal;

    public RelationTypeDefinition() {
    }

    public RelationTypeDefinition(String displayName, String dataCategory, DataTypes.RelationType[] relationType, String lineColour, int lineWidth, String lineStye) {
        this.displayName = displayName;
        this.relationType = relationType;
        this.dataCategory = dataCategory;
        this.lineColour = lineColour;
        this.lineWidth = lineWidth;
        this.lineStye = lineStye;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLineColour() {
        return this.lineColour;
    }

    public String getLineStye() {
        return this.lineStye;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public String getDataCategory() {
        return this.dataCategory;
    }

    public DataTypes.RelationType[] getRelationType() {
        return this.relationType;
    }

    public CurveLineOrientation getCurveLineOrientation() {
        return this.curveLineOrientation;
    }

    public boolean matchesType(EntityRelation entityRelation) {
        if (entityRelation == null) {
            return false;
        }
        if (this.dataCategory == null ? entityRelation.dcrType != null : !this.dataCategory.equals(entityRelation.dcrType)) {
            return false;
        }
        if (this.relationType == null) {
            if (entityRelation.getRelationType() != null) {
                return false;
            }
        } else {
            boolean foundType = false;
            DataTypes.RelationType entityRelationType = entityRelation.getRelationType();
            for (DataTypes.RelationType currentType : this.relationType) {
                if (!currentType.equals((Object)entityRelationType)) continue;
                foundType = true;
            }
            if (!foundType) {
                return false;
            }
        }
        return !(this.displayName == null ? entityRelation.customType != null : !this.displayName.equals(entityRelation.customType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CurveLineOrientation {
        horizontal,
        vertical;

    }
}

