/*
 * Decompiled with CFR 0.152.
 */
package net.handle.jdb;

import java.io.File;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.handle.jdb.BlockCache;
import net.handle.jdb.DBHash;
import net.handle.jdb.HashBlock;

public class RO_DBHash {
    public static final String V1_FILE_ID = "JDBHash v0.1";
    private static final int BLOCK_SIZE = 1024;
    private static final int START_HEADER_SIZE = 17;
    private static final int START_WCONT_HEADER_SIZE = 25;
    private static final int CONT_HEADER_SIZE = 5;
    private static final int CONT_WCONT_HEADER_SIZE = 13;
    private RandomAccessFile raFile;
    private File hashFile;
    private int hashLength;
    private MessageDigest md5;
    private byte[] buf = new byte[1024];
    private long[] hashIndex;
    private BlockCache cache;
    public boolean DEBUG = false;

    public RO_DBHash(File hashFile, int hashLength, int cacheSize) throws Exception {
        if (hashLength < 0) {
            throw new IllegalArgumentException("The hash length (" + hashLength + ") must be >= 0");
        }
        this.hashFile = hashFile;
        this.hashLength = hashLength;
        this.cache = new BlockCache(cacheSize);
        if (!hashFile.exists()) {
            throw new Exception("Hash file " + hashFile.getPath() + "doesn't exist.");
        }
        this.raFile = new RandomAccessFile(hashFile, "r");
        this.loadFromFile();
        this.md5 = MessageDigest.getInstance("MD5");
    }

    public void close() throws Exception {
        this.raFile.close();
    }

    public final synchronized byte[] getValue(byte[] key) throws Exception {
        byte[] digest = this.md5.digest(key);
        int digestLen = digest.length;
        int hash = 0xFF & digest[digestLen - 1] | (0xFF & digest[digestLen - 2]) << 8 | (0xFF & digest[digestLen - 3]) << 16 | (0xFF & digest[digestLen - 4]) << 24;
        int hashKey = (hash & Integer.MAX_VALUE) % this.hashLength;
        long recordLoc = this.hashIndex[hashKey];
        if (this.DEBUG) {
            System.err.println(" getvalue(" + new String(key) + ") startLoc: " + Long.toHexString(recordLoc));
        }
        if (recordLoc <= 0L) {
            return null;
        }
        HashBlock block = this.getValueAtBlock(recordLoc, key);
        if (block != null) {
            return block.data;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized HashBlock readBlock(long blockNum) throws Exception {
        HashBlock block = (HashBlock)this.cache.getBlock(blockNum);
        if (this.DEBUG) {
            System.err.println("    reading block# " + Long.toHexString(blockNum));
        }
        if (block != null) {
            block.lastTouched = System.currentTimeMillis();
            if (this.DEBUG) {
                System.err.println("    block was cached");
            }
            return block;
        }
        block = new HashBlock();
        this.raFile.seek(blockNum);
        this.raFile.readFully(this.buf);
        byte blockCode = this.buf[0];
        int keyLen = (this.buf[1] & 0xFF) << 24 | (this.buf[2] & 0xFF) << 16 | (this.buf[3] & 0xFF) << 8 | this.buf[4] & 0xFF;
        int dataLen = (this.buf[5] & 0xFF) << 24 | (this.buf[6] & 0xFF) << 16 | (this.buf[7] & 0xFF) << 8 | this.buf[8] & 0xFF;
        block.thisRecord = blockNum;
        block.nextRecord = ((long)this.buf[9] & 0xFFL) << 56 | ((long)this.buf[10] & 0xFFL) << 48 | ((long)this.buf[11] & 0xFFL) << 40 | ((long)this.buf[12] & 0xFFL) << 32 | ((long)this.buf[13] & 0xFFL) << 24 | ((long)this.buf[14] & 0xFFL) << 16 | ((long)this.buf[15] & 0xFFL) << 8 | (long)this.buf[16] & 0xFFL;
        int bloc = 17;
        if (keyLen > 10000 || keyLen < 0 || dataLen > 1000000 || dataLen < 0) {
            System.err.println("invalid key/data length at block: " + Long.toHexString(blockNum) + '\n' + "  nextRecord=" + Long.toHexString(block.nextRecord) + '\n' + "  keyLen=" + keyLen + '\n' + "  dataLen=" + dataLen);
            throw new Exception("Data corruption exception.  Invalid key/data length");
        }
        block.key = new byte[keyLen];
        block.data = new byte[dataLen];
        int len = keyLen + dataLen;
        boolean willContinue = len + 17 > 1024;
        int numBlocks = 1;
        int remainingLength = willContinue ? len - 999 : len - 1007;
        if (remainingLength > 0) {
            ++numBlocks;
            remainingLength -= 1019;
        }
        while (remainingLength > 0) {
            ++numBlocks;
            remainingLength -= 1011;
        }
        long contBlock = 0L;
        int numRead = 0;
        for (int i = 0; i < numBlocks; ++i) {
            void var15_14;
            int thisHeaderSize;
            int numReadThisBlock = 0;
            if (i < numBlocks - 1) {
                contBlock = ((long)this.buf[bloc] & 0xFFL) << 56 | ((long)this.buf[bloc + 1] & 0xFFL) << 48 | ((long)this.buf[bloc + 2] & 0xFFL) << 40 | ((long)this.buf[bloc + 3] & 0xFFL) << 32 | ((long)this.buf[bloc + 4] & 0xFFL) << 24 | ((long)this.buf[bloc + 5] & 0xFFL) << 16 | ((long)this.buf[bloc + 6] & 0xFFL) << 8 | (long)this.buf[bloc + 7] & 0xFFL;
                bloc += 8;
            }
            if (i == 0) {
                thisHeaderSize = numBlocks > 1 ? 25 : 17;
            } else if (i < numBlocks - 1) {
                thisHeaderSize = 13;
            } else if (i == numBlocks - 1) {
                thisHeaderSize = 5;
            } else {
                throw new Exception("File corrupted!! This shouldn't happen!!!!");
            }
            int loopcount = 0;
            while (numReadThisBlock < 1024 - var15_14) {
                int r;
                if (numRead + numReadThisBlock < keyLen) {
                    r = Math.min(keyLen - numRead, 1024 - var15_14);
                    System.arraycopy(this.buf, bloc, block.key, numRead, r);
                    bloc += r;
                    numReadThisBlock += r;
                }
                if (numRead + numReadThisBlock < len && numReadThisBlock < 1024 - var15_14) {
                    r = Math.min(len - numRead - numReadThisBlock, 1024 - var15_14 - numReadThisBlock);
                    System.arraycopy(this.buf, bloc, block.data, numRead + numReadThisBlock - keyLen, r);
                    bloc += r;
                    numReadThisBlock += r;
                }
                if (numRead + numReadThisBlock >= len) break;
                ++loopcount;
            }
            numRead += numReadThisBlock;
            if (i >= numBlocks - 1) continue;
            this.raFile.seek(contBlock);
            this.raFile.readFully(this.buf);
            bloc = 5;
        }
        this.cache.putBlock(block);
        return block;
    }

    private final HashBlock getValueAtBlock(long blockNum, byte[] key) throws Exception {
        HashBlock block;
        boolean steps = false;
        do {
            block = this.readBlock(blockNum);
            if (this.keyMatches(block.key, key)) {
                if (this.DEBUG) {
                    System.err.println("   found block: " + new String(block.key));
                }
                return block;
            }
            if (this.DEBUG) {
                System.err.println("   skipping block: " + new String(block.key) + "; len=" + key.length);
            }
            blockNum = block.nextRecord;
        } while (block.nextRecord > 0L);
        return null;
    }

    private final boolean keyMatches(byte[] key1, byte[] key2) {
        if (key1 == null || key2 == null || key1.length != key2.length) {
            return false;
        }
        for (int i = 0; i < key1.length; ++i) {
            if (key1[i] == key2[i]) continue;
            return false;
        }
        return true;
    }

    private final synchronized void loadFromFile() throws Exception {
        String fileID = this.raFile.readUTF();
        if (fileID == null || !fileID.equals(V1_FILE_ID)) {
            throw new Exception("Invalid file ID");
        }
        this.hashLength = this.raFile.readInt();
        if (this.hashLength < 0) {
            throw new IllegalArgumentException("The hash length (" + this.hashLength + ") must be >= 0");
        }
        this.hashIndex = new long[this.hashLength];
        for (int i = 0; i < this.hashLength; ++i) {
            this.hashIndex[i] = this.raFile.readLong();
        }
    }

    public synchronized void dumpDepthGraph() throws Exception {
        System.err.println("Dumping graph: ");
        for (int h = 0; h < this.hashIndex.length; ++h) {
            long index = this.hashIndex[h];
            if (index <= 0L) continue;
            do {
                HashBlock block = this.readBlock(index);
                index = block.nextRecord;
                System.err.print('X');
            } while (index > 0L);
            System.err.println("");
        }
    }

    public synchronized void dumpRecords(PrintStream out) {
        Enumeration recs = this.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] keydata = (byte[][])recs.nextElement();
            out.print(new String(keydata[0]));
            out.println("");
        }
    }

    public Enumeration getEnumerator() {
        return new TableIterator();
    }

    public void dumpDataStructure(PrintStream out) {
        out.println("Dumping data structure: ");
        Vector blocksRead = new Vector();
        HashBlock block = null;
        long blockNum = 0L;
        for (int hash = 0; hash < this.hashIndex.length; ++hash) {
            while (hash < this.hashIndex.length && this.hashIndex[hash] == 0L) {
                ++hash;
            }
            if (hash >= this.hashIndex.length) break;
            blockNum = this.hashIndex[hash];
            out.println("Hash Index=" + hash + " location(h)=" + Long.toHexString(blockNum));
            do {
                try {
                    block = this.readBlock(blockNum);
                    blockNum = block.nextRecord;
                    out.println("   Read block# " + Long.toHexString(block.thisRecord) + '\n' + "         next# " + Long.toHexString(block.nextRecord) + '\n' + "       touched " + new Date(block.lastTouched) + '\n' + "           key " + new String(block.key) + '\n');
                }
                catch (Exception e) {
                    out.println("   Got exception reading block hash# " + hash + '\n' + "       block#" + Long.toHexString(blockNum) + '\n' + "       e: " + e);
                    e.printStackTrace(out);
                    blockNum = 0L;
                }
            } while (blockNum > 0L);
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 1) {
            String dbfile = argv[0];
            System.err.println("loading " + dbfile);
            DBHash db = new DBHash(new File(dbfile), 5000, 1000);
            System.err.println("dumping database...");
            db.dumpRecords(System.err);
        } else {
            System.err.println("usage: java net.handle.jdb.DBHash <dbfile>");
        }
    }

    class TableIterator
    implements Enumeration {
        private int currentHash = -1;
        private HashBlock currentBlock = null;

        TableIterator() {
        }

        public final boolean hasMoreElements() {
            if (this.currentBlock != null && this.currentBlock.nextRecord > 0L) {
                return true;
            }
            for (int h = this.currentHash + 1; h < RO_DBHash.this.hashIndex.length; ++h) {
                if (RO_DBHash.this.hashIndex[h] <= 0L) continue;
                return true;
            }
            return false;
        }

        public final Object nextElement() throws NoSuchElementException {
            try {
                if (this.currentBlock != null && this.currentBlock.nextRecord > 0L) {
                    this.currentBlock = RO_DBHash.this.readBlock(this.currentBlock.nextRecord);
                    if (this.currentBlock != null) {
                        return new byte[][]{this.currentBlock.key, this.currentBlock.data};
                    }
                }
                while (this.currentHash < RO_DBHash.this.hashIndex.length - 1) {
                    ++this.currentHash;
                    long block = RO_DBHash.this.hashIndex[this.currentHash];
                    if (block <= 0L) continue;
                    this.currentBlock = RO_DBHash.this.readBlock(block);
                    return new byte[][]{this.currentBlock.key, this.currentBlock.data};
                }
            }
            catch (Exception e) {
                System.err.println("Exception enumerating blocks: " + e);
                System.err.println("currentBlock=\"" + (this.currentBlock == null ? "null" : new String(this.currentBlock.key) + "\" at " + Long.toHexString(this.currentBlock.thisRecord)));
                e.printStackTrace(System.err);
            }
            throw new NoSuchElementException();
        }
    }
}

