/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilRootNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.templates.ArbilFavourites;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MetadataBuilder {
    private static MessageDialogHandler messageDialogHandler;
    private static WindowManager windowManager;
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static DataNodeLoader dataNodeLoader;
    private ArbilComponentBuilder arbilComponentBuilder = new ArbilComponentBuilder();

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public void requestRootAddNode(String nodeType, String nodeTypeDisplayName) {
        ArbilDataNode arbilDataNode = dataNodeLoader.createNewDataNode(sessionStorage.getNewArbilFileName(sessionStorage.getSaveLocation(""), nodeType));
        this.requestAddNode(arbilDataNode, nodeType, nodeTypeDisplayName);
    }

    public void requestAddRootNode(ArbilDataNode addableNode, String nodeTypeDisplayNameLocal) {
        this.creatAddAddableNodeThread(null, nodeTypeDisplayNameLocal, addableNode).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddChildNode(ArbilDataNode destinationNode, String nodeType) {
        String targetXmlPath = destinationNode.getURI().getFragment();
        Object object = destinationNode.getParentDomLockObject();
        synchronized (object) {
            if (nodeType.startsWith(".") && destinationNode.isCmdiMetaDataNode()) {
                return this.arbilComponentBuilder.canInsertChildComponent(destinationNode, targetXmlPath, nodeType);
            }
            if (destinationNode.getNodeTemplate().isArbilChildNode(nodeType) && destinationNode.getNodeTemplate().getMaxOccursForTemplate(nodeType) >= 0) {
                System.out.println("adding to current node");
                try {
                    Document nodDom = ArbilComponentBuilder.getDocument(destinationNode.getURI());
                    if (nodDom != null) {
                        return MetadataReader.getSingleInstance().canInsertFromTemplate(destinationNode.getNodeTemplate(), nodeType, targetXmlPath, nodDom);
                    }
                    messageDialogHandler.addMessageDialogToQueue("The metadata file could not be opened", "Add Node");
                }
                catch (ParserConfigurationException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (SAXException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (IOException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (ArbilMetadataException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            return true;
        }
    }

    public void requestAddNode(final ArbilDataNode destinationNode, final String nodeType, final String nodeTypeDisplayName) {
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArbilDataNode addedNode = null;
                destinationNode.updateLoadingState(1);
                Object object = destinationNode.getParentDomLockObject();
                synchronized (object) {
                    try {
                        System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName);
                        addedNode = MetadataBuilder.this.processAddNodes(destinationNode, nodeType, destinationNode.getURI().getFragment(), nodeTypeDisplayName, null, null, null);
                    }
                    catch (ArbilMetadataException exception) {
                        messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                    }
                }
                destinationNode.updateLoadingState(-1);
                if (addedNode != null) {
                    destinationNode.triggerNodeAdded(addedNode);
                }
            }
        }.start();
    }

    public void requestAddNode(ArbilDataNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) {
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        this.creatAddAddableNodeThread(destinationNode, nodeTypeDisplayNameLocal, addableNode).start();
    }

    private Thread creatAddAddableNodeThread(final ArbilDataNode destinationNode, final String nodeTypeDisplayNameLocal, final ArbilDataNode addableNode) {
        return new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (destinationNode != null) {
                        destinationNode.updateLoadingState(1);
                        MetadataBuilder.this.addNode(destinationNode, nodeTypeDisplayNameLocal, addableNode);
                    } else {
                        MetadataBuilder.this.addNodeToRoot(nodeTypeDisplayNameLocal, addableNode);
                    }
                }
                catch (ArbilMetadataException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                }
                catch (UnsupportedOperationException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), "Insert node error");
                }
                finally {
                    if (destinationNode != null) {
                        destinationNode.updateLoadingState(-1);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(ArbilDataNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) throws ArbilMetadataException {
        Object object = destinationNode.getParentDomLockObject();
        synchronized (object) {
            if (addableNode.isMetaDataNode()) {
                this.addMetaDataNode(destinationNode, nodeTypeDisplayNameLocal, addableNode);
            } else {
                this.addNonMetaDataNode(destinationNode, nodeTypeDisplayNameLocal, addableNode);
            }
        }
    }

    public void addNodeToRoot(String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) throws ArbilMetadataException {
        if (addableNode.isMetaDataNode()) {
            this.addMetaDataNode(null, nodeTypeDisplayNameLocal, addableNode);
        } else {
            this.addNonMetaDataNode(null, nodeTypeDisplayNameLocal, addableNode);
        }
    }

    private void addNonMetaDataNode(ArbilDataNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) throws ArbilMetadataException {
        String nodeTypeDisplayName = nodeTypeDisplayNameLocal;
        ArbilDataNode[] sourceArbilNodeArray = addableNode.isContainerNode() ? addableNode.getChildArray() : new ArbilDataNode[]{addableNode};
        for (ArbilDataNode currentArbilNode : sourceArbilNodeArray) {
            String nodeType;
            if (destinationNode.isCmdiMetaDataNode()) {
                new ArbilComponentBuilder().insertResourceProxy(destinationNode, addableNode);
                destinationNode.getParentDomNode().loadArbilDom();
                continue;
            }
            String favouriteUrlString = null;
            URI resourceUrl = null;
            String mimeType = null;
            if (currentArbilNode.isArchivableFile() && !currentArbilNode.isMetaDataNode()) {
                nodeType = MetadataReader.getSingleInstance().getNodeTypeFromMimeType(currentArbilNode.mpiMimeType);
                if (nodeType == null) {
                    nodeType = this.handleUnknownMimetype(currentArbilNode);
                }
                resourceUrl = currentArbilNode.getURI();
                mimeType = currentArbilNode.mpiMimeType;
                nodeTypeDisplayName = "Resource";
            } else {
                nodeType = ArbilFavourites.getSingleInstance().getNodeType(currentArbilNode, destinationNode);
                favouriteUrlString = currentArbilNode.getUrlString();
            }
            if (nodeType == null) continue;
            String targetXmlPath = destinationNode.getURI().getFragment();
            System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName + " : " + favouriteUrlString + " : " + resourceUrl);
            this.processAddNodes(destinationNode, nodeType, targetXmlPath, nodeTypeDisplayName, favouriteUrlString, mimeType, resourceUrl);
            destinationNode.getParentDomNode().loadArbilDom();
        }
    }

    private String handleUnknownMimetype(ArbilDataNode currentArbilNode) {
        if (0 == messageDialogHandler.showDialogBox("There is no controlled vocabulary for either Written Resource or Media File that match \"" + currentArbilNode.mpiMimeType + "\".\n" + "This probably means that the file is not archivable. However, you can proceed by manually selecting the resource type.\n\n" + "Do you want to proceed?\n\nWARNING: Doing this will not guarantee that your data will be uploadable to the corpus server!", "Add Resource", 0, -1)) {
            String originalMime = currentArbilNode.mpiMimeType;
            currentArbilNode.mpiMimeType = null;
            if (new ImdiUtils().overrideTypecheckerDecision(new ArbilDataNode[]{currentArbilNode})) {
                return MetadataReader.getSingleInstance().getNodeTypeFromMimeType(currentArbilNode.mpiMimeType);
            }
            currentArbilNode.mpiMimeType = originalMime;
        }
        return null;
    }

    private void addMetaDataNode(ArbilDataNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) throws ArbilMetadataException {
        URI addedNodeUri;
        if (addableNode.getURI().getFragment() == null) {
            addedNodeUri = destinationNode != null ? sessionStorage.getNewArbilFileName(destinationNode.getSubDirectory(), addableNode.getURI().getPath()) : sessionStorage.getNewArbilFileName(sessionStorage.getSaveLocation(""), addableNode.getURI().getPath());
            ArbilDataNode.getMetadataUtils(addableNode.getURI().toString()).copyMetadataFile(addableNode.getURI(), new File(addedNodeUri), null, true);
            ArbilDataNode addedNode = dataNodeLoader.getArbilDataNodeWithoutLoading(addedNodeUri);
            new ArbilComponentBuilder().removeArchiveHandles(addedNode);
            if (destinationNode == null) {
                treeHelper.addLocation(addedNodeUri);
                treeHelper.applyRootLocations();
            } else {
                destinationNode.metadataUtils.addCorpusLink(destinationNode.getURI(), new URI[]{addedNodeUri});
            }
            addedNode.loadArbilDom();
            addedNode.scrollToRequested = true;
        } else {
            if (destinationNode == null) {
                BugCatcherManager.getBugCatcher().logError(new Exception("Attempt to add child node to local corpus root"));
                return;
            }
            addedNodeUri = this.arbilComponentBuilder.insertFavouriteComponent(destinationNode, addableNode);
            new ArbilComponentBuilder().removeArchiveHandles(destinationNode);
        }
        if (destinationNode != null) {
            destinationNode.getParentDomNode().loadArbilDom();
        }
        String newTableTitleString = "new " + addableNode + (destinationNode == null ? "" : " in " + destinationNode);
        windowManager.openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArbilDataNode processAddNodes(ArbilDataNode currentArbilNode, String nodeType, String targetXmlPath, String nodeTypeDisplayName, String favouriteUrlString, String mimeType, URI resourceUri) throws ArbilMetadataException {
        String newTableTitleString = "new " + nodeTypeDisplayName;
        if (currentArbilNode.isMetaDataNode() && currentArbilNode.getFile().exists()) {
            newTableTitleString = newTableTitleString + " in " + currentArbilNode.toString();
        }
        System.out.println("addQueue:-\nnodeType: " + nodeType + "\ntargetXmlPath: " + targetXmlPath + "\nnodeTypeDisplayName: " + nodeTypeDisplayName + "\nfavouriteUrlString: " + favouriteUrlString + "\nresourceUrl: " + resourceUri + "\nmimeType: " + mimeType);
        URI addedNodeUri = this.addChildNode(currentArbilNode, nodeType, targetXmlPath, resourceUri, mimeType);
        ArbilDataNode addedArbilNode = dataNodeLoader.getArbilDataNodeWithoutLoading(addedNodeUri);
        if (addedArbilNode != null) {
            addedArbilNode.getParentDomNode().updateLoadingState(1);
            ArbilNode destinationNode = currentArbilNode.getParentDomNode();
            try {
                addedArbilNode.scrollToRequested = true;
                if (currentArbilNode.getFile().exists()) {
                    currentArbilNode.getParentDomNode().loadArbilDom();
                } else {
                    destinationNode = this.getLocalCorpusRootNode(destinationNode);
                }
                if (currentArbilNode.getParentDomNode() != addedArbilNode.getParentDomNode()) {
                    addedArbilNode.getParentDomNode().loadArbilDom();
                }
            }
            finally {
                addedArbilNode.getParentDomNode().updateLoadingState(-1);
            }
        }
        windowManager.openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
        return addedArbilNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URI addChildNode(ArbilDataNode destinationNode, String nodeType, String targetXmlPath, URI resourceUri, String mimeType) throws ArbilMetadataException {
        System.out.println("addChildNode:: " + nodeType + " : " + resourceUri);
        System.out.println("targetXmlPath:: " + targetXmlPath);
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        URI addedNodePath = null;
        destinationNode.updateLoadingState(1);
        try {
            Object object = destinationNode.getParentDomLockObject();
            synchronized (object) {
                if (destinationNode.getNeedsSaveToDisk(false)) {
                    destinationNode.saveChangesToCache(false);
                }
                if (nodeType.startsWith(".") && destinationNode.isCmdiMetaDataNode()) {
                    addedNodePath = this.arbilComponentBuilder.insertChildComponent(destinationNode, targetXmlPath, nodeType);
                    return addedNodePath;
                }
                if (destinationNode.getNodeTemplate().isArbilChildNode(nodeType) || resourceUri != null && destinationNode.isSession()) {
                    System.out.println("adding to current node");
                    try {
                        Document nodDom = ArbilComponentBuilder.getDocument(destinationNode.getURI());
                        if (nodDom == null) {
                            messageDialogHandler.addMessageDialogToQueue("The metadata file could not be opened", "Add Node");
                            return addedNodePath;
                        }
                        addedNodePath = MetadataReader.getSingleInstance().insertFromTemplate(destinationNode.getNodeTemplate(), destinationNode.getURI(), destinationNode.getSubDirectory(), nodeType, targetXmlPath, nodDom, resourceUri, mimeType);
                        destinationNode.bumpHistory();
                        ArbilComponentBuilder.savePrettyFormatting(nodDom, destinationNode.getFile());
                        dataNodeLoader.requestReload(destinationNode);
                        return addedNodePath;
                    }
                    catch (ParserConfigurationException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                        return addedNodePath;
                    }
                    catch (SAXException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                        return addedNodePath;
                    }
                    catch (IOException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                    return addedNodePath;
                }
                System.out.println("adding new node");
                URI targetFileURI = sessionStorage.getNewArbilFileName(destinationNode.getSubDirectory(), nodeType);
                if (CmdiProfileReader.pathIsProfile(nodeType)) {
                    try {
                        addedNodePath = this.arbilComponentBuilder.createComponentFile(targetFileURI, new URI(nodeType), false);
                    }
                    catch (URISyntaxException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                        URI uRI = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 6, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var7_7
                        destinationNode.updateLoadingState(-1);
                        return uRI;
                    }
                } else {
                    addedNodePath = MetadataReader.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
                }
                if (destinationNode.getFile().exists()) {
                    destinationNode.metadataUtils.addCorpusLink(destinationNode.getURI(), new URI[]{addedNodePath});
                    destinationNode.getParentDomNode().loadArbilDom();
                    return addedNodePath;
                } else {
                    treeHelper.addLocation(addedNodePath);
                    treeHelper.applyRootLocations();
                }
                return addedNodePath;
            }
        }
        finally {
            destinationNode.updateLoadingState(-1);
        }
    }

    private ArbilNode getLocalCorpusRootNode(ArbilNode destinationNode) {
        Object userObject;
        Object localTreeRoot = treeHelper.getLocalCorpusTreeModel().getRoot();
        if (localTreeRoot instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)localTreeRoot).getUserObject()) instanceof ArbilRootNode) {
            destinationNode = (ArbilRootNode)userObject;
        }
        return destinationNode;
    }
}

