/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeCellRenderer;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilTreeRenderer;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTree;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class EgoSelectionPanel
extends JPanel
implements ActionListener {
    private KinTree egoTree;
    private ContainerNode egoNode;
    private KinTree requiredTree;
    private ContainerNode requiredNode;
    private KinTree impliedTree;
    private ContainerNode impliedNode;
    private KinTree transientTree;
    private ContainerNode transientNode;
    JPanel labelPanel3;
    JPanel metadataNodePanel;
    JPanel transientNodePanel;
    private MessageDialogHandler dialogHandler;
    private EntityCollection entityCollection;
    private ArbilDataNodeLoader dataNodeLoader;

    public EgoSelectionPanel(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.dialogHandler = dialogHandler;
        this.entityCollection = entityCollection;
        this.dataNodeLoader = dataNodeLoader;
        this.transientNodePanel = new JPanel(new BorderLayout());
        this.transientNodePanel.setBorder(BorderFactory.createTitledBorder("Transient Entities"));
        JButton convertTransientButton = new JButton("Convert to Database Diagram");
        convertTransientButton.setActionCommand("convert");
        convertTransientButton.addActionListener(this);
        convertTransientButton.setEnabled(false);
        this.transientNodePanel.add((Component)convertTransientButton, "Last");
        this.transientNode = new ContainerNode("transient", null, new ArbilNode[0]);
        this.transientTree = new KinTree(kinDiagramPanel, graphPanel, this.transientNode);
        this.transientTree.setBackground(this.transientNodePanel.getBackground());
        this.transientNodePanel.add((Component)((Object)this.transientTree), "Center");
        this.metadataNodePanel = new JPanel(new BorderLayout());
        this.egoNode = new ContainerNode("ego", null, new ArbilNode[0]);
        this.egoTree = new KinTree(kinDiagramPanel, graphPanel, this.egoNode);
        this.egoTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.requiredNode = new ContainerNode("required", null, new ArbilNode[0]);
        this.requiredTree = new KinTree(kinDiagramPanel, graphPanel, this.requiredNode);
        this.requiredTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.impliedNode = new ContainerNode("implied", null, new ArbilNode[0]);
        this.impliedTree = new KinTree(kinDiagramPanel, graphPanel, this.impliedNode);
        this.impliedTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.setLayout(new BorderLayout());
        JPanel treePanel2 = new JPanel(new BorderLayout());
        JScrollPane metadataNodeScrolPane = new JScrollPane(this.metadataNodePanel);
        JPanel labelPanel1 = new JPanel(new BorderLayout());
        JPanel labelPanel2 = new JPanel(new BorderLayout());
        this.labelPanel3 = new JPanel(new BorderLayout());
        labelPanel1.setBorder(BorderFactory.createTitledBorder("Ego"));
        labelPanel2.setBorder(BorderFactory.createTitledBorder("Required"));
        this.labelPanel3.setBorder(BorderFactory.createTitledBorder("Implied"));
        labelPanel1.add((Component)((Object)this.egoTree), "Center");
        labelPanel2.add((Component)((Object)this.requiredTree), "Center");
        this.labelPanel3.add((Component)((Object)this.impliedTree), "Center");
        this.egoTree.setBackground(labelPanel1.getBackground());
        this.requiredTree.setBackground(labelPanel1.getBackground());
        this.impliedTree.setBackground(labelPanel1.getBackground());
        this.metadataNodePanel.add((Component)labelPanel1, "First");
        this.metadataNodePanel.add((Component)treePanel2, "Center");
        treePanel2.add((Component)labelPanel2, "First");
        treePanel2.add((Component)this.labelPanel3, "Center");
        this.add((Component)metadataNodeScrolPane, "Center");
        this.add((Component)metadataNodeScrolPane, "Center");
    }

    public void setTransferHandler(KinDragTransferHandler dragTransferHandler) {
        for (KinTree currentTree : new KinTree[]{this.egoTree, this.requiredTree, this.impliedTree, this.transientTree}) {
            currentTree.setTransferHandler(dragTransferHandler);
            currentTree.setDragEnabled(true);
        }
    }

    public void setTreeNodes(GraphPanel graphPanel) {
        HashSet<UniqueIdentifier> egoIdentifiers = graphPanel.dataStoreSvg.egoEntities;
        HashSet<UniqueIdentifier> requiredEntityIdentifiers = graphPanel.dataStoreSvg.requiredEntities;
        EntityData[] allEntities = graphPanel.dataStoreSvg.graphData != null ? graphPanel.dataStoreSvg.graphData.getDataNodes() : new EntityData[]{};
        IndexerParameters indexerParameters = graphPanel.getIndexParameters();
        HashSet<KinTreeNode> egoNodeArray = new HashSet<KinTreeNode>();
        HashSet<KinTreeNode> requiredNodeArray = new HashSet<KinTreeNode>();
        HashSet<KinTreeNode> remainingNodeArray = new HashSet<KinTreeNode>();
        HashSet<KinTreeNode> transientNodeArray = new HashSet<KinTreeNode>();
        for (EntityData entityData : allEntities) {
            if (!entityData.isVisible) continue;
            KinTreeNode kinTreeNode = new KinTreeNode(entityData.getUniqueIdentifier(), entityData, indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader);
            if (entityData.getUniqueIdentifier().isTransientIdentifier()) {
                transientNodeArray.add(kinTreeNode);
                continue;
            }
            if (entityData.isEgo || egoIdentifiers.contains(entityData.getUniqueIdentifier())) {
                egoNodeArray.add(kinTreeNode);
                continue;
            }
            if (requiredEntityIdentifiers.contains(entityData.getUniqueIdentifier())) {
                requiredNodeArray.add(kinTreeNode);
                continue;
            }
            remainingNodeArray.add(kinTreeNode);
        }
        System.out.println("egoNodeArray: " + egoNodeArray.size());
        System.out.println("requiredNodeArray: " + requiredNodeArray.size());
        System.out.println("remainingNodeArray: " + remainingNodeArray.size());
        System.out.println("transientNodeArray: " + transientNodeArray.size());
        this.egoNode.setChildNodes(egoNodeArray.toArray(new ArbilNode[0]));
        this.requiredNode.setChildNodes(requiredNodeArray.toArray(new ArbilNode[0]));
        this.impliedNode.setChildNodes(remainingNodeArray.toArray(new ArbilNode[0]));
        this.transientNode.setChildNodes(transientNodeArray.toArray(new ArbilNode[0]));
        this.egoTree.requestResort();
        this.requiredTree.requestResort();
        this.impliedTree.requestResort();
        this.transientTree.requestResort();
        if (!transientNodeArray.isEmpty()) {
            this.metadataNodePanel.removeAll();
            this.metadataNodePanel.add((Component)new JScrollPane(this.transientNodePanel), "Center");
            this.revalidate();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("convert".equals(e.getActionCommand())) {
            throw new UnsupportedOperationException("Ticket #1114 Button to convert freeform diagram to metadata diagram");
        }
    }
}

