/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.entityprofiles;

import javax.swing.table.AbstractTableModel;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.kinnate.kindocument.ProfileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Name", "Description", "Registration Date", "Creator Name", "Use Entity Type"};
    private ProfileManager profileManager;

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.profileManager == null) {
            return 0;
        }
        return this.profileManager.getProfileCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            CmdiProfileReader.CmdiProfile selectedProfile = this.profileManager.getProfileAt(rowIndex);
            if (aValue.equals(true)) {
                this.profileManager.addProfileSelection(selectedProfile.id, selectedProfile.name);
            } else {
                this.profileManager.removeProfileSelection(selectedProfile.id);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CmdiProfileReader.CmdiProfile selectedProfile = this.profileManager.getProfileAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return selectedProfile.name;
            }
            case 1: {
                return selectedProfile.description;
            }
            case 2: {
                return selectedProfile.registrationDate.substring(0, 10);
            }
            case 3: {
                return selectedProfile.creatorName;
            }
            case 4: {
                return this.profileManager.profileIsSelected(selectedProfile.id);
            }
        }
        return "";
    }
}

