/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import nl.mpi.arbil.ui.fieldeditors.ControlledVocabularyComboBoxEditor;

public abstract class TypeAheadComboBoxEditor
implements ComboBoxEditor,
Serializable {
    private int previousMatch = -1;
    private final KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (TypeAheadComboBoxEditor.this.isItemsDeletable() && TypeAheadComboBoxEditor.this.comboBox.isPopupVisible() && 64 == (e.getModifiersEx() & 0x40) && e.getKeyCode() == 127) {
                TypeAheadComboBoxEditor.this.deleteItem(TypeAheadComboBoxEditor.this.getItem());
            } else if (!TypeAheadComboBoxEditor.this.comboBox.isPopupVisible()) {
                TypeAheadComboBoxEditor.this.comboBox.setPopupVisible(true);
            } else if (e.getKeyCode() == 10 || TypeAheadComboBoxEditor.this.isList() && e.getKeyChar() == ControlledVocabularyComboBoxEditor.SEPARATOR()) {
                TypeAheadComboBoxEditor.this.handleAutocompleteKey(e);
            } else if (e.getKeyCode() == 27) {
                TypeAheadComboBoxEditor.this.getTextField().setText(TypeAheadComboBoxEditor.this.originalValue);
            } else if (e.isActionKey()) {
                TypeAheadComboBoxEditor.this.handleNavigateComboKey(e);
            } else {
                TypeAheadComboBoxEditor.this.handleTextEntryKey(e);
            }
        }
    };
    private final FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            TypeAheadComboBoxEditor.this.startTypeaheadTimer(ControlledVocabularyComboBoxEditor.TYPEAHEAD_DELAY_SHORT());
        }

        public void focusLost(FocusEvent e) {
        }
    };
    private JComboBox comboBox;
    private Timer typeaheadTimer;
    private String originalValue;
    private JTextField editor;
    private boolean typingAhead = false;
    private static final char SEPARATOR = ',';
    private static final int TYPEAHEAD_DELAY_SHORT = 200;
    private static final int TYPEAHEAD_DELAY_LONG = 1000;

    protected abstract String getItemAt(int var1);

    protected abstract int getItemsCount();

    protected abstract boolean isList();

    protected abstract boolean isOpen();

    protected boolean isItemsDeletable() {
        return false;
    }

    protected boolean deleteItem(Object item) {
        return false;
    }

    protected TypeAheadComboBoxEditor(JTextField editor, String initialValue, String originalValue, JComboBox comboBox) {
        this.editor = editor;
        if (comboBox != null) {
            this.setComboBox(comboBox);
            comboBox.setSelectedItem(initialValue);
        }
        this.originalValue = originalValue;
    }

    protected final void init() {
        this.getTextField().addKeyListener(this.keyListener);
        this.getTextField().addFocusListener(this.focusListener);
        this.initTypeaheadTimer();
    }

    public void addActionListener(ActionListener l) {
        this.getTextField().addActionListener(l);
    }

    public String getCurrentValue() {
        return this.getCurrentValueString();
    }

    public Component getEditorComponent() {
        return this.getTextField();
    }

    public Object getItem() {
        return this.getTextField().getText();
    }

    public JTextField getTextField() {
        return this.editor;
    }

    public void removeActionListener(ActionListener l) {
        this.getTextField().removeActionListener(l);
    }

    public void selectAll() {
        this.getTextField().selectAll();
    }

    public final void setComboBox(JComboBox comboBox) {
        this.comboBox = comboBox;
        comboBox.setEditable(true);
    }

    public void setItem(Object item) {
        if (!this.typingAhead) {
            String itemString = item.toString();
            if (this.isList() && itemString.indexOf(ControlledVocabularyComboBoxEditor.SEPARATOR()) >= 0) {
                this.getTextField().setText(itemString);
            } else {
                this.setEditorValue(itemString);
            }
        }
    }

    private void handleTextEntryKey(KeyEvent e) {
        if (!this.typingAhead) {
            if (!e.isActionKey() && e.getKeyChar() != '\uffff' && e.getKeyCode() != 8 && e.getKeyCode() != 127) {
                this.startTypeaheadTimer(TypeAheadComboBoxEditor.TYPEAHEAD_DELAY_SHORT());
            } else if (!(this.isOpen() || e.getKeyCode() != 8 && e.getKeyCode() != 127)) {
                this.startTypeaheadTimer(TypeAheadComboBoxEditor.TYPEAHEAD_DELAY_LONG());
            }
        }
    }

    private void handleNavigateComboKey(KeyEvent e) {
        if (e.getModifiers() == 0) {
            if (e.getKeyCode() == 40) {
                this.moveSelectedIndex(1);
                e.consume();
            } else if (e.getKeyCode() == 38) {
                this.moveSelectedIndex(-1);
                e.consume();
            } else if (e.getKeyCode() == 34) {
                this.moveSelectedIndex(5);
                e.consume();
            } else if (e.getKeyCode() == 33) {
                this.moveSelectedIndex(-5);
                e.consume();
            }
        }
    }

    private synchronized void handleAutocompleteKey(KeyEvent e) {
        this.typingAhead = true;
        if (this.typeaheadTimer.isRunning()) {
            this.typeaheadTimer.stop();
        }
        if (this.autoComplete()) {
            e.consume();
        }
        this.typingAhead = false;
    }

    private synchronized void typeAhead() {
        this.typingAhead = true;
        String currentEditorValue = this.getEditorValue();
        int matchIndex = this.getMatchingItem(currentEditorValue);
        if (matchIndex >= 0) {
            String match = this.getItemAt(matchIndex);
            if (this.comboBox != null) {
                this.comboBox.setSelectedItem(match);
            }
            int position = this.getTextField().getCaretPosition();
            this.setEditorValue(match);
            this.getTextField().setCaretPosition(position);
            this.getTextField().setSelectionStart(position);
            this.getTextField().setSelectionEnd(position + match.length() - currentEditorValue.length());
        }
        this.typingAhead = false;
    }

    private boolean autoComplete() {
        if (this.getTextField().getSelectionEnd() > this.getTextField().getSelectionStart()) {
            this.getTextField().setCaretPosition(this.getTextField().getSelectionEnd());
            return true;
        }
        return false;
    }

    private int getMatchingItem(String text) {
        if (null != text && text.length() > 0) {
            int itemsCount = this.getItemsCount();
            if (this.previousMatch >= 0 && this.previousMatch < itemsCount && this.getItemAt(this.previousMatch).equalsIgnoreCase(text)) {
                return this.previousMatch;
            }
            int shortestMatch = -1;
            for (int i = 0; i < itemsCount; ++i) {
                String item = this.getItemAt(i);
                if (item == null || shortestMatch >= 0 && item.length() >= shortestMatch || !item.regionMatches(true, 0, text, 0, text.length())) continue;
                this.previousMatch = i;
                shortestMatch = item.length();
            }
            if (shortestMatch >= 0) {
                return this.previousMatch;
            }
        }
        return -1;
    }

    private String getCurrentValueString() {
        if (!this.isList()) {
            return this.getTextField().getText();
        }
        StringTokenizer st = new StringTokenizer(this.getTextField().getText(), Character.toString(TypeAheadComboBoxEditor.SEPARATOR()));
        StringBuilder sb = new StringBuilder(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            sb.append(token);
            if (!st.hasMoreTokens()) continue;
            sb.append(TypeAheadComboBoxEditor.SEPARATOR());
        }
        return sb.toString();
    }

    private String getEditorValue() {
        String value = this.getTextField().getText();
        int lastIndex = value.length();
        String separator = Character.toString(TypeAheadComboBoxEditor.SEPARATOR());
        if (!this.isList() || !value.contains(separator)) {
            return value;
        }
        int[] startEnd = this.getEditorCurrentStartEnd();
        return value.substring(Math.min(startEnd[0], lastIndex), Math.min(startEnd[1], lastIndex));
    }

    private void setEditorValue(String value) {
        int[] startEnd = this.getEditorCurrentStartEnd();
        String text = this.getTextField().getText();
        this.getTextField().setText(text.substring(0, startEnd[0]).concat(value).concat(text.substring(startEnd[1])));
        this.getTextField().setCaretPosition(startEnd[0] + value.length());
    }

    private int[] getEditorCurrentStartEnd() {
        int end;
        String value = this.getTextField().getText();
        if (!this.isList()) {
            return new int[]{0, value.length()};
        }
        int lastIndex = value.length();
        String separator = Character.toString(TypeAheadComboBoxEditor.SEPARATOR());
        int currentIndex = this.getEditorIndex();
        int start = 0;
        if (currentIndex > 0) {
            int current = 0;
            do {
                start = value.indexOf(separator, Math.min(start, lastIndex)) + 1;
            } while (++current < currentIndex);
        }
        if ((end = value.indexOf(separator, Math.min(start, lastIndex))) <= 0) {
            end = lastIndex;
        }
        return new int[]{start, end};
    }

    private int getEditorIndex() {
        String value = this.getTextField().getText();
        int position = this.getTextField().getCaretPosition();
        int index = 0;
        for (int i = 0; i < position; ++i) {
            if (value.charAt(i) != TypeAheadComboBoxEditor.SEPARATOR()) continue;
            ++index;
        }
        return index;
    }

    private void moveSelectedIndex(int delta) {
        int target = this.comboBox.getSelectedIndex() + delta;
        target = Math.max(target, 0);
        if ((target = Math.min(target, this.comboBox.getItemCount() - 1)) >= 0 && target != this.comboBox.getSelectedIndex()) {
            if (this.isList() && this.comboBox.getItemAt(target).toString().indexOf(TypeAheadComboBoxEditor.SEPARATOR()) >= 0) {
                target = Math.min(target + 1, this.comboBox.getItemCount() - 1);
            }
            this.comboBox.setSelectedIndex(target);
        }
    }

    private void startTypeaheadTimer(int delay) {
        if (this.typeaheadTimer.isRunning()) {
            this.typeaheadTimer.stop();
        }
        this.typeaheadTimer.setInitialDelay(delay);
        this.typeaheadTimer.start();
    }

    private void initTypeaheadTimer() {
        this.typeaheadTimer = new Timer(TypeAheadComboBoxEditor.TYPEAHEAD_DELAY_SHORT(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!TypeAheadComboBoxEditor.this.typingAhead) {
                    TypeAheadComboBoxEditor.this.typeaheadTimer.stop();
                    TypeAheadComboBoxEditor.this.typeAhead();
                }
            }
        });
        this.typeaheadTimer.setRepeats(false);
    }

    protected static char SEPARATOR() {
        return ',';
    }

    protected static int TYPEAHEAD_DELAY_SHORT() {
        return 200;
    }

    protected static int TYPEAHEAD_DELAY_LONG() {
        return 1000;
    }
}

