/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import net.handle.util.StreamTable;

public class ServerLog
implements Runnable {
    public static final int ACCESS_LOG_BUFFER_SIZE = 100000;
    public static final int ERRLOG_LEVEL_EVERYTHING = 0;
    public static final int ERRLOG_LEVEL_INFO = 25;
    public static final int ERRLOG_LEVEL_NORMAL = 50;
    public static final int ERRLOG_LEVEL_REALBAD = 75;
    public static final int ERRLOG_LEVEL_FATAL = 100;
    private int errorLoggingLevel = 25;
    private static StreamTable calendarDays = new StreamTable();
    private File logDirectory = null;
    private Writer accessWriter = null;
    private Writer errorWriter = null;
    private DateFormat errorLogDateFormat = null;
    private boolean continuing = true;
    private boolean loggingAccesses = false;
    private final String ERROR_LOG_LOCK = "error_log_lock";
    private final String ACCESS_LOG_LOCK = "access_log_lock";
    private Thread flusherThread = null;
    private Thread rotaterThread = null;

    public ServerLog(File logDir, StreamTable config) throws Exception {
        this.logDirectory = logDir;
        this.errorLogDateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss z");
        if (this.logDirectory != null) {
            this.loadConfig(config);
            this.logError(25, "Started new run.");
            this.flusherThread = new Thread(this);
            this.flusherThread.setDaemon(true);
            this.flusherThread.start();
        }
    }

    private void loadConfig(StreamTable config) throws Exception {
        Hashtable conf;
        String[] protocolConfig = new String[]{"hdl_udp_config", "hdl_tcp_config", "hdl_http_config"};
        for (int i = 0; !(i >= protocolConfig.length || config.containsKey(protocolConfig[i]) && (this.loggingAccesses = (conf = (Hashtable)config.get(protocolConfig[i])).containsKey("log_accesses") && conf.get("log_accesses").equals("yes"))); ++i) {
        }
        LogRotater logRotater = null;
        conf = (StreamTable)config.get("log_save_config");
        if (conf == null) {
            conf = new StreamTable();
        }
        String saveLogInterval = ((StreamTable)conf).getStr("log_save_interval", "Never");
        this.logDirectory = new File(((StreamTable)conf).getStr("log_save_directory", this.logDirectory.getAbsolutePath()));
        if (saveLogInterval.equalsIgnoreCase("Weekly")) {
            String saveLogWeekdayStr = ((StreamTable)conf).getStr("log_save_weekday", "");
            int saveLogWeekday = calendarDays.getInt(saveLogWeekdayStr, 1);
            logRotater = new WeeklyRotater(saveLogWeekday);
        } else if (saveLogInterval.equalsIgnoreCase("Daily")) {
            logRotater = new DailyRotater();
        } else if (saveLogInterval.equalsIgnoreCase("Monthly")) {
            logRotater = new MonthlyRotater();
        } else if (saveLogInterval.equalsIgnoreCase("Never")) {
            logRotater = new DefaultRotater();
        } else {
            throw new Exception("Invalid log rotation interval: \"" + saveLogInterval + "\" for " + "log_save_interval" + " setting in config file");
        }
        if (this.logDirectory.exists()) {
            if (!this.logDirectory.isDirectory()) {
                throw new Exception("\"" + this.logDirectory.getAbsolutePath() + "\" is not a directory.");
            }
        } else {
            this.logDirectory.mkdirs();
        }
        logRotater.init();
        Thread rotaterThread = new Thread(logRotater);
        rotaterThread.setPriority(1);
        rotaterThread.setDaemon(true);
        rotaterThread.start();
        while (!logRotater.initialized()) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {}
        }
    }

    public void setErrorLogLevel(int newLogLevel) {
        this.errorLoggingLevel = newLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logAccess(String accessType, InetAddress clientAddr, int opCode, int rsCode, String logString, long time) {
        if (logString == null) return;
        String msg = (clientAddr == null ? "" : clientAddr.getHostAddress()) + " " + accessType + " \"" + new Date() + "\" " + opCode + " " + rsCode + " " + time + "ms " + logString;
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter == null) {
                System.err.println(msg);
            } else {
                try {
                    this.accessWriter.write(msg + "\n");
                }
                catch (Exception e) {
                    System.err.println("Error writing to access log: (" + e + "): " + logString);
                }
            }
            // ** MonitorExit[var9_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logError(int level, String logString) {
        if (level < this.errorLoggingLevel || logString == null) {
            return;
        }
        String msg = "\"" + this.errorLogDateFormat.format(new Date()) + "\" " + level + ' ' + logString;
        if (level == 100 || this.errorWriter == null) {
            System.err.println(msg);
        }
        if (this.errorWriter == null) return;
        String string = "error_log_lock";
        synchronized ("error_log_lock") {
            try {
                this.errorWriter.write(msg + '\n');
                this.errorWriter.flush();
            }
            catch (Throwable e) {
                System.err.println("Error (" + e + ") writing \"" + logString + "\" to error log.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccessLogFile(File newAccessLogFile) throws IOException {
        String string = "access_log_lock";
        synchronized ("access_log_lock") {
            if (this.accessWriter != null) {
                this.accessWriter.flush();
                this.accessWriter.close();
                this.accessWriter = null;
            }
            if (this.loggingAccesses) {
                this.accessWriter = new BufferedWriter(new FileWriter(newAccessLogFile.getAbsolutePath(), true), 100000);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorLogFile(File newErrorLogFile) throws IOException {
        String string = "error_log_lock";
        synchronized ("error_log_lock") {
            Writer oldWriter = null;
            try {
                oldWriter = this.errorWriter;
                this.errorWriter = null;
                FileOutputStream errf = new FileOutputStream(newErrorLogFile.getAbsolutePath(), true);
                System.setErr(new PrintStream(errf));
                this.errorWriter = new OutputStreamWriter(errf);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (oldWriter != null) {
                        oldWriter.close();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (oldWriter != null) {
                    oldWriter.close();
                }
            }
            catch (Throwable t) {}
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (this.continuing) {
            try {
                String string = "access_log_lock";
                // MONITORENTER : "access_log_lock"
                if (this.accessWriter != null) {
                    this.accessWriter.flush();
                }
                // MONITOREXIT : string
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.currentThread();
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        this.continuing = false;
        if (this.flusherThread != null) {
            String string = "access_log_lock";
            // MONITORENTER : "access_log_lock"
            try {
                this.flusherThread.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.rotaterThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.accessWriter != null) {
            try {
                this.accessWriter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.errorWriter == null) return;
        try {
            this.errorWriter.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        calendarDays.put("Sunday", String.valueOf(1));
        calendarDays.put("Monday", String.valueOf(2));
        calendarDays.put("Tuesday", String.valueOf(3));
        calendarDays.put("Wednesday", String.valueOf(4));
        calendarDays.put("Thursday", String.valueOf(5));
        calendarDays.put("Friday", String.valueOf(6));
        calendarDays.put("Saturday", String.valueOf(7));
    }

    class DefaultRotater
    extends LogRotater {
        protected Calendar cal = Calendar.getInstance();

        DefaultRotater() {
        }

        public long getNextRotationTime(long currentTime) {
            return Long.MAX_VALUE;
        }

        public String getLogFileSuffix(long currentTime) {
            return "";
        }
    }

    class DailyRotater
    extends LogRotater {
        protected Calendar cal = Calendar.getInstance();

        DailyRotater() {
        }

        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            this.cal.add(5, 1);
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.cal.getTime().getTime();
        }

        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.getSuffixForDate(this.cal);
        }
    }

    class MonthlyRotater
    extends LogRotater {
        protected Calendar cal = Calendar.getInstance();

        MonthlyRotater() {
        }

        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(5) != 1) {
                this.cal.add(5, 1);
            }
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.cal.getTime().getTime();
        }

        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(5) != 1) {
                this.cal.add(5, -1);
            }
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return "-" + String.valueOf(this.cal.get(1) * 100 + (this.cal.get(2) + 1));
        }
    }

    class WeeklyRotater
    extends LogRotater {
        protected Calendar cal = Calendar.getInstance();
        private int dayOfRotation;

        WeeklyRotater(int dayOfRotation) {
            this.dayOfRotation = dayOfRotation;
        }

        public long getNextRotationTime(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(7) != this.dayOfRotation) {
                this.cal.add(5, 1);
            }
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.cal.getTime().getTime();
        }

        public String getLogFileSuffix(long currentTime) {
            this.cal.setTime(new Date(currentTime));
            while (this.cal.get(7) != this.dayOfRotation) {
                this.cal.add(5, -1);
            }
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 1);
            return this.getSuffixForDate(this.cal);
        }
    }

    private abstract class LogRotater
    implements Runnable {
        private boolean isInitialized = false;

        private LogRotater() {
        }

        public void init() {
        }

        public abstract long getNextRotationTime(long var1);

        public abstract String getLogFileSuffix(long var1);

        public boolean initialized() {
            return this.isInitialized;
        }

        public void run() {
            while (ServerLog.this.continuing) {
                long now = System.currentTimeMillis();
                try {
                    String logFileSuffix = this.getLogFileSuffix(now);
                    ServerLog.this.setAccessLogFile(new File(ServerLog.this.logDirectory, "access.log" + logFileSuffix));
                    ServerLog.this.setErrorLogFile(new File(ServerLog.this.logDirectory, "error.log" + logFileSuffix));
                }
                catch (Throwable t) {
                    System.err.println("Error setting log files: " + t);
                    t.printStackTrace(System.err);
                }
                this.isInitialized = true;
                long nextRotationTime = this.getNextRotationTime(now);
                while (nextRotationTime > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(Math.max(0L, nextRotationTime - System.currentTimeMillis()));
                    }
                    catch (Throwable t) {}
                }
            }
        }

        protected String getSuffixForDate(Calendar cal) {
            return "-" + String.valueOf(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
        }
    }
}

