/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.User;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Replace;
import org.basex.io.in.BufferInput;
import org.basex.io.in.WrapInputStream;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryException;
import org.basex.server.Log;
import org.basex.server.QueryListener;
import org.basex.server.ServerCmd;
import org.basex.server.Sessions;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class ClientListener
extends Thread {
    private final HashMap<String, QueryListener> queries = new HashMap();
    private final Context context;
    private final Socket socket;
    private final Log log;
    private Socket esocket;
    private PrintOutput eout;
    private StringList events;
    private BufferInput in;
    private PrintOutput out;
    private Command command;
    private int id;
    private boolean running;

    public ClientListener(Socket s, Context c, Log l) {
        this.context = new Context(c, this);
        this.socket = s;
        this.log = l;
    }

    public boolean init() {
        try {
            String ts = Long.toString(System.nanoTime());
            this.out = PrintOutput.get(this.socket.getOutputStream());
            this.out.print(ts);
            this.send(true);
            this.in = new BufferInput(this.socket.getInputStream());
            String us = this.in.readString();
            String pw = this.in.readString();
            this.context.user = this.context.users.get(us);
            boolean bl = this.running = this.context.user != null && Token.md5(String.valueOf(Token.string(this.context.user.password)) + ts).equals(pw);
            if (this.running) {
                this.log.write(this, "LOGIN " + this.context.user.name, "OK");
                this.send(true);
                this.start();
            } else if (!us.isEmpty()) {
                this.log.write(this, String.valueOf(Text.SERVERDENIED) + ": " + us);
            }
            return this.running;
        }
        catch (IOException ex) {
            Util.stack(ex);
            this.log.write(ex.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ServerCmd sc = null;
        Object cmd = null;
        try {
            while (this.running) {
                String info;
                boolean ok;
                Performance perf;
                block18: {
                    block17: {
                        try {
                            byte b = this.in.readByte();
                            sc = ServerCmd.get(b);
                            cmd = null;
                            if (sc == ServerCmd.CREATE) {
                                this.create();
                                break block17;
                            }
                            if (sc == ServerCmd.ADD) {
                                this.add();
                                break block17;
                            }
                            if (sc == ServerCmd.WATCH) {
                                this.watch();
                                break block17;
                            }
                            if (sc == ServerCmd.UNWATCH) {
                                this.unwatch();
                                break block17;
                            }
                            if (sc == ServerCmd.REPLACE) {
                                this.replace();
                                break block17;
                            }
                            if (sc != ServerCmd.COMMAND) {
                                this.query(sc);
                            } else {
                                cmd = new ByteList().add(b).add(this.in.token().toArray()).toString();
                            }
                        }
                        catch (IOException ex) {
                            this.exit();
                            break;
                        }
                    }
                    if (sc != ServerCmd.COMMAND) continue;
                    perf = new Performance();
                    this.command = null;
                    try {
                        this.command = new CommandParser((String)cmd, this.context).parseSingle();
                    }
                    catch (QueryException ex) {
                        String msg = ex.getMessage();
                        this.log.write(this, cmd, String.valueOf(Text.INFOERROR) + msg);
                        this.out.write(0);
                        this.out.writeString(msg);
                        this.send(false);
                        continue;
                    }
                    if (this.command instanceof Exit) {
                        this.exit();
                        this.running = false;
                        break;
                    }
                    this.command.startTimeout(this.context.mprop.num(MainProp.TIMEOUT));
                    this.log.write(this, this.command.toString().replace('\r', ' ').replace('\n', ' '));
                    ok = true;
                    info = null;
                    try {
                        this.command.execute(this.context, this.out);
                        info = this.command.info();
                    }
                    catch (BaseXException ex) {
                        ok = false;
                        info = ex.getMessage();
                        if (!info.startsWith("Interrupted.")) break block18;
                        info = Text.SERVERTIMEOUT;
                    }
                }
                this.command.stopTimeout();
                this.out.write(0);
                this.info(ok, info, perf);
            }
            if (this.running) return;
            this.log.write(this, "LOGOUT " + this.context.user.name, "OK");
            return;
        }
        catch (IOException ex) {
            this.log.write(this, sc == ServerCmd.COMMAND ? cmd : sc, String.valueOf(Text.INFOERROR) + ex.getMessage());
            Util.stack(ex);
            this.exit();
        }
    }

    public void exit() {
        for (QueryListener q : this.queries.values()) {
            try {
                q.close(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (this.events != null) {
                this.esocket.close();
                for (String e : this.events) {
                    Sessions sess = (Sessions)this.context.events.get(e);
                    if (sess == null) continue;
                    sess.remove(this);
                }
            }
            new Close().execute(this.context);
            if (this.command != null) {
                this.command.stop();
            }
            this.context.delete(this);
            this.socket.close();
        }
        catch (Exception ex) {
            this.log.write(ex.getMessage());
            Util.stack(ex);
        }
    }

    public User user() {
        return this.context.user;
    }

    public synchronized void register(Socket s) throws IOException {
        this.esocket = s;
        this.eout = PrintOutput.get(s.getOutputStream());
    }

    public synchronized void notify(byte[] name, byte[] msg) throws IOException {
        this.eout.print(name);
        this.eout.write(0);
        this.eout.print(msg);
        this.eout.write(0);
        this.eout.flush();
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("[");
        tb.add(this.socket.getInetAddress().getHostAddress());
        tb.add(58).addExt(this.socket.getPort(), new Object[0]).add(93);
        if (this.context.data != null) {
            tb.add(": ").add(this.context.data.meta.name);
        }
        return tb.toString();
    }

    private void info(boolean ok, String info, Performance perf) throws IOException {
        this.log.write(this, ok ? "OK" : String.valueOf(Text.INFOERROR) + info, perf);
        this.out.writeString(info);
        this.send(ok);
    }

    private void create() throws IOException {
        Performance perf = new Performance();
        String name = this.in.readString();
        this.log.write(this, (Object)((Object)ServerCmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.DATABASE) + " " + name + " [...]");
        try {
            WrapInputStream is = new WrapInputStream(this.in);
            String info = is.curr() == -1 ? CreateDB.create(name, Parser.emptyParser(), this.context) : CreateDB.create(name, is, this.context);
            this.info(true, info, perf);
        }
        catch (BaseXException ex) {
            this.info(false, ex.getMessage(), perf);
        }
    }

    private void add() throws IOException {
        Performance perf = new Performance();
        String name = this.in.readString();
        String path = this.in.readString();
        StringBuilder sb = new StringBuilder((Object)((Object)ServerCmd.ADD) + " ");
        if (!name.isEmpty()) {
            sb.append("AS " + name + ' ');
        }
        if (!path.isEmpty()) {
            sb.append("TO " + path + ' ');
        }
        this.log.write(this, sb.append("[...]"));
        try {
            InputSource is = new InputSource(new WrapInputStream(this.in));
            this.info(true, Add.add(name, path, is, this.context, null, true), perf);
        }
        catch (BaseXException ex) {
            this.info(false, ex.getMessage(), perf);
        }
        this.out.flush();
    }

    private void replace() throws IOException {
        Performance perf = new Performance();
        String path = this.in.readString();
        StringBuilder sb = new StringBuilder((Object)((Object)ServerCmd.REPLACE) + " ");
        if (!path.isEmpty()) {
            sb.append("TO " + path + ' ');
        }
        this.log.write(this, sb.append("[...]"));
        try {
            InputSource is = new InputSource(new WrapInputStream(this.in));
            this.info(true, Replace.replace(path, is, this.context, true), perf);
        }
        catch (BaseXException ex) {
            this.info(false, ex.getMessage(), perf);
        }
        this.out.flush();
    }

    private void watch() throws IOException {
        Sessions s;
        Performance perf = new Performance();
        String name = this.in.readString();
        if (this.events == null) {
            this.out.writeString(Integer.toString(this.context.mprop.num(MainProp.EVENTPORT)));
            this.out.writeString(Long.toString(this.getId()));
            this.events = new StringList();
        }
        boolean ok = (s = (Sessions)this.context.events.get(name)) != null && !s.contains(this);
        String message = "";
        if (ok) {
            s.add(this);
            this.events.add(name);
            message = Text.EVENTWAT;
        } else {
            message = s == null ? Text.EVENTNO : Text.EVENTALR;
        }
        this.info(ok, Util.info(message, name), perf);
    }

    private void unwatch() throws IOException {
        Performance perf = new Performance();
        String name = this.in.readString();
        Sessions s = (Sessions)this.context.events.get(name);
        boolean ok = s != null && s.contains(this);
        String message = "";
        if (ok) {
            s.remove(this);
            this.events.delete(name);
            message = Text.EVENTUNWAT;
        } else {
            message = s == null ? Text.EVENTNO : Text.EVENTNOUW;
        }
        this.info(ok, Util.info(message, name), perf);
        this.out.flush();
    }

    private void query(ServerCmd sc) throws IOException {
        String arg = this.in.readString();
        QueryListener qp = null;
        String err = null;
        try {
            if (sc == ServerCmd.QUERY) {
                String query = arg;
                qp = new QueryListener(query, this.out, this.context);
                arg = Integer.toString(this.id++);
                this.queries.put(arg, qp);
                this.out.writeString(arg);
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", query, "OK");
            } else {
                qp = this.queries.get(arg);
                if (qp == null) {
                    if (sc != ServerCmd.CLOSE) {
                        throw new IOException("Unknown Query ID: " + arg);
                    }
                } else if (sc == ServerCmd.BIND) {
                    String key = this.in.readString();
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.bind(key, val, typ);
                    this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", key, val, typ, "OK");
                } else if (sc == ServerCmd.INIT) {
                    qp.init();
                } else if (sc == ServerCmd.NEXT) {
                    qp.next();
                } else if (sc == ServerCmd.EXEC) {
                    qp.execute();
                } else if (sc == ServerCmd.INFO) {
                    qp.printInfo();
                } else if (sc == ServerCmd.CLOSE) {
                    qp.close(false);
                    this.queries.remove(arg);
                }
                this.out.write(0);
            }
            this.out.write(0);
            if (sc != ServerCmd.NEXT && sc != ServerCmd.BIND) {
                this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", "OK");
            }
        }
        catch (Exception ex) {
            err = ex.getMessage();
            this.log.write(this, (Object)((Object)sc) + "(" + arg + ")", String.valueOf(Text.INFOERROR) + err);
            if (qp != null) {
                qp.close(true);
            }
            this.queries.remove(arg);
        }
        if (err != null) {
            this.out.write(0);
            this.out.write(1);
            this.out.writeString(err);
        }
        this.out.flush();
    }

    void send(boolean ok) throws IOException {
        this.out.write(ok ? 0 : 1);
        this.out.flush();
    }
}

