/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.basex.build.BuildException;
import org.basex.build.SingleParser;
import org.basex.build.file.MAB2;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.out.PrintOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.ByteList;

public final class MAB2Parser
extends SingleParser {
    private static final String ENCODING = "iso-8859-1";
    private final ByteList buffer = new ByteList();
    private final TokenMap subjects = new TokenMap();
    private final TokenMap mediatypes = new TokenMap();
    private final TokenMap languages = new TokenMap();
    private final TokenMap mvids = new TokenMap();
    private final TokenMap lendings = new TokenMap();
    private final TokenMap status = new TokenMap();
    private final TokenMap posters = new TokenMap();
    private final TokenMap genres = new TokenMap();
    private final byte[][] sig = new byte[500][];
    private final byte[][] pers = new byte[50][];
    private final byte[][] inst = new byte[50][];
    private final boolean flat;
    private final DataAccess input;
    private byte[] mvID;
    private byte[] bibID;
    private byte[] title;
    private byte[] description;
    private byte[] type;
    private byte[] language;
    private byte[] original;
    private byte[] subtitle;
    private byte[] town;
    private byte[] publisher;
    private byte[] year;
    private byte[] format;
    private byte[] details;
    private byte[] note;
    private byte[] isbn;
    private byte[] subject;
    private int nrSigs;
    private int nrPers;
    private int nrInst;
    private boolean shortTitle;
    private long off;
    private int maxid;
    private static final byte[] CACHE = new byte[16];

    public MAB2Parser(IO source, String target, Prop prop) throws IOException {
        super(source, target);
        ParserProp props = new ParserProp(prop.get(Prop.PARSEROPT));
        this.flat = props.is(ParserProp.FLAT);
        this.input = new DataAccess(new File(source.path()));
    }

    @Override
    public void parse() throws IOException {
        long pos;
        byte[] id;
        this.index(this.mediatypes, "mediatypes");
        this.index(this.subjects, "subjects");
        this.index(this.languages, "lang");
        this.index(this.mvids, "mvids");
        this.index(this.lendings, "lendings");
        this.index(this.status, "status");
        this.index(this.posters, "posters");
        this.index(this.genres, "genres");
        int i = 1;
        while (i <= this.mvids.size()) {
            int id2 = Token.toInt(this.mvids.value(i));
            if (this.maxid < id2) {
                this.maxid = id2;
            }
            ++i;
        }
        if (this.input.read1() != 35 || this.input.read1() != 35 || this.input.read1() != 35) {
            throw new BuildException("Invalid MAB2 input (doesn't start with ###)");
        }
        this.builder.startElem(MAB2.LIBRARY, this.atts.reset());
        Performance p = new Performance();
        TokenObjMap<MAB2Entry> ids = new TokenObjMap<MAB2Entry>();
        int i2 = 0;
        while ((id = this.id(this.input)) != null) {
            pos = this.off;
            byte[] par = this.par(this.input);
            boolean child = par != null;
            byte[] key = child ? par : id;
            MAB2Entry entry = (MAB2Entry)ids.get(key);
            if (entry == null) {
                entry = new MAB2Entry();
                ids.add(key, entry);
            }
            if (child) {
                entry.add(pos);
            } else {
                entry.pos(pos);
            }
            if (!Util.debug) continue;
            if ((++i2 & Short.MAX_VALUE) == 0) {
                Util.err(" " + i2 + "\n", new Object[0]);
                continue;
            }
            if ((i2 & 0xFFF) == 0) {
                Util.err("!", new Object[0]);
                continue;
            }
            if ((i2 & 0x3FF) != 0) continue;
            Util.err(".", new Object[0]);
        }
        if (Util.debug) {
            Util.err("\nParse Offsets (%): %/%\n", ids.size(), p, Performance.getMem());
        }
        i2 = 1;
        while (i2 <= ids.size()) {
            MAB2Entry entry = (MAB2Entry)ids.value(i2);
            pos = entry.pos;
            byte[] l = pos != 0L ? this.addEntry(this.input, pos, entry.size, null) : null;
            int j = 0;
            while (j < entry.size) {
                this.addEntry(this.input, entry.children[j], 0, l);
                ++j;
            }
            if (entry.size != 0 && pos != 0L && !this.flat) {
                this.builder.endElem(MAB2.MEDIUM);
            }
            ++i2;
        }
        if (Util.debug) {
            Util.err("\nCreate Titles: %/%\n", p, Performance.getMem());
        }
        this.builder.endElem(MAB2.LIBRARY);
        PrintOutput out = new PrintOutput("mvids.dat");
        i2 = 1;
        while (i2 <= this.mvids.size()) {
            out.print(this.mvids.key(i2));
            out.write(9);
            out.println(this.mvids.value(i2));
            ++i2;
        }
        out.close();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private byte[] id(DataAccess in) {
        while (in.more()) {
            byte n;
            if (in.read1() != 10 || (n = in.read1()) != 48 || in.read1() != 48 || in.read1() != 49) continue;
            this.off = in.pos() - 3L;
            return this.ident(in);
        }
        return null;
    }

    private byte[] par(DataAccess in) {
        while (in.more()) {
            if (in.read1() != 10) continue;
            byte b1 = in.read1();
            if (b1 == 35 || b1 == 10) {
                return null;
            }
            if ((b1 != 48 || in.read1() != 49 || in.read1() != 48) && (b1 != 52 || in.read1() != 53 || in.read1() != 51)) continue;
            return this.ident(in);
        }
        return null;
    }

    private byte[] ident(DataAccess in) {
        byte b;
        in.read1();
        int l = 0;
        while ((b = in.read1()) >= 32) {
            MAB2Parser.CACHE[l++] = b;
        }
        return Arrays.copyOf(CACHE, l);
    }

    private byte[] find(DataAccess in, byte delim) {
        this.buffer.reset();
        while (in.more()) {
            byte c = in.read1();
            if (c == delim) {
                return this.buffer.toArray();
            }
            if (c >= 0 && c < 32) continue;
            this.buffer.add(c);
        }
        return null;
    }

    private byte[] addEntry(DataAccess in, long pos, int sb, byte[] last) throws IOException {
        byte[] line;
        int l;
        this.mvID = null;
        this.bibID = null;
        this.title = null;
        this.description = null;
        this.type = null;
        this.language = null;
        this.original = null;
        this.subtitle = null;
        this.town = null;
        this.publisher = null;
        this.year = null;
        this.format = null;
        this.details = null;
        this.note = null;
        this.isbn = null;
        this.subject = null;
        this.nrSigs = 0;
        this.nrPers = 0;
        this.nrInst = 0;
        this.shortTitle = false;
        in.cursor(pos);
        while ((l = (line = this.find(in, (byte)10)).length) > 3) {
            if (line[0] == 35) continue;
            int n = Token.toInt(line, 0, 3);
            if (n == 1) {
                if (this.bibID != null) continue;
                this.bibID = MAB2Parser.string(line);
                this.mvID = this.mvids.get(this.bibID);
                if (this.mvID != null) continue;
                this.mvID = Token.token(++this.maxid);
                this.mvids.add(this.bibID, this.mvID);
                continue;
            }
            if (n == 29) {
                this.type = this.mediatypes.get(MAB2Parser.num(line));
                continue;
            }
            if (n == 37 && this.language == null) {
                this.language = this.language(line);
                continue;
            }
            if (n == 81) {
                this.title = MAB2Parser.string(line);
                this.shortTitle = true;
                continue;
            }
            if (n >= 100 && n < 200 && (n & 3) == 0) {
                this.pers[this.nrPers++] = MAB2Parser.string(line);
                continue;
            }
            if (n >= 200 && n < 300 && (n & 3) == 0) {
                this.inst[this.nrInst++] = MAB2Parser.string(line);
                continue;
            }
            if (n == 304) {
                this.original = MAB2Parser.string(line);
                continue;
            }
            if (n == 310) {
                this.title = MAB2Parser.string(line);
                this.shortTitle = true;
                continue;
            }
            if (n == 331) {
                if (this.title == null) {
                    this.title = MAB2Parser.string(line);
                    continue;
                }
                if (!this.shortTitle) continue;
                this.description = MAB2Parser.string(line);
                continue;
            }
            if (n == 335) {
                this.subtitle = MAB2Parser.string(line);
                continue;
            }
            if (n == 340) {
                if (this.original != null) continue;
                this.original = MAB2Parser.string(line);
                continue;
            }
            if (n == 359) {
                this.description = MAB2Parser.merge(this.description, MAB2Parser.string(line));
                continue;
            }
            if (n == 410) {
                this.town = MAB2Parser.string(line);
                continue;
            }
            if (n == 412) {
                this.publisher = MAB2Parser.string(line);
                continue;
            }
            if (n == 425) {
                this.year = MAB2Parser.year(line);
                continue;
            }
            if (n == 433) {
                this.format = MAB2Parser.string(line);
                continue;
            }
            if (n == 501) {
                this.details = MAB2Parser.string(line);
                this.year = MAB2Parser.year2(this.details, this.year);
                continue;
            }
            if (n == 537) {
                this.note = MAB2Parser.string(line);
                continue;
            }
            if (n == 540) {
                this.isbn = MAB2Parser.string(line);
                continue;
            }
            if (n == 542) {
                this.isbn = MAB2Parser.string(line);
                continue;
            }
            if (n == 544) {
                this.sig[this.nrSigs++] = MAB2Parser.string(line);
                continue;
            }
            if (n != 700 || this.nrSigs != 0) continue;
            this.sig[this.nrSigs++] = MAB2Parser.string(line);
        }
        this.atts.reset();
        this.atts.add(MAB2.MV_ID, this.mvID);
        this.atts.add(MAB2.BIB_ID, this.bibID);
        if (sb != 0 && !this.flat) {
            this.atts.add(MAB2.MAX, Token.token(sb));
        }
        if (last != null) {
            if (this.title == null) {
                this.title = last;
            } else if (!Token.eq(last, this.title)) {
                this.title = Token.concat(last, MAB2.SEMI, this.title);
            }
        }
        this.builder.startElem(MAB2.MEDIUM, this.atts);
        this.add(MAB2.TYPE, this.type);
        this.add(MAB2.LANGUAGE, this.language);
        int s = 0;
        while (s < this.nrPers) {
            this.add(MAB2.PERSON, this.pers[s]);
            ++s;
        }
        s = 0;
        while (s < this.nrInst) {
            this.add(MAB2.INSTITUTE, this.inst[s]);
            ++s;
        }
        this.add(MAB2.ORIGINAL, this.original);
        this.add(MAB2.TITLE, this.title);
        this.add(MAB2.SUBTITLE, this.subtitle);
        this.add(MAB2.DESCRIPTION, this.description);
        this.add(MAB2.TOWN, this.town);
        this.add(MAB2.PUBLISHER, this.publisher);
        this.add(MAB2.YEAR, this.year);
        this.add(MAB2.FORMAT, this.format);
        this.add(MAB2.DETAILS, this.details);
        this.add(MAB2.NOTE, this.note);
        s = 0;
        while (s < this.nrSigs) {
            this.add(MAB2.SIGNATURE, this.sig[s]);
            ++s;
        }
        s = 0;
        while (s < this.nrSigs) {
            if (this.subject == null) {
                this.subject = this.subjects.get(MAB2Parser.subject(this.sig[s]));
            }
            ++s;
        }
        this.add(MAB2.SUBJECT, this.subject);
        this.add(MAB2.ISBN, this.isbn);
        this.add(MAB2.POSTER, this.posters.get(this.bibID));
        this.add(MAB2.GENRE, this.genres.get(this.mvID));
        this.add(MAB2.STATUS, this.status.get(this.bibID));
        this.add(MAB2.LENDINGS, this.lendings.get(this.bibID));
        if (sb == 0 || this.flat) {
            this.builder.endElem(MAB2.MEDIUM);
        }
        return this.title;
    }

    private void add(byte[] tag, byte[] cont) throws IOException {
        if (cont == null) {
            return;
        }
        this.builder.startElem(tag, this.atts.reset());
        this.builder.text(Token.utf8(cont, ENCODING));
        this.builder.endElem(tag);
    }

    private static byte[] year(byte[] line) {
        byte[] n = new byte[4];
        int l = line.length;
        int c = 0;
        int i = 4;
        while (i < l) {
            byte b = line[i];
            if (b >= 48 && b <= 57) {
                n[c++] = b;
                if (c == 4) {
                    return n;
                }
            }
            ++i;
        }
        return c != 0 ? Arrays.copyOf(n, c) : null;
    }

    private static byte[] year2(byte[] line, byte[] yr) {
        int oy;
        int l = line.length;
        int i = -1;
        int j = -1;
        while (++i != l) {
            byte b = line[i];
            if (b >= 48 && b <= 57) continue;
            if (i - 5 == j) break;
            j = i;
        }
        if (i - 5 != j) {
            return yr;
        }
        int n = oy = yr != null ? Token.toInt(yr) : 0;
        if (oy >= 1400 && oy <= 1950) {
            return yr;
        }
        byte[] y = Arrays.copyOfRange(line, j + 1, j + 5);
        oy = Token.toInt(y);
        return oy >= 1500 && oy <= 2050 ? y : yr;
    }

    private static byte[] subject(byte[] line) {
        byte[] n = new byte[3];
        int i = -1;
        int l = line.length;
        while (++i != l && line[i] < 97) {
        }
        int c = 0;
        while (i != l && line[i] >= 97) {
            n[c++] = line[i++];
            if (c != 3) continue;
            return n;
        }
        return null;
    }

    private byte[] language(byte[] token) {
        byte[] t = MAB2Parser.string(token);
        int i = 0;
        while (i < t.length) {
            if (t[i] == 63 || t[i] == 36) {
                t[i] = 43;
            }
            ++i;
        }
        TokenBuilder tb = new TokenBuilder();
        byte[][] byArray = Token.split(t, 43);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] lang = byArray[n2];
            byte[] l = this.languages.get(lang);
            if (tb.size() != 0) {
                tb.add(43);
            }
            tb.add(l != null ? l : t);
            ++n2;
        }
        return tb.finish();
    }

    private static byte[] string(byte[] line) {
        byte[] tmp = new byte[line.length - 4];
        int c = 0;
        int l = line.length;
        boolean space = false;
        int s = 4;
        while (s < l) {
            int b = line[s];
            if (b == -121) {
                b = 43;
            } else if (b == -84) {
                b = 32;
            } else if (b == 60) {
                b = 91;
            } else if (b == 62) {
                b = 93;
            }
            if (b != 32 || !space && s != 4) {
                space = b == 32;
                tmp[c++] = b;
            }
            ++s;
        }
        return c == tmp.length ? tmp : Arrays.copyOf(tmp, c);
    }

    private static byte[] num(byte[] line) {
        int l = line.length;
        int s = 3;
        while (++s < l && line[s] == 48) {
        }
        return Arrays.copyOfRange(line, s, line.length);
    }

    private static byte[] merge(byte[] text1, byte[] text2) {
        return text1 == null ? text2 : Token.concat(text1, Token.token(". "), text2);
    }

    private void index(TokenMap hash, String fn) {
        try {
            DataAccess in = new DataAccess(new File(String.valueOf(fn) + ".dat"));
            while (true) {
                byte[] key = this.find(in, (byte)9);
                byte[] val = this.find(in, (byte)10);
                if (key != null) {
                    hash.add(key, val);
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    static final class MAB2Entry {
        long[] children;
        long pos;
        int size;

        MAB2Entry() {
        }

        void add(long c) {
            if (this.children == null) {
                this.children = new long[1];
            } else if (this.size == this.children.length) {
                this.children = Arrays.copyOf(this.children, this.size << 1);
            }
            this.children[this.size++] = c;
        }

        void pos(long p) {
            this.pos = p;
        }
    }
}

