/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public final class DialogEdit
extends Dialog {
    public final StringList result = new StringList();
    public final int kind;
    private final int pre;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private BaseXTextField input1;
    private BaseXTextField input2;
    private BaseXEditor input3;
    private String old1;
    private String old2;
    private byte[] old3;

    public DialogEdit(GUI main, int p) {
        super(main, Text.EDITTITLE);
        this.pre = p;
        BaseXBack pp = new BaseXBack(new BorderLayout());
        Context context = this.gui.context;
        Data data = context.data;
        this.kind = data.kind(this.pre);
        String title = Util.info(Text.EDITTEXT, Text.EDITKIND[this.kind]);
        BaseXLabel label = new BaseXLabel(title, true, true);
        pp.add((Component)label, "North");
        if (this.kind == 1) {
            this.old1 = Token.string(data.name(this.pre, this.kind));
        } else if (this.kind == 0) {
            this.old1 = Token.string(data.text(this.pre, true));
        } else if (this.kind == 2 || this.kind == 4) {
            this.old3 = data.atom(this.pre);
        } else if (this.kind == 3) {
            this.old1 = Token.string(data.name(this.pre, this.kind));
            this.old2 = Token.string(data.atom(this.pre));
        } else {
            this.old1 = Token.string(data.name(this.pre, this.kind));
            this.old3 = data.atom(this.pre);
        }
        BaseXBack b = new BaseXBack(new BorderLayout(0, 4));
        if (this.old1 != null) {
            this.input1 = new BaseXTextField(this.old1, this);
            this.input1.addKeyListener(this.keys);
            BaseXLayout.setWidth(this.input1, 320);
            b.add((Component)this.input1, "North");
        }
        if (this.old2 != null) {
            this.input2 = new BaseXTextField(this.old2, this);
            this.input2.addKeyListener(this.keys);
            b.add((Component)this.input2, "Center");
        }
        if (this.old3 != null) {
            this.input3 = new BaseXEditor(true, (Window)this);
            this.input3.setText(this.old3);
            this.input3.addKeyListener(this.keys);
            this.input3.setPreferredSize(new Dimension(320, 200));
            b.add((Component)this.input3, "Center");
            this.setResizable(true);
        }
        pp.add((Component)b, "Center");
        this.set(pp, "Center");
        pp = new BaseXBack(new BorderLayout());
        this.info = new BaseXLabel(" ").border(8, 0, 2, 0);
        pp.add((Component)this.info, "West");
        this.buttons = DialogEdit.okCancel(this);
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        String msg = null;
        boolean bl = this.ok = this.kind != 2 || this.input3.getText().length != 0;
        if (this.kind != 2 && this.kind != 4) {
            this.ok = XMLToken.isQName(Token.token(this.input1.getText()));
            if (!this.ok && !this.input1.getText().isEmpty()) {
                msg = Util.info(Text.INVALID, Text.EDITNAME);
            }
        }
        this.info.setText(msg, GUIConstants.Msg.ERROR);
        DialogEdit.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        super.close();
        this.ok = false;
        if (this.old1 != null) {
            this.result.add(this.input1.getText());
            this.ok |= !this.input1.getText().equals(this.old1);
        }
        if (this.old2 != null) {
            this.result.add(this.input2.getText());
            this.ok |= !this.input2.getText().equals(this.old2);
        }
        if (this.old3 != null) {
            this.result.add(Token.string(this.input3.getText()));
            this.ok |= !Token.eq(this.input3.getText(), this.old3);
        }
    }
}

