/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.kindocument.KinXsdException;
import nl.mpi.kinnate.userstorage.KinSessionStorage;

public class CmdiTransformer {
    private URL component2SchemaXsl = this.getClass().getResource("/xsd/comp2schema.xsl");
    private URL component2SchemaXslHeader = this.getClass().getResource("/xsd/comp2schema-header.xsl");
    private URL component2SchemaXslCleanup = this.getClass().getResource("/xsd/cleanup-xsd.xsl");
    private URL cmdi2kmdiXsl = this.getClass().getResource("/xsd/cmdi2kmdi.xsl");
    private SessionStorage sessionStorage;

    public CmdiTransformer(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public URI getXsd(String profileId, boolean forceUpdate) throws KinXsdException {
        String profileFileName = profileId.replace(":", "_");
        File profilesDirectory = new File(this.sessionStorage.getStorageDirectory(), "KmdiProfiles");
        if (!profilesDirectory.exists()) {
            profilesDirectory.mkdir();
        }
        File xsdFile = new File(profilesDirectory, profileFileName + "-kmdi.xsd");
        File intermediateFile = new File(profilesDirectory, profileFileName + "-cmdi.xsd");
        if (forceUpdate || !xsdFile.exists()) {
            this.transformProfileXmlToXsd(xsdFile, intermediateFile, profileId);
        }
        return xsdFile.toURI();
    }

    private File transformProfileXmlToXsd(File outputFile, File intermediateFile, String profileId) throws KinXsdException {
        String cmdiProfileXmlUrl = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/" + profileId + "/xml";
        System.out.println("outputFile: " + outputFile.getAbsolutePath());
        File xlsFile = this.sessionStorage.updateCache(this.component2SchemaXsl.toExternalForm(), 1, false);
        File xslHeader = this.sessionStorage.updateCache(this.component2SchemaXslHeader.toExternalForm(), 1, false);
        File cleanUpXsl = this.sessionStorage.updateCache(this.component2SchemaXslCleanup.toExternalForm(), 1, false);
        System.out.println(intermediateFile);
        System.out.println(outputFile);
        try {
            this.generateXsd(xlsFile, cmdiProfileXmlUrl, intermediateFile);
            File cmdi2kmdiFile = this.sessionStorage.updateCache(this.cmdi2kmdiXsl.toExternalForm(), 1, false);
            this.generateXsd(cmdi2kmdiFile, intermediateFile.toURI().toString(), outputFile);
            return outputFile;
        }
        catch (IOException exception) {
            System.out.println("exception: " + exception.getMessage());
            intermediateFile.delete();
            xslHeader.delete();
            cleanUpXsl.delete();
            xlsFile.delete();
            throw new KinXsdException("Could not read the selected profile");
        }
        catch (TransformerException exception) {
            System.out.println("exception: " + exception.getMessage());
            intermediateFile.delete();
            xslHeader.delete();
            cleanUpXsl.delete();
            xlsFile.delete();
            throw new KinXsdException("Could not read the selected profile");
        }
    }

    private void generateXsd(File xlsFile, String cmdiProfileXmlUrl, File outputFile) throws IOException, TransformerException {
        System.setProperty("javax.xml.transform.TransformerFactory", TransformerFactoryImpl.class.getName());
        Templates componentToSchemaTemplates = TransformerFactory.newInstance().newTemplates(new StreamSource(xlsFile));
        Transformer transformer = componentToSchemaTemplates.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(new StreamSource(cmdiProfileXmlUrl), new StreamResult(new FileOutputStream(outputFile)));
    }

    public static void main(String[] args) {
        try {
            String profileId = "clarin.eu:cr1:p_1320657629627";
            KinSessionStorage kinSessionStorage = new KinSessionStorage(new ApplicationVersionManager((ApplicationVersion)new KinOathVersion()));
            new CmdiTransformer((SessionStorage)kinSessionStorage).getXsd(profileId, true);
        }
        catch (KinXsdException exception) {
            System.out.println("exception: " + exception.getMessage());
        }
    }
}

