/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.export.PedigreePackageExport;
import nl.mpi.kinnate.kindata.EntityData;

public class ExportToR {
    private SessionStorage sessionStorage;
    private MessageDialogHandler dialogHandler;

    public ExportToR(SessionStorage sessionStorage, MessageDialogHandler dialogHandler) {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
    }

    public void doExport(Component mainFrame, SavePanel savePanel, File destinationFile) {
        PedigreePackageExport packageExport = new PedigreePackageExport();
        try {
            FileWriter fileWriter = new FileWriter(destinationFile, false);
            EntityData[] dataNodes = savePanel.getGraphPanel().dataStoreSvg.graphData.getDataNodes();
            ArrayList<EntityData> visibleEntities = new ArrayList<EntityData>();
            for (EntityData currentEntity : dataNodes) {
                if (!currentEntity.isVisible) continue;
                visibleEntities.add(currentEntity);
            }
            fileWriter.write(packageExport.createCsvContents(visibleEntities.toArray(new EntityData[0])));
            fileWriter.close();
            this.dialogHandler.addMessageDialogToQueue("Exported " + visibleEntities.size() + " entities", "Export");
        }
        catch (IOException exception) {
            this.dialogHandler.addMessageDialogToQueue("Error, could not export the data to file", "Export");
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
    }
}

