/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindocument.DocumentLoader;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Document;

public class RelationLinker
extends DocumentLoader {
    public RelationLinker(SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection) {
        super(sessionStorage, dialogHandler, entityCollection);
    }

    private void removeMatchingRelations(Document entityDocument, UniqueIdentifier[] selectedIdentifiers) {
    }

    public UniqueIdentifier[] linkEntities(UniqueIdentifier leadIdentifier, UniqueIdentifier[] otherIdentifiers, DataTypes.RelationType relationType, String dcrType, String customType) throws ImportException {
        try {
            EntityDocument leadEntityDocument = this.getEntityDocument(leadIdentifier);
            for (UniqueIdentifier uniqueIdentifier : otherIdentifiers) {
                EntityDocument entityDocument = this.getEntityDocument(uniqueIdentifier);
                leadEntityDocument.entityData.addRelatedNode(entityDocument.entityData, relationType, null, null, dcrType, customType);
            }
            this.saveAllDocuments();
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return this.getAffectedIdentifiers();
    }

    public UniqueIdentifier[] linkEntities(UniqueIdentifier[] selectedIdentifiers, DataTypes.RelationType relationType, String dcrType, String customType) throws ImportException {
        ArrayList<EntityDocument> nonLeadEntityDocuments = new ArrayList<EntityDocument>();
        try {
            EntityDocument leadEntityDocument = this.getEntityDocuments(selectedIdentifiers, nonLeadEntityDocuments);
            for (EntityDocument entityDocument : nonLeadEntityDocuments) {
                leadEntityDocument.entityData.addRelatedNode(entityDocument.entityData, relationType, null, null, dcrType, customType);
            }
            this.saveAllDocuments();
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return this.getAffectedIdentifiers();
    }

    public UniqueIdentifier[] unlinkEntities(GraphPanel graphPanel, UniqueIdentifier[] selectedIdentifiers) throws ImportException {
        ArrayList<EntityDocument> nonLeadEntityDocuments = new ArrayList<EntityDocument>();
        try {
            EntityDocument leadEntityDocument = this.getEntityDocuments(selectedIdentifiers, nonLeadEntityDocuments);
            while (!nonLeadEntityDocuments.isEmpty()) {
                for (EntityDocument entityDocument : nonLeadEntityDocuments) {
                    leadEntityDocument.entityData.removeRelationsWithNode(entityDocument.entityData);
                    entityDocument.entityData.removeRelationsWithNode(leadEntityDocument.entityData);
                }
                leadEntityDocument = nonLeadEntityDocuments.remove(0);
            }
            this.saveAllDocuments();
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return this.getAffectedIdentifiers();
    }

    public void deleteEntity(UniqueIdentifier[] selectedIdentifiers) throws ImportException {
        ArrayList<EntityDocument> entityDocumentList = new ArrayList<EntityDocument>();
        try {
            EntityDocument currentDocument;
            this.getEntityDocuments(selectedIdentifiers, entityDocumentList);
            for (UniqueIdentifier uniqueIdentifier : selectedIdentifiers) {
                currentDocument = (EntityDocument)this.entityMap.get(uniqueIdentifier);
                for (EntityRelation entityRelation : currentDocument.entityData.getAllRelations()) {
                    EntityDocument relatedDocument = (EntityDocument)this.entityMap.get(entityRelation.alterUniqueIdentifier);
                    currentDocument.entityData.removeRelationsWithNode(relatedDocument.entityData);
                    relatedDocument.entityData.removeRelationsWithNode(currentDocument.entityData);
                }
            }
            this.saveAllDocuments();
            for (UniqueIdentifier uniqueIdentifier : selectedIdentifiers) {
                currentDocument = (EntityDocument)this.entityMap.get(uniqueIdentifier);
                try {
                    this.deleteFromDataBase(currentDocument);
                }
                catch (IOException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    throw new ImportException("Error: " + exception.getMessage());
                }
            }
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
    }
}

