/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.BorderLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.GraphPanelSize;
import nl.mpi.kinnate.svg.GraphUserAgent;
import nl.mpi.kinnate.svg.MouseListenerSvg;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.GraphPanelContextMenu;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.MetadataPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.util.SAXIOException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel
extends JPanel
implements SavePanel {
    private JSVGScrollPane jSVGScrollPane;
    protected JSVGCanvas svgCanvas;
    protected SVGDocument doc;
    public MetadataPanel metadataPanel;
    private boolean requiresSave = false;
    private File svgFile = null;
    public GraphPanelSize graphPanelSize;
    protected ArrayList<UniqueIdentifier> selectedGroupId;
    protected String svgNameSpace = "http://www.w3.org/2000/svg";
    public DataStoreSvg dataStoreSvg;
    public EntitySvg entitySvg;
    public SvgUpdateHandler svgUpdateHandler;
    public MouseListenerSvg mouseListenerSvg;
    private MessageDialogHandler dialogHandler;
    private SessionStorage sessionStorage;

    public GraphPanel(KinDiagramPanel kinDiagramPanel, ArbilWindowManager arbilWindowManager, SessionStorage sessionStorage, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.dialogHandler = arbilWindowManager;
        this.sessionStorage = sessionStorage;
        this.dataStoreSvg = new DataStoreSvg();
        this.entitySvg = new EntitySvg(this.dialogHandler);
        this.dataStoreSvg.setDefaults();
        this.svgUpdateHandler = new SvgUpdateHandler(this, kinDiagramPanel, this.dialogHandler);
        this.selectedGroupId = new ArrayList();
        this.graphPanelSize = new GraphPanelSize();
        this.setLayout(new BorderLayout());
        boolean eventsEnabled = true;
        boolean selectableText = false;
        this.svgCanvas = new JSVGCanvas(new GraphUserAgent(this, this.dialogHandler, dataNodeLoader), eventsEnabled, selectableText);
        this.svgCanvas.setDocumentState(1);
        this.svgCanvas.setEnableImageZoomInteractor(false);
        this.svgCanvas.setEnablePanInteractor(false);
        this.svgCanvas.setEnableRotateInteractor(false);
        this.svgCanvas.setEnableZoomInteractor(false);
        this.svgCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isAltDown()) {
                    double scale = 1.0 - (double)e.getUnitsToScroll() / 10.0;
                    double tx = (double)(-e.getX()) * (scale - 1.0);
                    double ty = (double)(-e.getY()) * (scale - 1.0);
                    if (scale > 1.0 || GraphPanel.this.svgCanvas.getRenderingTransform().getScaleX() > 0.01) {
                        AffineTransform at = new AffineTransform();
                        at.translate(tx, ty);
                        at.scale(scale, scale);
                        at.concatenate(GraphPanel.this.svgCanvas.getRenderingTransform());
                        GraphPanel.this.svgCanvas.setRenderingTransform(at);
                    }
                }
            }
        });
        this.mouseListenerSvg = new MouseListenerSvg(kinDiagramPanel, this, sessionStorage, this.dialogHandler, entityCollection);
        this.svgCanvas.addMouseListener(this.mouseListenerSvg);
        this.svgCanvas.addMouseMotionListener(this.mouseListenerSvg);
        this.jSVGScrollPane = new JSVGScrollPane(this.svgCanvas);
        this.add("Center", this.jSVGScrollPane);
        this.svgCanvas.setComponentPopupMenu(new GraphPanelContextMenu(kinDiagramPanel, this, entityCollection, arbilWindowManager, dataNodeLoader, sessionStorage));
    }

    public void setArbilTableModel(MetadataPanel metadataPanel) {
        this.metadataPanel = metadataPanel;
    }

    public void readSvg(URI svgFilePath, boolean savableType) {
        this.svgFile = savableType ? new File(svgFilePath) : null;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(parser);
        try {
            this.doc = (SVGDocument)documentFactory.createDocument(svgFilePath.toString());
            this.svgCanvas.setDocument((Document)this.doc);
            this.dataStoreSvg = DataStoreSvg.loadDataFromSvg(this.doc);
            if (this.dataStoreSvg.indexParameters == null) {
                this.dataStoreSvg.setDefaults();
            }
            this.requiresSave = false;
            this.entitySvg.readEntityPositions(this.doc.getElementById("EntityGroup"));
            this.entitySvg.readEntityPositions(this.doc.getElementById("LabelsGroup"));
            this.entitySvg.readEntityPositions(this.doc.getElementById("GraphicsGroup"));
            this.configureDiagramGroups();
            this.dataStoreSvg.indexParameters.symbolFieldsFields.setAvailableValues(this.entitySvg.listSymbolNames(this.doc, this.svgNameSpace));
        }
        catch (SAXIOException exception) {
            this.dialogHandler.addMessageDialogToQueue("Cannot open the diagram: " + exception.getMessage(), "Open Diagram");
        }
        catch (IOException exception) {
            this.dialogHandler.addMessageDialogToQueue("Cannot open the diagram: " + exception.getMessage(), "Open Diagram");
        }
    }

    private void configureDiagramGroups() {
        Element svgRoot = this.doc.getDocumentElement();
        Element diagramGroup = this.doc.getElementById("DiagramGroup");
        if (diagramGroup == null) {
            diagramGroup = this.doc.createElementNS(this.svgNameSpace, "g");
            diagramGroup.setAttribute("id", "DiagramGroup");
            svgRoot.appendChild(diagramGroup);
        }
        Element previousElement = null;
        for (String groupForMouseListener : new String[]{"LabelsGroup", "EntityGroup", "RelationGroup", "GraphicsGroup"}) {
            Element parentElement = this.doc.getElementById(groupForMouseListener);
            if (parentElement == null) {
                parentElement = this.doc.createElementNS(this.svgNameSpace, "g");
                parentElement.setAttribute("id", groupForMouseListener);
                diagramGroup.insertBefore(parentElement, previousElement);
            } else {
                diagramGroup.insertBefore(parentElement, previousElement);
                if (!groupForMouseListener.equals("RelationGroup")) {
                    for (Node currentNode = parentElement.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                        ((EventTarget)((Object)currentNode)).addEventListener("mousedown", this.mouseListenerSvg, false);
                    }
                }
            }
            previousElement = parentElement;
        }
    }

    public void generateDefaultSvg() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            String templateXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><svg xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:kin=\"http://mpi.nl/tla/kin\" xmlns=\"http://www.w3.org/2000/svg\" contentScriptType=\"text/ecmascript\"  zoomAndPan=\"magnify\" contentStyleType=\"text/css\" preserveAspectRatio=\"xMidYMid meet\" version=\"1.0\"/>";
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(parser);
            this.doc = (SVGDocument)documentFactory.createDocument(this.svgNameSpace, (Reader)new StringReader(templateXml));
            this.entitySvg.insertSymbols(this.doc, this.svgNameSpace);
            this.configureDiagramGroups();
            this.dataStoreSvg.indexParameters.symbolFieldsFields.setAvailableValues(this.entitySvg.listSymbolNames(this.doc, this.svgNameSpace));
            this.svgCanvas.setSVGDocument(this.doc);
            this.dataStoreSvg.graphData = new GraphSorter();
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
    }

    private void saveSvg(File svgFilePath) {
        this.svgFile = svgFilePath;
        this.selectedGroupId.clear();
        this.svgUpdateHandler.clearHighlights();
        this.dataStoreSvg.storeAllData(this.doc);
        ArbilComponentBuilder.savePrettyFormatting((Document)this.doc, (File)this.svgFile);
        this.requiresSave = false;
    }

    private void printNodeNames(Node nodeElement) {
        System.out.println(nodeElement.getLocalName());
        System.out.println(nodeElement.getNamespaceURI());
        for (Node childNode = nodeElement.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            this.printNodeNames(childNode);
        }
    }

    public String[] getKinTypeStrigs() {
        return this.dataStoreSvg.kinTypeStrings;
    }

    public void setKinTypeStrigs(String[] kinTypeStringArray) {
        this.dataStoreSvg.kinTypeStrings = kinTypeStringArray;
    }

    public IndexerParameters getIndexParameters() {
        return this.dataStoreSvg.indexParameters;
    }

    public KinTermGroup[] getkinTermGroups() {
        return this.dataStoreSvg.kinTermGroups;
    }

    public KinTermGroup addKinTermGroup() {
        ArrayList<KinTermGroup> kinTermsList = new ArrayList<KinTermGroup>(Arrays.asList(this.dataStoreSvg.kinTermGroups));
        KinTermGroup kinTermGroup = new KinTermGroup();
        kinTermsList.add(kinTermGroup);
        this.dataStoreSvg.kinTermGroups = kinTermsList.toArray(new KinTermGroup[0]);
        return kinTermGroup;
    }

    public void setSelectedIds(UniqueIdentifier[] uniqueIdentifiers) {
        this.selectedGroupId.clear();
        this.selectedGroupId.addAll(Arrays.asList(uniqueIdentifiers));
        this.svgUpdateHandler.updateSvgSelectionHighlights();
    }

    public UniqueIdentifier[] getSelectedIds() {
        return this.selectedGroupId.toArray(new UniqueIdentifier[0]);
    }

    public EntityData getEntityForElementId(UniqueIdentifier uniqueIdentifier) {
        for (EntityData entityData : this.dataStoreSvg.graphData.getDataNodes()) {
            if (!uniqueIdentifier.equals(entityData.getUniqueIdentifier())) continue;
            return entityData;
        }
        return null;
    }

    public HashMap<UniqueIdentifier, EntityData> getEntitiesById(UniqueIdentifier[] uniqueIdentifiers) {
        ArrayList<UniqueIdentifier> identifierList = new ArrayList<UniqueIdentifier>(Arrays.asList(uniqueIdentifiers));
        HashMap<UniqueIdentifier, EntityData> returnMap = new HashMap<UniqueIdentifier, EntityData>();
        for (EntityData entityData : this.dataStoreSvg.graphData.getDataNodes()) {
            if (!identifierList.contains(entityData.getUniqueIdentifier())) continue;
            returnMap.put(entityData.getUniqueIdentifier(), entityData);
        }
        return returnMap;
    }

    public String getPathForElementId(UniqueIdentifier elementId) {
        Element entityElement = this.doc.getElementById(elementId.getAttributeIdentifier());
        if (entityElement == null) {
            return null;
        }
        return entityElement.getAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "path");
    }

    public String getKinTypeForElementId(UniqueIdentifier elementId) {
        Element entityElement = this.doc.getElementById(elementId.getAttributeIdentifier());
        if (entityElement != null) {
            return entityElement.getAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "kintype");
        }
        return "";
    }

    public Dimension2D getDiagramSize() {
        return this.svgCanvas.getSVGDocumentSize();
    }

    public void resetZoom() {
        AffineTransform at = new AffineTransform();
        at.scale(1.0, 1.0);
        at.setToTranslation(1.0, 1.0);
        this.svgCanvas.setRenderingTransform(at);
    }

    public void resetLayout() {
        this.entitySvg = new EntitySvg(this.dialogHandler);
        this.dataStoreSvg.graphData.setEntitys(this.dataStoreSvg.graphData.getDataNodes());
        this.dataStoreSvg.graphData.placeAllNodes(this.entitySvg.entityPositions);
        this.drawNodes();
    }

    public UniqueIdentifier[] getDiagramUniqueIdentifiers() {
        return this.entitySvg.entityPositions.keySet().toArray(new UniqueIdentifier[0]);
    }

    public void clearEntityLocations(UniqueIdentifier[] selectedIdentifiers) {
        this.entitySvg.clearEntityLocations(selectedIdentifiers);
    }

    public void drawNodes() {
        this.requiresSave = true;
        this.selectedGroupId.clear();
        this.svgUpdateHandler.updateEntities();
    }

    public void drawNodes(GraphSorter graphDataLocal) {
        this.dataStoreSvg.graphData = graphDataLocal;
        this.drawNodes();
        if (graphDataLocal.getDataNodes().length == 0) {
            // empty if block
        }
    }

    @Override
    public boolean hasSaveFileName() {
        return this.svgFile != null;
    }

    @Override
    public File getFileName() {
        return this.svgFile;
    }

    @Override
    public boolean requiresSave() {
        return this.requiresSave;
    }

    @Override
    public void setRequiresSave() {
        this.requiresSave = true;
    }

    @Override
    public void saveToFile() {
        this.saveSvg(this.svgFile);
    }

    @Override
    public void saveToFile(File saveAsFile) {
        this.saveSvg(saveAsFile);
    }

    @Override
    public void updateGraph() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void doActionCommand(MouseListenerSvg.ActionCode actionCode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GraphPanel getGraphPanel() {
        return this;
    }
}

