/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security;

import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import net.handle.hdllib.Util;

public class DSAPublicKeyImpl
implements DSAPublicKey {
    private BigInteger y;
    private DSAParams params;

    public DSAPublicKeyImpl(BigInteger y, DSAParams params) throws NumberFormatException {
        this.y = y;
        this.params = params;
    }

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "HDL_DSA_PUB";
    }

    public byte[] getEncoded() {
        try {
            return Util.getBytesFromPublicKey(this);
        }
        catch (Exception e) {
            System.err.println("Error encoding public key: " + e);
            return null;
        }
    }
}

