/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;

public class ArbilJournal {
    private static MessageDialogHandler messageDialogHandler;
    private static SessionStorage sessionStorage;
    private static ArbilJournal singleInstance;
    ArrayList<HistoryItem> fieldChangeHistory;
    int currentFieldChangeHistoryItem = 0;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    private ArbilJournal() {
    }

    public static synchronized ArbilJournal getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilJournal();
        }
        return singleInstance;
    }

    public synchronized void recordFieldChange(ArbilField targetField, String oldValue, String newValue, UndoType undoType) {
        if (this.fieldChangeHistory == null) {
            this.fieldChangeHistory = new ArrayList();
            this.currentFieldChangeHistoryItem = 0;
        }
        if (this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size()) {
            this.fieldChangeHistory = new ArrayList<HistoryItem>(this.fieldChangeHistory.subList(0, this.currentFieldChangeHistoryItem));
        }
        HistoryItem historyItem = new HistoryItem();
        historyItem.targetField = targetField;
        historyItem.oldValue = oldValue;
        historyItem.newValue = newValue;
        historyItem.undoType = undoType;
        this.fieldChangeHistory.add(historyItem);
        ++this.currentFieldChangeHistoryItem;
    }

    public boolean canUndo() {
        return this.currentFieldChangeHistoryItem > 0;
    }

    public boolean canRedo() {
        return this.fieldChangeHistory != null && this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size();
    }

    public void undoFromFieldChangeHistory() {
        if (this.canUndo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(--this.currentFieldChangeHistoryItem);
            HistoryItem reversedHistoryItem = new HistoryItem();
            reversedHistoryItem.newValue = changeHistoryItem.oldValue;
            reversedHistoryItem.oldValue = changeHistoryItem.newValue;
            reversedHistoryItem.targetField = changeHistoryItem.targetField;
            reversedHistoryItem.undoType = changeHistoryItem.undoType;
            this.makeChangeFromHistoryItem(reversedHistoryItem);
        }
    }

    public void redoFromFieldChangeHistory() {
        if (this.canRedo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(this.currentFieldChangeHistoryItem++);
            this.makeChangeFromHistoryItem(changeHistoryItem);
        }
    }

    public void clearFieldChangeHistory() {
        this.fieldChangeHistory = null;
        this.currentFieldChangeHistoryItem = 0;
    }

    private void makeChangeFromHistoryItem(HistoryItem historyItem) {
        String currentValue = null;
        switch (historyItem.undoType) {
            case KeyName: {
                currentValue = historyItem.targetField.getKeyName();
                break;
            }
            case LanguageId: {
                currentValue = historyItem.targetField.getLanguageId();
                break;
            }
            case Value: {
                currentValue = historyItem.targetField.getFieldValue();
            }
        }
        if (currentValue != null && !currentValue.equals(historyItem.oldValue)) {
            messageDialogHandler.addMessageDialogToQueue("The field value is out of sync with the history item", "Undo/Redo");
            BugCatcherManager.getBugCatcher().logError(new Exception("ChangeFromHistory old value does not match current value"));
        } else {
            switch (historyItem.undoType) {
                case KeyName: {
                    historyItem.targetField.setKeyName(historyItem.newValue, true, true);
                    break;
                }
                case LanguageId: {
                    historyItem.targetField.setLanguageId(historyItem.newValue, true, true);
                    break;
                }
                case Value: {
                    historyItem.targetField.setFieldValue(historyItem.newValue, true, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveJournalEntry(String imdiUrl, String imdiNodePath, String oldValue, String newValue, String eventType) {
        boolean returnValue = false;
        OutputStreamWriter journalFile = null;
        try {
            journalFile = new FileWriter(new File(sessionStorage.getStorageDirectory(), "linorgjornal.log"), true);
            System.out.println("Journal: " + imdiUrl + "," + imdiNodePath + "," + oldValue + "," + newValue);
            journalFile.append("\"" + imdiUrl + imdiNodePath + "\",\"" + oldValue + "\",\"" + newValue + "\",\"" + eventType + "\"\n");
            journalFile.close();
            journalFile = null;
            returnValue = true;
        }
        catch (Exception ex) {
            returnValue = false;
            BugCatcherManager.getBugCatcher().logError(ex);
            System.err.println("failed to write to the journal: " + ex.getMessage());
        }
        finally {
            if (journalFile != null) {
                try {
                    journalFile.close();
                }
                catch (IOException ioe) {
                    BugCatcherManager.getBugCatcher().logError(ioe);
                }
            }
        }
        return returnValue;
    }

    static {
        singleInstance = null;
    }

    private static class HistoryItem {
        ArbilField targetField;
        String oldValue;
        String newValue;
        UndoType undoType;

        private HistoryItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UndoType {
        Value,
        LanguageId,
        KeyName;

    }
}

