/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImporter
extends EntityImporter
implements GenericImporter {
    public CsvImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal, sessionStorage);
    }

    @Override
    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".csv");
    }

    @Deprecated
    private String cleanCsvString(String valueString) {
        valueString = valueString.replaceAll("^\"", "");
        valueString = valueString.replaceAll("\"$", "");
        valueString = valueString.replaceAll("\"\"", "");
        return valueString;
    }

    protected ArrayList<String> getFieldsForLine(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> lineFields = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int readChar = bufferedReader.read();
            while (readChar != -1) {
                switch (readChar) {
                    case -1: 
                    case 10: 
                    case 13: {
                        if (stringBuilder.length() > 0) {
                            lineFields.add(stringBuilder.toString());
                        }
                        return lineFields;
                    }
                    case 34: {
                        boolean insideQuotes = true;
                        int quotedCharsCount = 0;
                        while (insideQuotes) {
                            int readQuoted = bufferedReader.read();
                            if (readQuoted == -1) {
                                this.appendToTaskOutput("Warning: file ended within a quoted section");
                                return lineFields;
                            }
                            ++quotedCharsCount;
                            insideQuotes = readQuoted != 34;
                            if (!insideQuotes) continue;
                            stringBuilder.append((char)readQuoted);
                        }
                        if (quotedCharsCount >= true) break;
                        stringBuilder.append((char)readChar);
                        break;
                    }
                    case 9: 
                    case 44: {
                        lineFields.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    default: {
                        stringBuilder.append((char)readChar);
                    }
                }
                readChar = bufferedReader.read();
            }
        }
        catch (IOException exception) {
            this.appendToTaskOutput("Failed to read lines of input file");
            throw exception;
        }
        if (stringBuilder.length() > 0) {
            lineFields.add(stringBuilder.toString());
        }
        return lineFields;
    }

    @Override
    public URI[] importFile(InputStreamReader inputStreamReader, String profileId) {
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ImportTranslator importTranslator = new ImportTranslator(true);
            importTranslator.addTranslationEntry("Gender", "0", "Gender", "Female");
            importTranslator.addTranslationEntry("Gender", "1", "Gender", "Male");
            importTranslator.addTranslationEntry("Gender", "f", "Gender", "Female");
            importTranslator.addTranslationEntry("Gender", "m", "Gender", "Male");
            importTranslator.addTranslationEntry("Date_of_Birth", null, "DateOfBirth", null);
            importTranslator.addTranslationEntry("Date_of_Death", null, "DateOfDeath", null);
            ArrayList<String> allHeadings = this.getFieldsForLine(bufferedReader);
            super.incrementLineProgress();
            try {
                boolean continueReading = true;
                while (continueReading) {
                    ArrayList<String> lineFields = this.getFieldsForLine(bufferedReader);
                    continueReading = lineFields.size() > 0;
                    EntityDocument currentEntity = null;
                    EntityDocument relatedEntity = null;
                    String relatedEntityPrefix = null;
                    int valueCount = 0;
                    for (String entityField : lineFields) {
                        String headingString;
                        if (allHeadings.size() > valueCount) {
                            headingString = allHeadings.get(valueCount);
                        } else {
                            headingString = "-unnamed-field-";
                            this.appendToTaskOutput("Warning " + headingString + " for value: " + entityField);
                        }
                        if (currentEntity == null) {
                            currentEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                        } else if (entityField.length() > 0) {
                            if (headingString.matches("Spouses[\\d]*-ID")) {
                                relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                                currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.union, null, null, null, null);
                                relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            } else if (headingString.matches("Parents[\\d]*-ID")) {
                                relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                                currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.ancestor, null, null, null, null);
                                relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            } else if (headingString.matches("Children[\\d]*-ID")) {
                                relatedEntity = this.getEntityDocument(createdNodes, profileId, entityField, importTranslator);
                                currentEntity.entityData.addRelatedNode(relatedEntity.entityData, DataTypes.RelationType.descendant, null, null, null, null);
                                relatedEntityPrefix = headingString.substring(0, headingString.length() - "ID".length());
                            } else if (relatedEntityPrefix != null && headingString.startsWith(relatedEntityPrefix)) {
                                relatedEntity.insertValue(headingString.substring(relatedEntityPrefix.length()), entityField);
                            } else {
                                currentEntity.insertValue(headingString, entityField);
                            }
                        }
                        ++valueCount;
                    }
                    super.incrementLineProgress();
                }
            }
            catch (ImportException exception) {
                this.appendToTaskOutput(exception.getMessage());
            }
            this.saveAllDocuments();
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        return createdNodes.toArray(new URI[0]);
    }
}

