/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.B64;
import org.basex.query.item.Bin;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Hex
extends Bin {
    public Hex(byte[] v) {
        super(v, AtomType.HEX);
    }

    public Hex(byte[] v, InputInfo ii) throws QueryException {
        super(Hex.hex(Token.trim(v), ii), AtomType.HEX);
    }

    Hex(B64 b) {
        this(b.val);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.val, it instanceof Bin ? ((Bin)it).val : Hex.hex(Token.trim(it.atom(ii)), ii));
    }

    @Override
    public byte[] atom() {
        return Token.hex(this.val, true);
    }

    private static byte[] hex(byte[] h, InputInfo ii) throws QueryException {
        if ((h.length & 1) != 0) {
            throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)h[0]));
        }
        int l = h.length >>> 1;
        byte[] val = new byte[l];
        int i = 0;
        while (i < l) {
            val[i] = (byte)((Hex.hex(h[i << 1], ii) << 4) + Hex.hex(h[(i << 1) + 1], ii));
            ++i;
        }
        return val;
    }

    private static int hex(byte b, InputInfo ii) throws QueryException {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102 || b >= 65 && b <= 70) {
            return (b & 0xF) + 9;
        }
        throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)b));
    }
}

