/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        UntypedAtomicValue v = new UntypedAtomicValue(this.value);
        v.noSurrogates = this.noSurrogates;
        v.doubleValue = this.doubleValue;
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public int compareTo(AtomicValue other, StringCollator collator, XPathContext context) {
        if (other instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = new DoubleValue(context.getConfiguration().getConversionRules().getStringToDoubleConverter().stringToNumber(this.value));
                }
                catch (NumberFormatException e) {
                    throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to a double ");
                }
            }
            return this.doubleValue.compareTo(other);
        }
        if (other instanceof StringValue) {
            if (collator instanceof CodepointCollator) {
                return ((CodepointCollator)collator).compareCS(this.getStringValueCS(), other.getStringValueCS());
            }
            return collator.compareStrings(this.getStringValue(), other.getStringValue());
        }
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Converter converter = config.getConversionRules().getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, (AtomicType)other.getItemType(th));
        ConversionResult result = converter.convert(this);
        if (result instanceof ValidationFailure) {
            throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + other.getItemType(th));
        }
        return ((Comparable)((Object)((AtomicValue)result))).compareTo(other);
    }
}

