/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.entityprofiles;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import nl.mpi.kinnate.kindocument.ProfileManager;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileTableModel;

public class CmdiProfileSelectionPanel
extends JPanel
implements ActionListener {
    private JTable profileTable;
    private JPanel topPanel;
    private JProgressBar profileReloadProgressBar;
    private JLabel statusLabel;
    private JButton reloadButton;
    private ProfileTableModel profileTableModel;
    private ProfileManager profileManager;
    private GraphPanel graphPanel;
    private Color foregroundColour;

    public CmdiProfileSelectionPanel(String panelName, ProfileManager profileManager, GraphPanel graphPanel) {
        this.profileManager = profileManager;
        this.graphPanel = graphPanel;
        this.setName(panelName);
        this.setLayout(new BorderLayout());
        this.profileTableModel = new ProfileTableModel();
        this.profileTable = new JTable(this.profileTableModel);
        this.topPanel = new JPanel(new BorderLayout());
        this.profileReloadProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.foregroundColour = new JLabel().getForeground();
        this.reloadButton = new JButton("Reload List");
        this.reloadButton.addActionListener(this);
        this.topPanel.add((Component)this.statusLabel, "Center");
        this.topPanel.add((Component)this.reloadButton, "After");
        this.add((Component)this.topPanel, "First");
        this.add((Component)this.profileReloadProgressBar, "Last");
        this.add((Component)new JScrollPane(this.profileTable), "Center");
    }

    public void setStatus(final boolean reloadEnable, final String statusText, final boolean isError) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (isError) {
                    CmdiProfileSelectionPanel.this.statusLabel.setForeground(Color.red);
                } else {
                    CmdiProfileSelectionPanel.this.statusLabel.setForeground(CmdiProfileSelectionPanel.this.foregroundColour);
                }
                CmdiProfileSelectionPanel.this.statusLabel.setText(statusText);
                CmdiProfileSelectionPanel.this.reloadButton.setEnabled(reloadEnable);
                CmdiProfileSelectionPanel.this.profileReloadProgressBar.setVisible(!reloadEnable);
                CmdiProfileSelectionPanel.this.profileReloadProgressBar.setIndeterminate(true);
                CmdiProfileSelectionPanel.this.profileTableModel.fireTableDataChanged();
            }
        });
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileTableModel.setProfileManager(profileManager);
    }

    public void actionPerformed(ActionEvent e) {
        this.profileManager.loadProfiles(true, this, this.graphPanel);
    }
}

