/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import org.basex.util.Token;

public final class PkgVersion
implements Comparable<PkgVersion> {
    private final int major;
    private final int minor;
    private final int patch;

    public PkgVersion(byte[] version) {
        byte[][] versions = Token.split(version, 46);
        this.major = Token.toInt(versions[0]);
        this.minor = versions.length > 1 ? Token.toInt(versions[1]) : -1;
        this.patch = versions.length > 2 ? Token.toInt(versions[2]) : -1;
    }

    public boolean isCompatible(PkgVersion ver) {
        if (this.major != ver.major) {
            return false;
        }
        if (ver.minor == -1) {
            return true;
        }
        if (ver.patch == -1) {
            return this.minor == ver.minor;
        }
        return this.minor == ver.minor && this.patch == ver.patch;
    }

    @Override
    public int compareTo(PkgVersion ver) {
        return this.major != ver.major ? this.major - ver.major : (this.minor != ver.minor ? this.minor - ver.minor : this.patch - ver.patch);
    }
}

