/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.data.DataText;
import org.basex.data.ExprInfo;
import org.basex.data.FTPos;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.DOTData;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

public final class DOTSerializer
extends Serializer {
    private final boolean compact;
    private final PrintOutput out;
    private final ObjList<IntList> children = new ObjList();
    private final TokenBuilder tb = new TokenBuilder();
    private final IntList nodes = new IntList();
    private byte[] tag;
    private String color;
    private int level;
    private int count;

    public DOTSerializer(PrintOutput o, boolean c) throws IOException {
        this.out = o;
        this.compact = c;
        this.out.println("digraph BaseXAlgebra {\n  node [shape=box style=bold width=0 height=0];\n  node [fontsize=12 fontname=\"Tahoma\"];");
    }

    @Override
    public void openResult() {
    }

    @Override
    public void closeResult() {
    }

    @Override
    protected void start(byte[] t) {
        this.tag = t;
        this.tb.reset();
    }

    @Override
    public void attribute(byte[] n, byte[] v) {
        this.tb.addExt("\\n%: %", DOTData.name(Token.string(n)), v);
    }

    @Override
    public void empty() throws IOException {
        this.finish();
        this.close(this.tag);
    }

    @Override
    public void finish() throws IOException {
        byte[] attr = this.tb.finish();
        if (this.color == null) {
            this.color = DOTData.color(Token.string(this.tag));
        }
        if (this.color == null) {
            this.color = attr.length == 0 ? "303030" : "909090";
        }
        this.print(Token.concat(this.tag, attr), this.color);
        ++this.level;
    }

    @Override
    public void close(byte[] t) throws IOException {
        if (--this.level < 0) {
            return;
        }
        int c = this.nodes.get(this.level);
        IntList il = this.child(this.level);
        int is = il.size();
        int i = 0;
        while (i < is) {
            this.out.println(Util.info("  node% -> node%;", c, il.get(i)));
            ++i;
        }
        this.color = null;
        il.reset();
    }

    @Override
    public void text(byte[] t) throws IOException {
        this.finishElement();
        this.print(Token.norm(t), "6666FF");
    }

    @Override
    public void text(byte[] b, FTPos ftp) throws IOException {
        this.text(b);
    }

    @Override
    public void comment(byte[] t) throws IOException {
        this.finishElement();
        this.print(new TokenBuilder(DataText.COM1).add(Token.norm(t)).add(DataText.COM2).finish(), "3366FF");
    }

    @Override
    public void pi(byte[] n, byte[] v) throws IOException {
        this.finishElement();
        this.print(new TokenBuilder(DataText.PI1).add(n).add(Token.SPACE).add(v).add(DataText.PI2).finish(), "3399FF");
    }

    @Override
    public void item(byte[] t) throws IOException {
        this.finishElement();
        this.print(Token.norm(t), "3366CC");
    }

    @Override
    public void cls() throws IOException {
        this.out.println("}");
    }

    private void print(byte[] t, String col) throws IOException {
        String txt = Token.string(Token.chop(t, 60)).replaceAll("\"|\\r|\\n", "'");
        if (this.compact) {
            txt = txt.replaceAll("\\\\n\\w+:", "\\\\n");
        }
        this.out.println(Util.info("  node% [label=\"%\" color=\"#%\"];", this.count, txt, col));
        this.nodes.set(this.level, this.count);
        if (this.level > 0) {
            this.child(this.level - 1).add(this.count);
        }
        ++this.count;
    }

    private IntList child(int i) {
        while (i >= this.children.size()) {
            this.children.add(new IntList());
        }
        return this.children.get(i);
    }

    @Override
    protected byte[] name(ExprInfo expr) {
        this.color = DOTData.color(expr);
        return Token.token(DOTData.name(expr));
    }
}

