/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ForLet;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.ft.Scoring;

public final class Let
extends ForLet {
    final boolean score;

    public Let(InputInfo ii, Expr e, Var v) {
        this(ii, e, v, false);
    }

    public Let(InputInfo ii, Expr e, Var v, boolean s) {
        super(ii, e, v);
        this.score = s;
    }

    @Override
    public Let comp(QueryContext ctx) throws QueryException {
        this.expr = this.checkUp(this.expr, ctx).comp(ctx);
        this.type = SeqType.ITEM;
        this.size = 1L;
        this.var.size = this.expr.size();
        this.var.ret = this.score ? SeqType.DBL : this.expr.type();
        ctx.vars.add(this.var);
        return this;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        final Var vr = this.var.copy();
        return new Iter(){
            private int vs;
            private boolean more;

            @Override
            public Item next() throws QueryException {
                if (!this.more) {
                    Value v;
                    this.vs = ctx.vars.size();
                    if (Let.this.score) {
                        Item it;
                        double s = 0.0;
                        int c = 0;
                        Iter ir = ctx.iter(Let.this.expr);
                        while ((it = ir.next()) != null) {
                            s += it.score();
                            ++c;
                        }
                        v = Dbl.get(Scoring.let(s, c));
                    } else {
                        v = Let.this.expr.value(ctx);
                    }
                    ctx.vars.add(vr.bind(v, ctx));
                    this.more = true;
                    return Bln.TRUE;
                }
                this.reset();
                return null;
            }

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public Item get(long i) throws QueryException {
                this.reset();
                return this.next();
            }

            @Override
            public boolean reset() {
                if (this.more) {
                    ctx.vars.reset(this.vs);
                    this.more = false;
                }
                return true;
            }
        };
    }

    @Override
    boolean simple(boolean one) {
        return !this.score;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{this.score ? Token.token("score") : QueryText.VAR, Token.token(this.var.toString())});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("let").append(' ');
        if (this.score) {
            sb.append("score").append(' ');
        }
        sb.append(this.var).append(' ').append(":=").append(' ').append(this.expr);
        return sb.toString();
    }

    @Override
    public boolean declares(Var v) {
        return this.var.is(v);
    }

    @Override
    public Var[] vars() {
        return new Var[]{this.var};
    }
}

