/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.MouseInputAdapter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.GraphicsDragHandle;
import nl.mpi.kinnate.svg.RelationDragHandle;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.SvgElementEditor;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseListenerSvg
extends MouseInputAdapter
implements EventListener {
    private Cursor preDragCursor;
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private Point startDragPoint = null;
    private boolean mouseActionOnNode = false;
    private boolean mouseActionIsPopupTrigger = false;
    private boolean mouseActionIsDrag = false;
    private UniqueIdentifier entityToToggle = null;
    private HashMap<UniqueIdentifier, SvgElementEditor> shownGraphicsEditors;
    private MessageDialogHandler dialogHandler;
    private SessionStorage sessionStorage;
    private EntityCollection entityCollection;

    public MouseListenerSvg(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection) {
        this.kinDiagramPanel = kinDiagramPanel;
        this.graphPanel = graphPanel;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.entityCollection = entityCollection;
        this.shownGraphicsEditors = new HashMap();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.graphPanel.svgUpdateHandler.relationDragHandle != null) {
            this.graphPanel.svgUpdateHandler.updateDragRelation(me.getPoint().x, me.getPoint().y);
        } else {
            if (this.startDragPoint != null) {
                if (this.graphPanel.selectedGroupId.size() > 0) {
                    this.checkSelectionClearRequired(me);
                }
                if (this.graphPanel.selectedGroupId.size() > 0) {
                    this.graphPanel.svgCanvas.setCursor(Cursor.getPredefinedCursor(13));
                    this.graphPanel.svgUpdateHandler.updateDragNode(me.getPoint().x - this.startDragPoint.x, me.getPoint().y - this.startDragPoint.y);
                } else {
                    this.graphPanel.svgUpdateHandler.dragCanvas(me.getPoint().x - this.startDragPoint.x, me.getPoint().y - this.startDragPoint.y);
                }
                this.mouseActionIsDrag = true;
            } else {
                this.graphPanel.svgUpdateHandler.startDrag();
            }
            this.startDragPoint = me.getPoint();
        }
    }

    private void checkSelectionClearRequired(MouseEvent me) {
        boolean shiftDown = me.isShiftDown();
        if (!(shiftDown || this.mouseActionIsPopupTrigger || this.mouseActionOnNode || me.getButton() != 1)) {
            System.out.println("Clear selection");
            this.graphPanel.selectedGroupId.clear();
            this.updateSelectionDisplay();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.graphPanel.svgCanvas.setCursor(this.preDragCursor);
        if (this.mouseActionIsDrag) {
            this.graphPanel.svgUpdateHandler.updateCanvasSize();
        }
        this.startDragPoint = null;
        if (!this.mouseActionIsDrag && this.entityToToggle != null) {
            this.graphPanel.selectedGroupId.remove(this.entityToToggle);
            this.entityToToggle = null;
            this.updateSelectionDisplay();
        }
        this.checkSelectionClearRequired(me);
        this.mouseActionOnNode = false;
        if (this.graphPanel.svgUpdateHandler.relationDragHandle != null) {
            if (this.graphPanel.svgUpdateHandler.relationDragHandle.targetIdentifier != null) {
                try {
                    DataTypes.RelationType relationType = DataTypes.getOpposingRelationType(this.graphPanel.svgUpdateHandler.relationDragHandle.getRelationType());
                    UniqueIdentifier[] changedIdentifiers = new RelationLinker(this.sessionStorage, this.dialogHandler, this.entityCollection).linkEntities(this.graphPanel.svgUpdateHandler.relationDragHandle.targetIdentifier, this.graphPanel.getSelectedIds(), relationType, this.graphPanel.svgUpdateHandler.relationDragHandle.getDataCategory(), this.graphPanel.svgUpdateHandler.relationDragHandle.getDisplayName());
                    this.kinDiagramPanel.entityRelationsChanged(changedIdentifiers);
                }
                catch (ImportException exception) {
                    this.dialogHandler.addMessageDialogToQueue("Failed to create relation: " + exception.getMessage(), "Drag Relation");
                }
            }
            this.graphPanel.svgUpdateHandler.relationDragHandle = null;
            this.updateSelectionDisplay();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseActionIsDrag = false;
        this.mouseActionIsPopupTrigger = e.isPopupTrigger();
    }

    @Override
    public void handleEvent(Event evt) {
        if (this.graphPanel.dataStoreSvg.graphData == null) {
            if (this.dialogHandler.showConfirmDialogBox("The diagram needs to be recalculated before it can be interacted with.\nRecalculate now?", "Recalculate Diagram")) {
                this.kinDiagramPanel.drawGraph();
            }
            return;
        }
        this.mouseActionOnNode = true;
        boolean shiftDown = false;
        if (evt instanceof DOMMouseEvent) {
            shiftDown = ((DOMMouseEvent)evt).getShiftKey();
        }
        System.out.println("dom mouse event: " + evt.getCurrentTarget());
        Element currentDraggedElement = (Element)((Object)evt.getCurrentTarget());
        this.preDragCursor = this.graphPanel.svgCanvas.getCursor();
        String handleTypeString = currentDraggedElement.getAttribute("handletype");
        String targetIdString = currentDraggedElement.getAttribute("target");
        if (targetIdString != null && targetIdString.length() > 0 || handleTypeString != null && handleTypeString.length() > 0) {
            if (evt instanceof DOMMouseEvent) {
                Element entityGroup = this.graphPanel.doc.getElementById("EntityGroup");
                SVGMatrix entityGroupMatrix = ((SVGLocatable)entityGroup).getCTM();
                SVGMatrix entityMatrix = ((SVGLocatable)currentDraggedElement).getCTM();
                float xTranslate = entityMatrix.getE() - entityGroupMatrix.getE();
                float yTranslate = entityMatrix.getF() - entityGroupMatrix.getF();
                AffineTransform affineTransform = this.graphPanel.svgCanvas.getRenderingTransform();
                if (targetIdString != null && targetIdString.length() > 0) {
                    this.graphPanel.svgUpdateHandler.relationDragHandle = new GraphicsDragHandle(this.graphPanel.doc.getElementById(targetIdString), currentDraggedElement, (Element)currentDraggedElement.getParentNode().getFirstChild(), Float.valueOf(currentDraggedElement.getAttribute("cx")).floatValue(), Float.valueOf(currentDraggedElement.getAttribute("cy")).floatValue(), ((DOMMouseEvent)evt).getClientX(), ((DOMMouseEvent)evt).getClientY(), affineTransform.getScaleX());
                } else {
                    RelationTypeDefinition customTypeDefinition = null;
                    DataTypes.RelationType relationType = null;
                    if (handleTypeString.startsWith("custom:")) {
                        int typeHashCode = Integer.parseInt(handleTypeString.substring("custom:".length()));
                        for (RelationTypeDefinition currentDefinition : this.graphPanel.dataStoreSvg.getRelationTypeDefinitions()) {
                            if (currentDefinition.hashCode() != typeHashCode) continue;
                            customTypeDefinition = currentDefinition;
                            break;
                        }
                    } else {
                        relationType = DataTypes.RelationType.valueOf(handleTypeString);
                    }
                    this.graphPanel.svgUpdateHandler.relationDragHandle = new RelationDragHandle(customTypeDefinition, relationType, Float.valueOf(currentDraggedElement.getAttribute("cx")).floatValue() + xTranslate, Float.valueOf(currentDraggedElement.getAttribute("cy")).floatValue() + yTranslate, ((DOMMouseEvent)evt).getClientX(), ((DOMMouseEvent)evt).getClientY(), affineTransform.getScaleX());
                }
            }
        } else {
            String attributeString = currentDraggedElement.getAttribute("id");
            try {
                UniqueIdentifier entityIdentifier = new UniqueIdentifier(attributeString);
                System.out.println("entityPath: " + entityIdentifier.getAttributeIdentifier());
                boolean nodeAlreadySelected = this.graphPanel.selectedGroupId.contains(entityIdentifier);
                if (!shiftDown && !nodeAlreadySelected) {
                    System.out.println("Clear selection");
                    this.graphPanel.selectedGroupId.clear();
                    this.graphPanel.selectedGroupId.add(entityIdentifier);
                } else if (shiftDown && nodeAlreadySelected) {
                    this.entityToToggle = entityIdentifier;
                } else if (!nodeAlreadySelected) {
                    this.graphPanel.selectedGroupId.add(entityIdentifier);
                }
                this.updateSelectionDisplay();
            }
            catch (IdentifierException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                this.dialogHandler.addMessageDialogToQueue("Failed to read selection identifier, selection might not be correct", "Selection Highlight");
            }
        }
    }

    protected void updateSelectionDisplay() {
        this.graphPanel.svgUpdateHandler.updateSvgSelectionHighlights();
        if (this.graphPanel.metadataPanel != null) {
            this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
            ArrayList<UniqueIdentifier> remainingEditors = new ArrayList<UniqueIdentifier>(this.shownGraphicsEditors.keySet());
            ArrayList<EntityData> selectedEntities = new ArrayList<EntityData>();
            for (UniqueIdentifier currentSelectedId : this.graphPanel.selectedGroupId) {
                EntityData currentSelectedEntity;
                remainingEditors.remove(currentSelectedId);
                if (currentSelectedId.isGraphicsIdentifier()) {
                    if (this.shownGraphicsEditors.containsKey(currentSelectedId)) continue;
                    Element graphicsElement = this.graphPanel.doc.getElementById(currentSelectedId.getAttributeIdentifier());
                    SvgElementEditor elementEditor = new SvgElementEditor(this.graphPanel.svgCanvas.getUpdateManager(), graphicsElement);
                    this.graphPanel.metadataPanel.addTab("Graphics Editor", elementEditor);
                    this.shownGraphicsEditors.put(currentSelectedId, elementEditor);
                    continue;
                }
                if (currentSelectedId.isTransientIdentifier() || (currentSelectedEntity = this.graphPanel.getEntityForElementId(currentSelectedId)) == null) continue;
                selectedEntities.add(currentSelectedEntity);
                this.graphPanel.metadataPanel.addEntityDataNode(this.kinDiagramPanel, currentSelectedEntity);
            }
            for (UniqueIdentifier remainingIdentifier : remainingEditors) {
                this.graphPanel.metadataPanel.removeTab(this.shownGraphicsEditors.get(remainingIdentifier));
                this.shownGraphicsEditors.remove(remainingIdentifier);
            }
            this.graphPanel.metadataPanel.updateEditorPane();
        }
    }

    private void expandSelectionByRelations(int maxCount, EntityData currentEntity, HashSet<UniqueIdentifier> selectedIds, boolean addRecursively) {
        if (maxCount <= selectedIds.size()) {
            return;
        }
        for (EntityData alterNode : currentEntity.getVisiblyRelated()) {
            if (!alterNode.isVisible || selectedIds.contains(alterNode.getUniqueIdentifier())) continue;
            selectedIds.add(alterNode.getUniqueIdentifier());
            if (!addRecursively) continue;
            this.expandSelectionByRelations(maxCount, alterNode, selectedIds, addRecursively);
        }
    }

    public void performMenuAction(ActionCode commandCode) {
        System.out.println("commandCode: " + commandCode.name());
        boolean addRecursively = true;
        switch (commandCode) {
            case selectAll: {
                this.graphPanel.selectedGroupId.clear();
                for (EntityData currentEntity : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                    if (!currentEntity.isVisible || this.graphPanel.selectedGroupId.contains(currentEntity.getUniqueIdentifier())) continue;
                    this.graphPanel.selectedGroupId.add(currentEntity.getUniqueIdentifier());
                }
                break;
            }
            case expandSelection: {
                addRecursively = false;
            }
            case selectRelated: {
                HashSet<UniqueIdentifier> selectedIds = new HashSet<UniqueIdentifier>(this.graphPanel.selectedGroupId);
                for (EntityData currentEntity : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                    if (!currentEntity.isVisible || !this.graphPanel.selectedGroupId.contains(currentEntity.getUniqueIdentifier())) continue;
                    this.expandSelectionByRelations(this.graphPanel.dataStoreSvg.graphData.getDataNodes().length, currentEntity, selectedIds, addRecursively);
                }
                this.graphPanel.selectedGroupId.clear();
                this.graphPanel.selectedGroupId.addAll(selectedIds);
                break;
            }
            case deselectAll: {
                this.graphPanel.selectedGroupId.clear();
            }
        }
        this.updateSelectionDisplay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionCode {
        selectAll,
        selectRelated,
        expandSelection,
        deselectAll;

    }
}

