/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import nl.mpi.util.OurURL;

public class HashFromFile
extends Hashtable {
    private OurURL _url;
    private boolean _status = false;

    public HashFromFile(String urlstr) throws MalformedURLException, IOException {
        this(new OurURL(urlstr));
    }

    public HashFromFile(OurURL url) throws IOException {
        if (url != null) {
            this._status = this.processRefListFile(url);
        }
        this._url = url;
    }

    public HashFromFile(HashFromFile hash) {
        super(hash);
        this._status = hash.status();
        try {
            this._url = new OurURL(hash.getURL().toURL());
        }
        catch (MalformedURLException mue) {
            this._url = null;
        }
    }

    public String toString() {
        return this._url.toString();
    }

    public boolean status() {
        return this._status;
    }

    private OurURL getURL() {
        return this._url;
    }

    private boolean processRefListFile(OurURL url) throws IOException {
        String line;
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String value = st.nextToken();
                this.put(key, value);
            }
        }
        return true;
    }

    public void print() {
        Enumeration e = this.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            System.out.println(i + " " + p + " " + this.get(p));
            ++i;
        }
    }
}

