/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.util.ArrayList;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.ImportLineStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomLineStructure
extends ImportLineStructure {
    public GedcomLineStructure(String lineString, ArrayList<String> gedcomLevelStrings) throws ImportException {
        super(lineString, gedcomLevelStrings);
        this.isFileHeader = lineString.startsWith("0 HEAD");
        String[] lineParts = lineString.split(" ", 3);
        this.gedcomLevel = Integer.parseInt(lineParts[0]);
        if (this.isFileHeader) {
            this.currentID = lineParts[1];
            this.addFieldEntry(lineParts[1], null);
        } else if (!this.isFileHeader && this.gedcomLevel == 0) {
            this.currentID = lineParts[1];
            if (lineParts.length > 2) {
                this.setType(lineParts[2]);
                if (!this.currentID.startsWith("@") || !this.currentID.endsWith("@")) {
                    throw new ImportException("Incorrect gedcom identifier format: " + this.currentID);
                }
            }
        } else if (lineParts.length > 2) {
            this.addFieldEntry(lineParts[1], lineParts[2]);
        } else {
            this.addFieldEntry(lineParts[1], "");
        }
        while (gedcomLevelStrings.size() > this.gedcomLevel) {
            gedcomLevelStrings.remove(gedcomLevelStrings.size() - 1);
        }
        gedcomLevelStrings.add(lineParts[1]);
    }

    private void setType(String getdomType) {
        if (getdomType.equals("NOTE")) {
            this.entityType = "Gedcom Note";
        } else if (getdomType.equals("FAM")) {
            this.entityType = "Gedcom Family Group";
        } else if (!getdomType.equals("INDI")) {
            this.entityType = getdomType.equals("OBJE") ? "Resource File" : (getdomType.equals("REPO") ? "Repository" : (getdomType.equals("SUBN") ? "Submission" : (getdomType.equals("SOUR") ? "Source" : (getdomType.equals("SUBM") ? "Submitter" : getdomType))));
        }
    }

    @Override
    public boolean isContinueLine() {
        return this.hasCurrentField() && this.getCurrentField().currentName.equals("CONC");
    }

    @Override
    public boolean isContinueLineBreak() {
        return this.hasCurrentField() && this.getCurrentField().currentName.equals("CONT");
    }

    @Override
    public boolean isEndOfFileMarker() {
        return this.currentID != null && this.currentID.equals("TRLR");
    }

    @Override
    public boolean isRelation() {
        return this.hasCurrentField() && this.getCurrentField().lineContents != null && this.getCurrentField().lineContents.startsWith("@") && this.getCurrentField().lineContents.endsWith("@");
    }
}

