/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.gui.NonEditableDefaultTableModel;

public class CertPanel
extends JPanel {
    public CertPanel(CAHttps cAHttps) throws KeyStoreException {
        X509Certificate x509Certificate;
        if (cAHttps == null) {
            JLabel jLabel = new JLabel("<html>CA object does not exist.<P>Cannot show any certificate information.</html>");
            this.add(jLabel);
            return;
        }
        try {
            x509Certificate = cAHttps.getCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException("CertPanel: " + keyStoreException.getMessage());
        }
        if (x509Certificate == null) {
            JLabel jLabel = new JLabel("<html>CA object exists, but its certificate is (still) empty.<P>Probably need to initialize the CA object or store a certificate</html>");
            jLabel.setBackground(Color.white);
            this.setBackground(Color.white);
            this.add(jLabel);
            return;
        }
        NonEditableDefaultTableModel nonEditableDefaultTableModel = new NonEditableDefaultTableModel();
        nonEditableDefaultTableModel.setColumnIdentifiers(new String[]{"Attribute", "Value"});
        nonEditableDefaultTableModel.addRow(new String[]{"Issuer", x509Certificate.getIssuerX500Principal().toString()});
        nonEditableDefaultTableModel.addRow(new String[]{"Subject", x509Certificate.getSubjectX500Principal().toString()});
        nonEditableDefaultTableModel.addRow(new String[]{"Valid from", x509Certificate.getNotBefore().toString()});
        Date date = x509Certificate.getNotAfter();
        String string = date.toString();
        String string2 = null;
        string2 = date.getTime() < new Date().getTime() ? "<HTML><FONT color=\"red\"><I>" + string + "</I></FONT></HTML>" : string;
        nonEditableDefaultTableModel.addRow(new String[]{"Valid till", string2});
        nonEditableDefaultTableModel.addRow(new String[]{"Version", Integer.toString(x509Certificate.getVersion())});
        nonEditableDefaultTableModel.addRow(new String[]{"Signature algorithm", x509Certificate.getSigAlgName()});
        nonEditableDefaultTableModel.addRow(new String[]{"Serialnumber", CAHttps.getSerialString(x509Certificate.getSerialNumber())});
        JTable jTable = new JTable(nonEditableDefaultTableModel);
        jTable.setFocusable(false);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(333);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(667);
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.width = (int)((double)dimension.width * 1.2);
        dimension.height = jTable.getRowHeight() * nonEditableDefaultTableModel.getRowCount();
        jTable.setPreferredScrollableViewportSize(dimension);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Certificate Information"));
        this.add(Box.createRigidArea(new Dimension(0, jTable.getRowHeight() / 2)));
        this.add(new JScrollPane(jTable));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
    }
}

