/*
 * Decompiled with CFR 0.152.
 */
package net.handle.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.handle.awt.AwtUtil;
import net.handle.awt.TextPanel;

public class GenericDialog
extends JDialog
implements ActionListener {
    public static final int ANSWER_YES = 0;
    public static final int ANSWER_NO = 1;
    public static final int ANSWER_CANCEL = 2;
    public static final int QUESTION_OK = 0;
    public static final int QUESTION_YES_NO = 1;
    public static final int QUESTION_YES_NO_CANCEL = 2;
    public static final int QUESTION_OK_CANCEL = 3;
    private JButton yesButton = null;
    private JButton noButton = null;
    private JButton cancelButton = null;
    private int answer = 2;

    public GenericDialog(String title, Component c, int questionType, Frame f) {
        this(title, c, questionType, f, true);
    }

    public GenericDialog(String title, Component c, int questionType, Frame f, boolean modal) {
        super(f, title, modal);
        Point ploc;
        Dimension psz;
        JPanel p = new JPanel(new GridBagLayout());
        if (questionType == 2) {
            this.yesButton = new JButton("Yes");
            this.noButton = new JButton("No");
            this.cancelButton = new JButton("Cancel");
        } else if (questionType == 1) {
            this.yesButton = new JButton("Yes");
            this.noButton = new JButton("No");
        } else if (questionType == 3) {
            this.yesButton = new JButton("Ok");
            this.cancelButton = new JButton("Cancel");
        } else {
            this.yesButton = new JButton("Ok");
        }
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.add(c, AwtUtil.getConstraints(1, 1, 1.0, 1.0, 1, 1, true, true));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        int x = 0;
        if (this.yesButton != null) {
            buttonPanel.add((Component)this.yesButton, AwtUtil.getConstraints(x++, 0, 1.0, 1.0, 1, 1, false, false));
            this.yesButton.addActionListener(this);
        }
        if (this.noButton != null) {
            buttonPanel.add((Component)this.noButton, AwtUtil.getConstraints(x++, 0, 1.0, 1.0, 1, 1, false, false));
            this.noButton.addActionListener(this);
        }
        if (this.cancelButton != null) {
            buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(x++, 0, 1.0, 1.0, 1, 1, false, false));
            this.cancelButton.addActionListener(this);
        }
        p.add((Component)buttonPanel, AwtUtil.getConstraints(0, 3, 0.0, 0.0, 3, 1, true, true));
        this.setContentPane(p);
        this.pack();
        Dimension prefSz = this.getPreferredSize();
        this.setSize(Math.max(Math.min(prefSz.width, 800), 50), Math.max(Math.min(prefSz.height, 700), 50));
        Dimension sz = this.getSize();
        if (f != null) {
            psz = f.getSize();
            ploc = f.getLocationOnScreen();
        } else {
            psz = this.getToolkit().getScreenSize();
            ploc = new Point(0, 0);
        }
        this.setLocation(ploc.x + (psz.width / 2 - sz.width / 2), ploc.y + (psz.height / 2 - sz.height / 2));
    }

    public int getAnswer() {
        return this.answer;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            this.answer = src == this.yesButton ? 0 : (src == this.noButton ? 1 : 2);
            this.setVisible(false);
            this.dispose();
        }
    }

    public static int askQuestion(String title, String question, int questionType, Component parentComp) {
        GenericDialog win = new GenericDialog(title, new TextPanel(question), questionType, AwtUtil.getFrame(parentComp), questionType != 0);
        win.setVisible(true);
        return win.getAnswer();
    }

    public static int showDialog(String title, Component comp, int questionType, Component parentComp) {
        GenericDialog win = new GenericDialog(title, comp, questionType, AwtUtil.getFrame(parentComp), questionType != 0);
        win.setVisible(true);
        return win.getAnswer();
    }
}

