/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.Util;

public class SiteInfo {
    public static final byte HASH_TYPE_BY_NA = 0;
    public static final byte HASH_TYPE_BY_ID = 1;
    public static final byte HASH_TYPE_BY_ALL = 2;
    public static final short PRIMARY_SITE = 128;
    public static final short MULTI_PRIMARY = 64;
    public int dataFormatVersion = 0;
    public int serialNumber;
    public byte majorProtocolVersion = (byte)2;
    public byte minorProtocolVersion = 1;
    public boolean isPrimary;
    public boolean multiPrimary;
    public boolean isRoot = false;
    public long responseTime;
    public byte hashOption = (byte)2;
    public byte[] hashFilter;
    public ServerInfo[] servers;
    public Attribute[] attributes;
    private MessageDigest md5 = null;

    public SiteInfo() {
    }

    public SiteInfo(int siteVersion, boolean isPrimary, boolean isMultiPrimary, byte hashingOption, String siteDescription, InetAddress listenAddr, int port, int httpPort, File pubKeyFile, boolean disableUDP) throws IOException {
        this.serialNumber = siteVersion;
        this.isPrimary = isPrimary;
        this.multiPrimary = isMultiPrimary;
        this.hashOption = hashingOption;
        if (siteDescription != null) {
            this.attributes = new Attribute[]{new Attribute(Util.encodeString("desc"), Util.encodeString(siteDescription))};
        }
        this.servers = new ServerInfo[]{new ServerInfo()};
        this.servers[0].serverId = 1;
        byte[] addr1 = listenAddr.getAddress();
        byte[] addr2 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            addr2[i] = 0;
        }
        System.arraycopy(addr1, 0, addr2, addr2.length - addr1.length, addr1.length);
        this.servers[0].ipAddress = addr2;
        byte[] pkbuf = new byte[(int)pubKeyFile.length()];
        FileInputStream pubKeyIn = new FileInputStream(pubKeyFile);
        int r = 0;
        for (int n = 0; n < pkbuf.length && (r = pubKeyIn.read(pkbuf, n, pkbuf.length - n)) >= 0; n += r) {
        }
        pubKeyIn.close();
        this.servers[0].publicKey = pkbuf;
        this.servers[0].interfaces = disableUDP ? new Interface[]{new Interface(3, 1, port), new Interface(3, 2, httpPort)} : new Interface[]{new Interface(3, 1, port), new Interface(2, 0, port), new Interface(3, 2, httpPort)};
    }

    public byte[] getAttribute(byte[] attribute) {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!Util.equals(attribute, this.attributes[i].name)) continue;
                return this.attributes[i].value;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getHandleHash(byte[] handle, int hashOption) throws HandleException {
        void var2_2;
        switch (hashOption) {
            case 0: {
                byte[] hashPart = Util.upperCaseInPlace(Util.getNAPart(handle));
                break;
            }
            case 1: {
                byte[] hashPart = Util.upperCaseInPlace(Util.getIDPart(handle));
                break;
            }
            case 2: {
                byte[] hashPart = Util.upperCase(handle);
                break;
            }
            default: {
                throw new HandleException(0, "Unknown hash method: " + hashOption);
            }
        }
        byte[] digest = Util.doMD5Digest((byte[])var2_2);
        return Math.abs(Encoder.readInt(digest, digest.length - 4));
    }

    public final int determineServerNum(byte[] handle) throws HandleException {
        return SiteInfo.determineServerNum(handle, this.hashOption, this.servers.length);
    }

    public static final int determineServerNum(byte[] handle, int hashOption, int numServers) throws HandleException {
        return SiteInfo.getHandleHash(handle, hashOption) % numServers;
    }

    public ServerInfo determineServer(byte[] handle) throws HandleException {
        return this.servers[SiteInfo.determineServerNum(handle, this.hashOption, this.servers.length)];
    }

    public String toString() {
        String servList = "";
        if (this.servers != null) {
            servList = servList + this.servers[0];
            for (int i = 1; i < this.servers.length; ++i) {
                servList = servList + ", " + this.servers[i];
            }
        }
        return "version: " + this.majorProtocolVersion + '.' + this.minorProtocolVersion + "; serial:" + this.serialNumber + "; primary:" + (this.isPrimary ? "y; " : "n; ") + "servers=[" + servList + "]";
    }

    public static final void main(String[] argv) throws Exception {
        for (int i = 0; i < argv.length; ++i) {
            String hdl = argv[i];
            System.out.println("Handle: " + hdl);
            int hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 0);
            System.out.println("  hash by prefix: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
            hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 1);
            System.out.println("  hash by suffix: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
            hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 2);
            System.out.println("  hash by all: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
        }
    }
}

