/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.plugin.PluginDialogHandler;
import nl.mpi.kinnate.entityindexer.QueryException;
import nl.mpi.kinnate.plugins.export.GedcomExport;
import nl.mpi.kinnate.plugins.export.ui.FieldsPanel;
import nl.mpi.kinnate.plugins.export.ui.ResultsPanel;

public class ExportPanel
extends JPanel
implements ActionListener {
    PluginDialogHandler arbilWindowManager;
    GedcomExport gedcomExport;
    FieldsPanel fieldsPanel;
    JTabbedPane outerTabbedPane;

    public ExportPanel(PluginDialogHandler arbilWindowManager, GedcomExport gedcomExport, JTabbedPane jTabbedPane) {
        this.arbilWindowManager = arbilWindowManager;
        this.gedcomExport = gedcomExport;
        this.outerTabbedPane = jTabbedPane;
        this.fieldsPanel = new FieldsPanel(gedcomExport);
        this.fieldsPanel.populateFields();
        this.setLayout(new BorderLayout());
        this.add((Component)this.fieldsPanel, "Center");
        JButton exportButton = new JButton("Export");
        exportButton.addActionListener(this);
        this.add((Component)exportButton, "Last");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.fieldsPanel.namesAreUnique()) {
                final String queryString = this.gedcomExport.generateExport(this.fieldsPanel.getSelectedFieldNames(), this.fieldsPanel.getSelectedFieldPaths());
                this.outerTabbedPane.add("Query Text", new JScrollPane(new JTextArea(queryString)));
                SwingUtilities.invokeLater(new Thread(){

                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            String resultsString = ExportPanel.this.gedcomExport.generateExport(queryString);
                            long queryMils = System.currentTimeMillis() - startTime;
                            String queryTimeString = "Query time: " + queryMils + "ms";
                            ResultsPanel resultsPanel = new ResultsPanel();
                            ExportPanel.this.outerTabbedPane.add("Results Text", new JScrollPane(new JTextArea(resultsString)));
                            ExportPanel.this.outerTabbedPane.add("Results Table", resultsPanel);
                            resultsPanel.updateTable(resultsString);
                            ExportPanel.this.revalidate();
                            ExportPanel.this.repaint();
                        }
                        catch (QueryException exception) {
                            ExportPanel.this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Generate Table");
                        }
                    }
                });
            } else {
                this.arbilWindowManager.addMessageDialogToQueue("The chosen field names are not unique", "Export Error");
            }
        }
        catch (QueryException exception) {
            this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Export Error");
        }
    }
}

