/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GedcomLineStructure;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.ImportLineStructure;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityDate;
import nl.mpi.kinnate.kindata.EntityDateException;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GedcomImporter
extends EntityImporter
implements GenericImporter {
    public GedcomImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal, sessionStorage);
    }

    @Override
    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".ged") || inputFileString.toLowerCase().endsWith(".gedcom");
    }

    protected ImportTranslator getImportTranslator() {
        ImportTranslator importTranslator = new ImportTranslator(true);
        importTranslator.addTranslationEntry("SEX", "F", "Gender", "Female");
        importTranslator.addTranslationEntry("SEX", "M", "Gender", "Male");
        importTranslator.addTranslationEntry("NAME", null, "Name", null);
        importTranslator.addTranslationEntry("chro", null, "Chromosome", null);
        return importTranslator;
    }

    protected ImportLineStructure getImportLineStructure(String lineString, ArrayList<String> gedcomLevelStrings) throws ImportException {
        return new GedcomLineStructure(lineString, gedcomLevelStrings);
    }

    @Override
    public URI[] importFile(InputStreamReader inputStreamReader, String profileId) throws IOException, ImportException {
        String strLine;
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        HashMap socialGroupRoleMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ImportTranslator importTranslator = this.getImportTranslator();
        ArrayList<String> gedcomLevelStrings = new ArrayList<String>();
        EntityDocument currentEntity = null;
        EntityDocument fileHeaderEntity = null;
        boolean skipFileEntity = false;
        String currentEntityType = "";
        while ((strLine = bufferedReader.readLine()) != null) {
            ImportLineStructure lineStructure;
            if (skipFileEntity) {
                skipFileEntity = false;
                while ((strLine = bufferedReader.readLine()) != null && !strLine.startsWith("0")) {
                }
            }
            if ((lineStructure = this.getImportLineStructure(strLine, gedcomLevelStrings)).isIncompleteLine()) {
                this.appendToTaskOutput("Incomplete line found");
                continue;
            }
            System.out.println(strLine);
            boolean lastFieldContinued = false;
            if (lineStructure.isContinueLineBreak()) {
                currentEntity.appendValueToLast(currentEntityType, "\n" + lineStructure.getLineContents());
                lastFieldContinued = true;
            } else if (lineStructure.isContinueLine()) {
                currentEntity.appendValueToLast(currentEntityType, lineStructure.getLineContents());
                lastFieldContinued = true;
            }
            if (!lastFieldContinued) {
                if (lineStructure.getGedcomLevel() == 0) {
                    if (lineStructure.isEndOfFileMarker()) {
                        this.appendToTaskOutput("End of file found");
                    } else {
                        String typeString = lineStructure.hasLineContents() ? profileId : profileId;
                        currentEntity = this.getEntityDocument(createdNodes, typeString, lineStructure.getCurrentID(), importTranslator);
                        currentEntityType = lineStructure.entityType;
                        if (lineStructure.isFileHeader()) {
                            fileHeaderEntity = currentEntity;
                            currentEntity.insertValue("Type", "Imported File Header");
                            if (lineStructure.hasLineContents()) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                            } else {
                                currentEntity.appendValue(lineStructure.getCurrentName(), null, lineStructure.getGedcomLevel());
                            }
                        } else {
                            fileHeaderEntity.entityData.addRelatedNode(currentEntity.entityData, DataTypes.RelationType.other, null, null, null, "source");
                            if (lineStructure.getEntityType() != null) {
                                currentEntity.insertValue("Type", lineStructure.getEntityType());
                            }
                            if (lineStructure.hasLineContents()) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                            }
                        }
                    }
                    while (lineStructure.hasCurrentField()) {
                        if (lineStructure.hasLineContents()) {
                            currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                        }
                        lineStructure.moveToNextField();
                    }
                } else {
                    while (lineStructure.hasCurrentField()) {
                        if (!lineStructure.hasLineContents()) {
                            currentEntity.appendValue(lineStructure.getCurrentName(), null, lineStructure.getGedcomLevel());
                        } else {
                            boolean notConsumed = true;
                            if (gedcomLevelStrings.size() == 3 && gedcomLevelStrings.get(2).equals("DATE") && (gedcomLevelStrings.get(1).equals("BIRT") || gedcomLevelStrings.get(1).equals("DEAT"))) {
                                String dateText = lineStructure.getLineContents().trim();
                                String qualifierString = null;
                                String yearString = null;
                                String monthString = null;
                                String dayString = null;
                                for (String prefixString : new String[]{"ABT", "BEF", "AFT"}) {
                                    if (!dateText.startsWith(prefixString)) continue;
                                    qualifierString = prefixString.toLowerCase();
                                    dateText = dateText.substring(prefixString.length()).trim();
                                }
                                try {
                                    SimpleDateFormat formatter;
                                    if (dateText.matches("[0-9]{1,4}")) {
                                        while (dateText.length() < 4) {
                                            dateText = "0" + dateText;
                                        }
                                        yearString = dateText;
                                    } else if (dateText.matches("[a-zA-Z]{3} [0-9]{4}")) {
                                        formatter = new SimpleDateFormat("MMM yyyy");
                                        Date parsedDate = formatter.parse(dateText);
                                        monthString = new SimpleDateFormat("MM").format(parsedDate);
                                        yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                    } else {
                                        formatter = new SimpleDateFormat("dd MMM yyyy");
                                        Date parsedDate = formatter.parse(dateText);
                                        dayString = new SimpleDateFormat("dd").format(parsedDate);
                                        monthString = new SimpleDateFormat("MM").format(parsedDate);
                                        yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                    }
                                    EntityDate entityDate = new EntityDate(yearString, monthString, dayString, qualifierString);
                                    if (gedcomLevelStrings.get(1).equals("BIRT")) {
                                        currentEntity.insertValue("DateOfBirth", entityDate.getDateString());
                                    } else {
                                        currentEntity.insertValue("DateOfDeath", entityDate.getDateString());
                                    }
                                    notConsumed = false;
                                }
                                catch (ParseException exception) {
                                    System.out.println(exception.getMessage());
                                    this.appendToTaskOutput("Failed to parse date: " + strLine);
                                }
                                catch (EntityDateException exception) {
                                    System.out.println(exception.getMessage());
                                    this.appendToTaskOutput("Failed to parse date: " + strLine + " " + exception.getMessage());
                                }
                            }
                            if (gedcomLevelStrings.size() == 2 && (gedcomLevelStrings.get(1).equals("SEX") || gedcomLevelStrings.get(1).equals("NAME"))) {
                                if (lineStructure.getGedcomLevel() == 1) {
                                    currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                                } else {
                                    currentEntity.appendValue(lineStructure.getCurrentName(), lineStructure.getLineContents(), lineStructure.getGedcomLevel());
                                }
                                notConsumed = false;
                            }
                            if (gedcomLevelStrings.size() == 2 && gedcomLevelStrings.get(1).equals("chro") && lineStructure.getGedcomLevel() == 1) {
                                currentEntity.insertValue(lineStructure.getCurrentName(), lineStructure.getLineContents());
                                notConsumed = false;
                            }
                            if (gedcomLevelStrings.get(gedcomLevelStrings.size() - 1).equals("FILE")) {
                                if (lineStructure.getLineContents().toLowerCase().startsWith("mailto:")) {
                                    currentEntity.insertValue("mailto", lineStructure.getLineContents());
                                } else {
                                    try {
                                        URI resolvedUri = "jar".equals(this.inputFileUri.getScheme()) ? URI.create("http://example.net/example/files/not/included/demo").resolve(lineStructure.getLineContents()) : this.inputFileUri.resolve(lineStructure.getLineContents());
                                        currentEntity.entityData.addArchiveLink(resolvedUri);
                                        notConsumed = false;
                                    }
                                    catch (IllegalArgumentException exception) {
                                        this.appendToTaskOutput("Unsupported File Path: " + lineStructure.getLineContents());
                                    }
                                }
                            }
                            if (lineStructure.isRelation()) {
                                if (lineStructure.getCurrentName().equals("FAMS") || lineStructure.getCurrentName().equals("FAMC") || lineStructure.getCurrentName().equals("HUSB") || lineStructure.getCurrentName().equals("WIFE") || lineStructure.getCurrentName().equals("CHIL")) {
                                    EntityData socialGroupMember;
                                    UniqueIdentifier socialGroupIdentifier;
                                    if (lineStructure.getCurrentName().equals("FAMS") || lineStructure.getCurrentName().equals("FAMC")) {
                                        socialGroupIdentifier = this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData.getUniqueIdentifier();
                                        socialGroupMember = currentEntity.entityData;
                                    } else {
                                        socialGroupIdentifier = currentEntity.entityData.getUniqueIdentifier();
                                        socialGroupMember = this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData;
                                    }
                                    if (!socialGroupRoleMap.containsKey(socialGroupIdentifier)) {
                                        socialGroupRoleMap.put(socialGroupIdentifier, new ArrayList());
                                    }
                                    ((ArrayList)socialGroupRoleMap.get(socialGroupIdentifier)).add(new SocialMemberElement(lineStructure.getCurrentName(), socialGroupMember));
                                }
                                String customType = lineStructure.getCurrentName();
                                DataTypes.RelationType targetRelation = DataTypes.RelationType.other;
                                String dcrString = null;
                                String currentName = lineStructure.getCurrentName();
                                String[] currentNameParts = currentName.split(":");
                                if (currentNameParts.length == 3) {
                                    try {
                                        targetRelation = DataTypes.RelationType.valueOf(currentNameParts[0]);
                                        customType = currentNameParts[1];
                                        dcrString = currentNameParts[2];
                                    }
                                    catch (IllegalArgumentException exception) {
                                        this.appendToTaskOutput("Unsupported Relation Type: " + currentName);
                                    }
                                }
                                currentEntity.entityData.addRelatedNode(this.getEntityDocument(createdNodes, (String)profileId, (String)lineStructure.getLineContents(), (ImportTranslator)importTranslator).entityData, targetRelation, null, null, dcrString, customType);
                                notConsumed = false;
                            }
                            if (notConsumed) {
                                currentEntity.appendValue(lineStructure.getCurrentName(), lineStructure.getLineContents(), lineStructure.getGedcomLevel());
                            }
                        }
                        lineStructure.moveToNextField();
                    }
                }
                for (ImportLineStructure.RelationEntry relationEntry : lineStructure.getRelationList()) {
                    this.getEntityDocument(createdNodes, (String)profileId, (String)relationEntry.egoIdString, (ImportTranslator)importTranslator).entityData.addRelatedNode(this.getEntityDocument(createdNodes, (String)profileId, (String)relationEntry.alterIdString, (ImportTranslator)importTranslator).entityData, relationEntry.relationType, null, null, null, relationEntry.customType);
                }
            }
            super.incrementLineProgress();
        }
        for (ArrayList currentSocialGroup : socialGroupRoleMap.values()) {
            for (SocialMemberElement outerMemberElement : currentSocialGroup) {
                for (SocialMemberElement innerMemberElement : currentSocialGroup) {
                    if (innerMemberElement.memberEntity.equals(outerMemberElement.memberEntity)) continue;
                    if (innerMemberElement.typeString.equals("FAMC") || innerMemberElement.typeString.equals("CHIL")) {
                        if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.sibling, null, null, null, null);
                            continue;
                        }
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.ancestor, null, null, null, null);
                        continue;
                    }
                    if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.descendant, null, null, null, null);
                        continue;
                    }
                    innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.union, null, null, null, null);
                }
            }
        }
        this.saveAllDocuments();
        return createdNodes.toArray(new URI[0]);
    }

    class SocialMemberElement {
        String typeString;
        EntityData memberEntity;

        public SocialMemberElement(String typeString, EntityData memberEntity) {
            this.typeString = typeString;
            this.memberEntity = memberEntity;
        }
    }
}

