/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.DataNodeLoaderThreadManager;
import nl.mpi.arbil.data.MetadataFormat;

public class DefaultDataNodeLoader
implements DataNodeLoader {
    private Hashtable<String, ArbilDataNode> arbilHashTable = new Hashtable();
    private Vector<ArbilDataNode> nodesNeedingSave = new Vector();
    private DataNodeLoaderThreadManager threadManager;
    private ArbilDataNodeService dataNodeService;

    public DefaultDataNodeLoader(DataNodeLoaderThreadManager loaderThreadManager) {
        System.out.println("ArbilDataNodeLoader init");
        this.threadManager = loaderThreadManager;
    }

    protected final void setDataNodeService(ArbilDataNodeService dataNodeService) {
        this.dataNodeService = dataNodeService;
    }

    public ArbilDataNode getArbilDataNodeWithoutLoading(URI localUri) {
        ArbilDataNode currentDataNode = null;
        if (localUri != null && (currentDataNode = this.arbilHashTable.get((localUri = ArbilDataNodeService.normaliseURI(localUri)).toString())) == null) {
            currentDataNode = new ArbilDataNode(this.dataNodeService, localUri);
            this.arbilHashTable.put(localUri.toString(), currentDataNode);
        }
        return currentDataNode;
    }

    public ArbilDataNode getArbilDataNode(Object registeringObject, URI localUri) {
        ArbilDataNode currentDataNode = null;
        if (localUri != null && localUri.toString().length() > 0) {
            currentDataNode = this.getArbilDataNodeWithoutLoading(localUri);
            if (!currentDataNode.getParentDomNode().isDataLoaded() && !currentDataNode.isLoading()) {
                if (ArbilDataNode.isStringChildNode(currentDataNode.getUrlString())) {
                    currentDataNode.getParentDomNode();
                } else if (MetadataFormat.isPathMetadata(currentDataNode.getUrlString()) || ArbilDataNode.isPathHistoryFile(currentDataNode.getUrlString())) {
                    this.threadManager.addNodeToQueue(currentDataNode);
                } else if (!MetadataFormat.isPathMetadata(currentDataNode.getUrlString())) {
                    // empty if block
                }
            }
            if (registeringObject != null && registeringObject instanceof ArbilDataNodeContainer) {
                currentDataNode.registerContainer((ArbilDataNodeContainer)registeringObject);
            }
        }
        return currentDataNode;
    }

    public ArbilDataNode getArbilDataNodeOnlyIfLoaded(URI arbilUri) {
        arbilUri = ArbilDataNodeService.normaliseURI(arbilUri);
        return this.arbilHashTable.get(arbilUri.toString());
    }

    public void requestReloadOnlyIfLoaded(URI arbilUri) {
        ArbilDataNode currentDataNode = this.arbilHashTable.get((arbilUri = ArbilDataNodeService.normaliseURI(arbilUri)).toString());
        if (currentDataNode != null) {
            this.requestReload(currentDataNode);
        }
    }

    public void requestReload(ArbilDataNode currentDataNode) {
        this.requestReload(currentDataNode, ArbilDataNode.LoadingState.LOADED);
    }

    public void requestShallowReload(ArbilDataNode currentDataNode) {
        this.requestReload(currentDataNode, ArbilDataNode.LoadingState.PARTIAL);
    }

    private void requestReload(ArbilDataNode currentDataNode, ArbilDataNode.LoadingState loadingState) {
        if (currentDataNode.isChildNode()) {
            currentDataNode = currentDataNode.getParentDomNode();
        }
        this.removeNodesNeedingSave(currentDataNode);
        if (!ArbilDataNode.LoadingState.LOADED.equals((Object)currentDataNode.getRequestedLoadingState())) {
            currentDataNode.setRequestedLoadingState(loadingState);
        }
        this.threadManager.addNodeToQueue(currentDataNode);
    }

    public void requestReloadAllNodes() {
        for (ArbilDataNode currentDataNode : this.arbilHashTable.values()) {
            this.requestReload(currentDataNode);
        }
    }

    public void startLoaderThreads() {
        this.threadManager.startLoaderThreads();
    }

    public void stopLoaderThreads() {
        this.threadManager.stopLoaderThreads();
    }

    protected void finalize() throws Throwable {
        this.threadManager.setContinueThread(false);
        super.finalize();
    }

    public void addNodeNeedingSave(ArbilDataNode nodeToSave) {
        if (!this.nodesNeedingSave.contains(nodeToSave = nodeToSave.getParentDomNode())) {
            this.nodesNeedingSave.add(nodeToSave);
        }
    }

    public void removeNodesNeedingSave(ArbilDataNode savedNode) {
        this.nodesNeedingSave.remove(savedNode);
    }

    public ArbilDataNode[] getNodesNeedSave() {
        return this.nodesNeedingSave.toArray(new ArbilDataNode[0]);
    }

    public boolean nodesNeedSave() {
        return this.nodesNeedingSave.size() > 0;
    }

    public synchronized void saveNodesNeedingSave(boolean updateIcons) {
        while (this.nodesNeedingSave.size() > 0) {
            ArbilDataNode currentNode = this.nodesNeedingSave.remove(0);
            if (currentNode == null) continue;
            currentNode.saveChangesToCache(updateIcons);
            if (!updateIcons) continue;
            this.requestReload(currentNode);
        }
    }

    public boolean isSchemaCheckLocalFiles() {
        return this.threadManager.isSchemaCheckLocalFiles();
    }

    public void setSchemaCheckLocalFiles(boolean schemaCheckLocalFiles) {
        this.threadManager.setSchemaCheckLocalFiles(schemaCheckLocalFiles);
    }

    public ArbilDataNode createNewDataNode(URI uri) {
        return new ArbilDataNode(this.dataNodeService, uri);
    }

    protected DataNodeLoaderThreadManager getThreadManager() {
        return this.threadManager;
    }
}

