/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.help.HelpIndex;
import nl.mpi.arbil.help.HelpItem;
import nl.mpi.arbil.help.HelpItemsParser;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.util.BugCatcherManager;
import org.xml.sax.SAXException;

public class ArbilHelp
extends JPanel {
    public static final String SHOTCUT_KEYS_PAGE = "Short Cut Keys";
    public static final String INTRODUCTION_PAGE = "2. Quick Introduction";
    public static final String helpWindowTitle = "Help Viewer";
    private final HelpIndex helpIndex;
    private final String helpResourceBase;
    private final DefaultTreeModel helpTreeModel;
    private final DefaultMutableTreeNode rootContentsNode;
    private static ArbilHelp singleInstance = null;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private JTree indexTree;

    public static synchronized ArbilHelp getArbilHelpInstance() throws IOException, SAXException {
        if (singleInstance == null) {
            String helpResourceBase = "/nl/mpi/arbil/resources/html/help/";
            singleInstance = new ArbilHelp(ArbilHelp.class, "/nl/mpi/arbil/resources/html/help/", "/nl/mpi/arbil/resources/html/help/arbil.xml");
        }
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArbilHelp(Class resourcesClass, String helpResourceBase, String indexXml) throws IOException, SAXException {
        this.initComponents();
        this.helpResourceBase = helpResourceBase;
        HelpItemsParser parser = new HelpItemsParser();
        InputStream helpStream = this.getClass().getResourceAsStream(indexXml);
        try {
            this.helpIndex = parser.parse(helpStream);
        }
        finally {
            helpStream.close();
        }
        this.jTextPane1.setContentType("text/html");
        ((HTMLDocument)this.jTextPane1.getDocument()).setBase(this.getClass().getResource(helpResourceBase));
        this.indexTree.getSelectionModel().setSelectionMode(1);
        this.rootContentsNode = new DefaultMutableTreeNode("Contents");
        this.helpTreeModel = new DefaultTreeModel(this.rootContentsNode, true);
        this.indexTree.setModel(this.helpTreeModel);
        this.populateIndex(this.rootContentsNode);
        this.indexTree.setSelectionRow(1);
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode currentNode, String helpPage) {
        System.out.println("currentNode: " + currentNode);
        if (currentNode.getUserObject().toString().equals(helpPage)) {
            return currentNode;
        }
        if (currentNode.getChildCount() >= 0) {
            Enumeration<TreeNode> e = currentNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)e.nextElement();
                DefaultMutableTreeNode foundNode = this.findNode(nextNode, helpPage);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    public void setCurrentPage(String helpPage) {
        DefaultMutableTreeNode foundNode = this.findNode(this.rootContentsNode, helpPage);
        if (foundNode != null) {
            final TreePath targetTreePath = new TreePath(foundNode.getPath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArbilHelp.this.indexTree.scrollPathToVisible(targetTreePath);
                    ArbilHelp.this.indexTree.setSelectionPath(targetTreePath);
                }
            });
        }
    }

    private void populateIndex(DefaultMutableTreeNode root) {
        for (HelpItem item : this.helpIndex.getSubItems()) {
            this.populateIndex(root, item);
        }
        this.helpTreeModel.reload(root);
    }

    private void populateIndex(DefaultMutableTreeNode parent, HelpItem item) {
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(item, item.getSubItems().size() > 0);
        parent.add(itemNode);
        for (HelpItem subItem : item.getSubItems()) {
            this.populateIndex(itemNode, subItem);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.indexTree = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextPane1.addHyperlinkListener(new ArbilHyperlinkListener());
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.indexTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ArbilHelp.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.indexTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTextPane1.setEditable(false);
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        Object nodeInfo;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.indexTree.getLastSelectedPathComponent();
        if (node != null && (nodeInfo = node.getUserObject()) instanceof HelpItem) {
            StringBuilder completeHelpText = new StringBuilder();
            String itemResource = this.helpResourceBase + ((HelpItem)nodeInfo).getFile();
            InputStream itemStream = this.getClass().getResourceAsStream(itemResource);
            if (itemStream == null) {
                completeHelpText.append("Page not found");
            } else {
                BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(itemStream));
                try {
                    String helpLine = bufferedHelpReader.readLine();
                    while (helpLine != null) {
                        completeHelpText.append(helpLine);
                        helpLine = bufferedHelpReader.readLine();
                    }
                }
                catch (IOException ioEx) {
                    completeHelpText.append("<p><strong>I/O exception while reading help contents</strong></p>");
                    BugCatcherManager.getBugCatcher().logError(ioEx);
                }
                finally {
                    try {
                        bufferedHelpReader.close();
                    }
                    catch (IOException ioEx) {
                        completeHelpText.append("<p><strong>I/O exception while close stream</strong></p>");
                        BugCatcherManager.getBugCatcher().logError(ioEx);
                    }
                }
            }
            this.jTextPane1.setText(completeHelpText.toString());
        }
    }
}

